/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.CodeBlockMarkerBlock;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005a\u0001!\u0007\u0003\n\u0005%\t\u0001$\u0001M\u0001C\u000b\t6!\u0001E\u0002KM!1\u0002\u0003\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00041\u000bI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001$A\u0013\r\t-Aa!D\u0001\u0019\u000ee\u0019\u0001rA\u0007\u00021\u0011I2\u0001C\u0004\u000e\u0003a=\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/CodeBlockProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;"}, moduleName="intellij-markdown")
public final class CodeBlockProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        if (stateInfo.getNextConstraints().getCharsEaten(pos.getCurrentLine()) > pos.getOffsetInCurrentLine()) {
            return CollectionsKt.emptyList();
        }
        Integer n = pos.charsToNonWhitespace();
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int charsToNonWhitespace = ((Number)n).intValue();
        LookaheadText.Position position = pos.nextPosition(charsToNonWhitespace);
        if (position == null) {
            return CollectionsKt.emptyList();
        }
        LookaheadText.Position blockStart = position;
        if (MarkdownParserUtil.INSTANCE.hasCodeBlockIndent(blockStart, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.listOf((Object)new CodeBlockMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark()));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }
}

