/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.ListItemMarkerBlock;
import org.intellij.markdown.parser.markerblocks.impl.ListMarkerBlock;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005a\u0001!\u0007\u0003\n\u0005%\t\u0001$\u0001M\u0001C\u000b\t6!\u0001E\u0002KM!1\u0002\u0003\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00041\u000bI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001$A\u0013\r\t-Aa!D\u0001\u0019\u000ee\u0019\u0001rA\u0007\u00021\u0011I2\u0001C\u0004\u000e\u0003a=\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/ListMarkerProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;"}, moduleName="intellij-markdown")
public final class ListMarkerProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        MarkdownConstraints currentConstraints = stateInfo.getCurrentConstraints();
        MarkdownConstraints nextConstraints = stateInfo.getNextConstraints();
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, currentConstraints)) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)nextConstraints, (Object)currentConstraints) ^ true && Intrinsics.areEqual((Object)nextConstraints.getLastType(), (Object)Character.valueOf('>')) ^ true && Intrinsics.areEqual((Object)nextConstraints.getLastExplicit(), (Object)true)) {
            ArrayList<MarkerBlockImpl> result = new ArrayList<MarkerBlockImpl>();
            if (!(stateInfo.getLastBlock() instanceof ListMarkerBlock)) {
                ProductionHolder.Marker marker = productionHolder.mark();
                Character c = nextConstraints.getLastType();
                if (c == null) {
                    Intrinsics.throwNpe();
                }
                result.add(new ListMarkerBlock(nextConstraints, marker, c.charValue()));
            }
            result.add(new ListItemMarkerBlock(nextConstraints, productionHolder.mark()));
            return result;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }
}

