/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IntRange;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\r\u0001A\r\u0011$\u0001M\u0001;\u0003\r\u0011UA)\u0004\u0003!\t\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/LinkParserUtil;", "", "()V", "Companion"}, moduleName="intellij-markdown")
public final class LinkParserUtil {
    public static final Companion Companion = org.intellij.markdown.parser.sequentialparsers.impl.LinkParserUtil$Companion.INSTANCE;

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011?)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001E\u0011\u000b\u0005AA!B\u0001\u0005\u0003\u0011\u0019\u001d\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"A\u0013\u0010\u0011\u0007i!\u0001$\u0001\u0019\u0005e1\u0001RA\u0007\u0005\u0013\tI\u0011\u0001g\u0002\u0019\u0007e\u0019\u0001\u0002B\u0007\u00021\t)c\u0003#\u0003\u000e\u00051\u0005\u0001DA\r\u0007\u0011\u000biA!\u0003\u0002\n\u0003a\u001d\u0001dA\r\u0007\u0011\u0015iA!\u0003\u0002\n\u0003a1\u00014B\r\u0004\u0011\u0011i\u0011\u0001\u0007\u0002&-!5QB\u0001G\u00011\tIb\u0001#\u0002\u000e\t%\u0011\u0011\"\u0001M\u00041\rIb\u0001C\u0003\u000e\t%\u0011\u0011\"\u0001\r\u00071\u0017I2\u0001\u0003\u0003\u000e\u0003a\u0011Qe\u0004\u0005\b\u001b\ta\t\u0001\u0007\u0002\u001a\r!\u0015Q\u0002B\u0005\u0003\u0013\u0005A:\u0001G\u0002\u001a\u0007!!Q\"\u0001\r\u0003"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/LinkParserUtil$Companion;", "", "()V", "parseLinkDestination", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "result", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "iterator", "parseLinkLabel", "delegateIndices", "", "", "parseLinkText", "parseLinkTitle"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @Nullable
        public final TokensCache.Iterator parseLinkDestination(@NotNull Collection<SequentialParser.Node> result, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getEOL()) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRPAREN())) {
                return null;
            }
            int startIndex = it.getIndex();
            boolean withBraces = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLT());
            if (withBraces) {
                it = it.advance();
            }
            boolean hasOpenedParentheses = false;
            while (!(it.getType() == null || withBraces && Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getGT()))) {
                if (!withBraces) {
                    if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLPAREN())) {
                        if (hasOpenedParentheses) break;
                        hasOpenedParentheses = true;
                    }
                    IElementType next = it.rawLookup(1);
                    if (SequentialParserUtil.Companion.isWhitespace(it, 1) || next == null) break;
                    if (Intrinsics.areEqual((Object)next, (Object)MarkdownTokenTypes.Companion.getRPAREN())) {
                        if (!hasOpenedParentheses) break;
                        hasOpenedParentheses = false;
                    }
                }
                it = it.advance();
            }
            if (it.getType() != null && !hasOpenedParentheses) {
                result.add(new SequentialParser.Node((Range<Integer>)((Range)new IntRange(startIndex, it.getIndex() + 1)), MarkdownElementTypes.Companion.getLINK_DESTINATION()));
                return it;
            }
            return null;
        }

        @Nullable
        public final TokensCache.Iterator parseLinkLabel(@NotNull Collection<SequentialParser.Node> result, @NotNull List<Integer> delegateIndices, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull(delegateIndices, (String)"delegateIndices");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET()) ^ true) {
                return null;
            }
            int startIndex = it.getIndex();
            ArrayList<Integer> indicesToDelegate = new ArrayList<Integer>();
            it = it.advance();
            while (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRBRACKET()) ^ true && it.getType() != null) {
                indicesToDelegate.add(it.getIndex());
                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET())) break;
                it = it.advance();
            }
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRBRACKET())) {
                int endIndex = it.getIndex();
                if (endIndex == startIndex + 1) {
                    return null;
                }
                result.add(new SequentialParser.Node((Range<Integer>)((Range)new IntRange(startIndex, endIndex + 1)), MarkdownElementTypes.Companion.getLINK_LABEL()));
                delegateIndices.addAll((Collection<Integer>)indicesToDelegate);
                return it;
            }
            return null;
        }

        @Nullable
        public final TokensCache.Iterator parseLinkText(@NotNull Collection<SequentialParser.Node> result, @NotNull List<Integer> delegateIndices, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull(delegateIndices, (String)"delegateIndices");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET()) ^ true) {
                return null;
            }
            int startIndex = it.getIndex();
            ArrayList<Integer> indicesToDelegate = new ArrayList<Integer>();
            int bracketDepth = 1;
            it = it.advance();
            while (!(it.getType() == null || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRBRACKET()) && --bracketDepth == 0)) {
                indicesToDelegate.add(it.getIndex());
                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET())) {
                    ++bracketDepth;
                }
                it = it.advance();
            }
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRBRACKET())) {
                result.add(new SequentialParser.Node((Range<Integer>)((Range)new IntRange(startIndex, it.getIndex() + 1)), MarkdownElementTypes.Companion.getLINK_TEXT()));
                delegateIndices.addAll((Collection<Integer>)indicesToDelegate);
                return it;
            }
            return null;
        }

        @Nullable
        public final TokensCache.Iterator parseLinkTitle(@NotNull Collection<SequentialParser.Node> result, @NotNull TokensCache.Iterator iterator) {
            IElementType closingType;
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator it = iterator;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getEOL())) {
                return null;
            }
            int startIndex = it.getIndex();
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getSINGLE_QUOTE()) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getDOUBLE_QUOTE())) {
                closingType = it.getType();
            } else if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getLPAREN())) {
                closingType = MarkdownTokenTypes.Companion.getRPAREN();
            } else {
                return null;
            }
            it = it.advance();
            while (it.getType() != null && Intrinsics.areEqual((Object)it.getType(), (Object)closingType) ^ true) {
                it = it.advance();
            }
            if (it.getType() != null) {
                result.add(new SequentialParser.Node((Range<Integer>)((Range)new IntRange(startIndex, it.getIndex() + 1)), MarkdownElementTypes.Companion.getLINK_TITLE()));
                return it;
            }
            return null;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

