/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library.remote;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.FutureResult;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.remote.MavenRemoteTask;

public abstract class MavenRemoteManager<Result, Argument, RemoteTask extends MavenRemoteTask<Result, Argument>>
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.maven.utils.library.remote.MavenRemoteManager");
    private Deque<DequeItem<Result, Argument, RemoteTask>> tasks = new ArrayDeque<DequeItem<Result, Argument, RemoteTask>>();
    private boolean busy;

    protected MavenRemoteManager(Project project) {
        super(project);
    }

    public synchronized boolean busy() {
        return this.busy;
    }

    protected synchronized void schedule(@NotNull RemoteTask task, @NotNull Argument argument, MavenRemoteTask.ResultProcessor<Result> resultProcessor, boolean force) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager", "schedule"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager", "schedule"));
        }
        DequeItem dequeItem = new DequeItem((MavenRemoteTask)task, argument, resultProcessor, null);
        if (!this.busy) {
            this.tasks.addFirst(dequeItem);
            this.startNextTask();
            return;
        }
        if (force) {
            this.tasks.addFirst(dequeItem);
        } else {
            this.tasks.addLast(dequeItem);
        }
    }

    protected Future<Result> schedule(@NotNull RemoteTask task, @NotNull Argument argument) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager", "schedule"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager", "schedule"));
        }
        final FutureResult future = new FutureResult();
        this.schedule(task, argument, new MavenRemoteTask.ResultProcessor<Result>(){

            @Override
            public void process(Result result) {
                future.set(result);
            }
        }, true);
        return future;
    }

    protected Result getSynchronously(@NotNull RemoteTask task, @NotNull Argument argument) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager", "getSynchronously"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager", "getSynchronously"));
        }
        try {
            return this.schedule(task, argument).get();
        }
        catch (InterruptedException e) {
            LOG.error("Got unexpected exception during maven remote task", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error("Got unexpected exception during maven remote task", (Throwable)e);
        }
        return null;
    }

    protected Result getSynchronouslyWithModal(@NotNull RemoteTask task, @NotNull Argument argument, String title) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager", "getSynchronouslyWithModal"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager", "getSynchronouslyWithModal"));
        }
        Ref result = Ref.create();
        new Task.Modal(this.myProject, title, false, (MavenRemoteTask)task, argument, result){
            final /* synthetic */ MavenRemoteTask val$task;
            final /* synthetic */ Object val$argument;
            final /* synthetic */ Ref val$result;
            {
                this.val$task = mavenRemoteTask;
                this.val$argument = object;
                this.val$result = ref;
                super(arg0, arg1, arg2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager$2", "run"));
                }
                indicator.setText(this.val$task.getName(this.val$argument));
                this.val$result.set(MavenRemoteManager.this.getSynchronously(this.val$task, this.val$argument));
            }
        }.queue();
        return (Result)result.get();
    }

    private synchronized void startNextTask() {
        this.busy = true;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.startTask();
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MavenRemoteManager.this.startTask();
                }
            }, ModalityState.any());
        }
    }

    private synchronized void startTask() {
        final DequeItem<Result, Argument, RemoteTask> item = this.tasks.pollFirst();
        boolean bl = this.busy = item != null;
        if (item == null) {
            return;
        }
        new Task.Backgroundable(this.myProject, "Maven", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager$4", "run"));
                }
                indicator.setText(item.getTask().getName(item.getArgument()));
                Object result = null;
                try {
                    result = item.getTask().execute(item.getArgument(), indicator);
                }
                catch (Exception exc) {
                    LOG.error("Exception during maven remote task", (Throwable)exc);
                }
                MavenRemoteTask.ResultProcessor<Object> resultProcessor = item.getResultProcessor();
                if (resultProcessor != null) {
                    resultProcessor.process(result);
                }
                MavenRemoteManager.this.startNextTask();
            }
        }.queue();
    }

    private static class DequeItem<Result, Argument, Task extends MavenRemoteTask<Result, Argument>> {
        @NotNull
        private final Task task;
        @NotNull
        private final Argument argument;
        @Nullable
        private final MavenRemoteTask.ResultProcessor<Result> resultProcessor;

        private DequeItem(@NotNull Task task, @NotNull Argument argument, @Nullable MavenRemoteTask.ResultProcessor<Result> processor) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager$DequeItem", "<init>"));
            }
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager$DequeItem", "<init>"));
            }
            this.task = task;
            this.argument = argument;
            this.resultProcessor = processor;
        }

        @NotNull
        public Task getTask() {
            Task Task2 = this.task;
            if (Task2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager$DequeItem", "getTask"));
            }
            return Task2;
        }

        @NotNull
        public Argument getArgument() {
            Argument Argument2 = this.argument;
            if (Argument2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/remote/MavenRemoteManager$DequeItem", "getArgument"));
            }
            return Argument2;
        }

        @Nullable
        public MavenRemoteTask.ResultProcessor<Result> getResultProcessor() {
            return this.resultProcessor;
        }

        /* synthetic */ DequeItem(MavenRemoteTask x0, Object x1, MavenRemoteTask.ResultProcessor x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

