/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.AtxHeaderMarkerBlock;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0005\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001\u0001\u0004\u0001\u0011\u0016e!\u0011BA\u0005\u00021\u0005A\n!(A\u000bC\u000b\t6!\u0001E\u0002K1!\u0011\u0001\u0003\u0002\u000e\u0003a\u0015\u0011d\u0001\u0005\u0004\u001b\u0005A:!G\u0002\t\t5\t\u0001TA\u0013\u0014\t-AI!\u0004\u0003\n\u0005%\t\u00014\u0002\r\u00063\rA1!D\u0001\u0019\be\u0019\u0001BB\u0007\u00021\u001bI2\u0001C\u0004\u000e\u0003a\tQ\u0005\u0004\u0003\f\u0011\u001fi\u0011\u0001\u0007\u0005\u001a\u0007!\u0019Q\"\u0001M\u00043\rA\t\"D\u0001\u0019\u0013\u0015bA!\u0001E\n\u001b\u0015I!!C\u0001\u0019\u00061\u0005\u0001DC\r\u0004\u0011\ri\u0011\u0001g\u0002"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/AtxHeaderProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "calcTailStartPos", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "headerSize", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "Lkotlin/Range;", "Companion"}, moduleName="intellij-markdown")
public final class AtxHeaderProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Regex REGEX;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.parser.markerblocks.providers.AtxHeaderProvider$Companion.INSTANCE;
        REGEX = new Regex("^ {0,3}(#{1,6})( |$)");
    }

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        Range<Integer> headerRange = this.matches(pos);
        if (headerRange != null) {
            return CollectionsKt.listOf((Object)new AtxHeaderMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, headerRange, this.calcTailStartPos(pos, ((Number)((Object)headerRange.getEnd())).intValue()), pos.getNextLineOrEofOffset()));
        }
        return CollectionsKt.emptyList();
    }

    private final int calcTailStartPos(LookaheadText.Position pos, int headerSize) {
        int offset;
        CharSequence line = pos.getCurrentLineFromPosition();
        for (offset = line.length() - 1; offset > headerSize && Character.isWhitespace(line.charAt(offset)); --offset) {
        }
        while (offset > headerSize && line.charAt(offset) == '#' && line.charAt(offset - 1) != '\\') {
            --offset;
        }
        if (offset + 1 < line.length() && Character.isWhitespace(line.charAt(offset)) && line.charAt(offset + 1) == '#') {
            return pos.getOffset() + offset + 1;
        }
        return pos.getOffset() + line.length();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return this.matches(pos) != null;
    }

    private final Range<Integer> matches(LookaheadText.Position pos) {
        MatchResult matchResult;
        if (pos.getOffsetInCurrentLine() != -1 && (matchResult = Regex.find$default((Regex)Companion.getREGEX(), (CharSequence)pos.getCurrentLineFromPosition(), (int)0, (int)2)) != null) {
            MatchGroup matchGroup = matchResult.getGroups().get(1);
            if (matchGroup == null) {
                Intrinsics.throwNpe();
            }
            return (Range)matchGroup.getRange();
        }
        return null;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!K\u0006\u0005\u0007\"A\u0019!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011AQ\u0001\u0005\u0004"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/AtxHeaderProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

