/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.sync;

import com.google.common.collect.Maps;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SyncEntityDataComparisonStrategy {
    @NotNull
    private final Map<Key<?>, EqualityStrategy<?>> myStrategies = Maps.newHashMap();

    public SyncEntityDataComparisonStrategy() {
        this.myStrategies.put(ProjectKeys.PROJECT, new ProjectStrategy());
        this.myStrategies.put(ProjectKeys.MODULE, new ModuleStrategy());
        this.myStrategies.put(ProjectKeys.MODULE_DEPENDENCY, new ModuleDependencyStrategy());
    }

    public boolean isSameNode(@NotNull DataNode<?> node1, @NotNull DataNode<?> node2, @NotNull Project project) {
        if (node1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node1", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy", "isSameNode"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node2", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy", "isSameNode"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy", "isSameNode"));
        }
        Key key = node1.getKey();
        if (!key.equals((Object)node2.getKey())) {
            return false;
        }
        EqualityStrategy<?> strategy = this.myStrategies.get(key);
        if (strategy == null) {
            return node1.getData().equals(node2.getData());
        }
        return strategy.isSameData(node1.getData(), node2.getData(), project);
    }

    private class ModuleDependencyStrategy
    implements EqualityStrategy<ModuleDependencyData> {
        private ModuleDependencyStrategy() {
        }

        @Override
        public boolean isSameData(@NotNull ModuleDependencyData data1, @NotNull ModuleDependencyData data2, @NotNull Project project) {
            if (data1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data1", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy$ModuleDependencyStrategy", "isSameData"));
            }
            if (data2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data2", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy$ModuleDependencyStrategy", "isSameData"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy$ModuleDependencyStrategy", "isSameData"));
            }
            EqualityStrategy strategy = (EqualityStrategy)SyncEntityDataComparisonStrategy.this.myStrategies.get(ProjectKeys.MODULE);
            if (strategy == null) {
                assert (false);
                return false;
            }
            if (strategy.isSameData(data1.getOwnerModule(), data2.getOwnerModule(), project)) {
                return false;
            }
            return strategy.isSameData(data1.getTarget(), data2.getTarget(), project);
        }
    }

    private static class ModuleStrategy
    implements EqualityStrategy<ModuleData> {
        private ModuleStrategy() {
        }

        @Override
        public boolean isSameData(@NotNull ModuleData data1, @NotNull ModuleData data2, @NotNull Project project) {
            if (data1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data1", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy$ModuleStrategy", "isSameData"));
            }
            if (data2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data2", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy$ModuleStrategy", "isSameData"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy$ModuleStrategy", "isSameData"));
            }
            IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(project);
            Module ideModule = modelsProvider.findIdeModule(data1);
            if (ideModule == null) {
                return false;
            }
            return data2.getInternalName().equals(ideModule.getName());
        }
    }

    private static class ProjectStrategy
    implements EqualityStrategy<ProjectData> {
        private ProjectStrategy() {
        }

        @Override
        public boolean isSameData(@NotNull ProjectData data1, @NotNull ProjectData data2, @NotNull Project project) {
            if (data1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data1", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy$ProjectStrategy", "isSameData"));
            }
            if (data2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data2", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy$ProjectStrategy", "isSameData"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/sync/SyncEntityDataComparisonStrategy$ProjectStrategy", "isSameData"));
            }
            return true;
        }
    }

    private static interface EqualityStrategy<T> {
        public boolean isSameData(@NotNull T var1, @NotNull T var2, @NotNull Project var3);
    }
}

