/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.table.TableModelEditor;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadOnlySourcesManager;
import org.jetbrains.settingsRepository.ReadonlySource;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001E\t\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\t\u0001\u0002A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u00031\tQ\u0012\u0003\u0003\u0001\u0011\u000fiA!\u0003\u0002\n\u0003a%\u0001\u0004\u0002+\u0004\u0007E\u001dB!\u0011\u0005\t\u00015Y\u0011\"C\u0005\t\u0013\tI\u0011\u0001g\u0001\n\u0007\u0011\u0005\u0011\"\u0001\r\u00031\u0005A\n!U\u0002\u0003\u000b\u0005A)\u0001V\u0002\u0004"}, strings={"COLUMNS", "", "Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "Lorg/jetbrains/settingsRepository/ReadonlySource;", "", "[Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "ReadOnlySourcesEditorKt", "createReadOnlySourcesEditor", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;"}, moduleName="settings-repository")
public final class ReadOnlySourcesEditorKt {
    private static final TableModelEditor.EditableColumnInfo<ReadonlySource, ? extends Object>[] COLUMNS = new TableModelEditor.EditableColumnInfo[]{(TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, Boolean>(){

        @NotNull
        public Class<Boolean> getColumnClass() {
            return Boolean.TYPE;
        }

        @NotNull
        public Boolean valueOf(@NotNull ReadonlySource item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return item.getActive();
        }

        public void setValue(@NotNull ReadonlySource item, boolean value) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            item.setActive(value);
        }
    }, (TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, String>(){

        @Nullable
        public String valueOf(@NotNull ReadonlySource item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return item.getUrl();
        }

        public void setValue(@NotNull ReadonlySource item, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            item.setUrl(value);
        }
    }};

    @NotNull
    public static final ConfigurableUi<IcsSettings> createReadOnlySourcesEditor() {
        TableModelEditor.DialogItemEditor<ReadonlySource> itemEditor2 = new TableModelEditor.DialogItemEditor<ReadonlySource>(){

            @NotNull
            public ReadonlySource clone(@NotNull ReadonlySource item, boolean forInPlaceEditing) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return new ReadonlySource(item.getUrl(), item.getActive());
            }

            @NotNull
            public Class<ReadonlySource> getItemClass() {
                return ReadonlySource.class;
            }

            public void edit(@NotNull ReadonlySource item, @NotNull Function<ReadonlySource, ReadonlySource> mutator, boolean isAdd) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Intrinsics.checkParameterIsNotNull(mutator, (String)"mutator");
                DialogBuilder dialogBuilder = new DialogBuilder();
                TextFieldWithBrowseButton urlField = new TextFieldWithBrowseButton(new JTextField(20));
                urlField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor()));
                urlField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(urlField, dialogBuilder){
                    final /* synthetic */ TextFieldWithBrowseButton $urlField;
                    final /* synthetic */ DialogBuilder $dialogBuilder;

                    protected void textChanged(@NotNull DocumentEvent event) {
                        boolean enabled;
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        String url = StringUtil.nullize((String)this.$urlField.getText());
                        try {
                            enabled = url != null && CollectionsKt.length((CharSequence)url) > 1 && IcsManagerKt.getIcsManager().getRepositoryService().checkUrl(url, null);
                        }
                        catch (Exception e) {
                            enabled = false;
                        }
                        this.$dialogBuilder.setOkActionEnabled(enabled);
                    }
                    {
                        this.$urlField = $captured_local_variable$0;
                        this.$dialogBuilder = $captured_local_variable$1;
                    }
                });
                dialogBuilder.title("Add read-only source").resizable(false).centerPanel((JComponent)FormBuilder.createFormBuilder().addLabeledComponent("URL:", (JComponent)urlField).getPanel()).setPreferredFocusComponent((JComponent)urlField);
                if (dialogBuilder.showAndGet()) {
                    ((ReadonlySource)mutator.fun((Object)item)).setUrl(urlField.getText());
                }
            }

            public void applyEdited(@NotNull ReadonlySource oldItem, @NotNull ReadonlySource newItem) {
                Intrinsics.checkParameterIsNotNull((Object)oldItem, (String)"oldItem");
                Intrinsics.checkParameterIsNotNull((Object)newItem, (String)"newItem");
                newItem.setUrl(oldItem.getUrl());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }
        };
        TableModelEditor editor = new TableModelEditor((ColumnInfo[])COLUMNS, (CollectionItemEditor)itemEditor2, "No sources configured");
        editor.reset(IcsManagerKt.getIcsManager().getSettings().getReadOnlySources());
        return (ConfigurableUi)new ConfigurableUi<IcsSettings>(editor){
            final /* synthetic */ TableModelEditor $editor;

            public boolean isModified(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return this.$editor.isModified();
            }

            /*
             * WARNING - void declaration
             */
            public void apply(@NotNull IcsSettings settings) {
                void $receiver;
                THashSet tHashSet;
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                List<ReadonlySource> oldList = settings.getReadOnlySources();
                Collection collection = oldList;
                THashSet tHashSet2 = tHashSet;
                THashSet tHashSet3 = tHashSet;
                int n = $receiver.size();
                tHashSet2(n);
                THashSet toDelete = tHashSet3;
                for (ReadonlySource oldSource : oldList) {
                    ContainerUtil.addIfNotNull((Collection)((Collection)toDelete), (Object)oldSource.getPath());
                }
                THashSet toCheckout = new THashSet();
                List newList = this.$editor.apply();
                for (ReadonlySource newSource : newList) {
                    String path = newSource.getPath();
                    if (path == null || toDelete.remove((Object)path)) continue;
                    toCheckout.add((Object)newSource);
                }
                if (toDelete.isEmpty() && toCheckout.isEmpty()) {
                    return;
                }
                ProgressManager.getInstance().run((Task)new Task.Modal(toDelete, toCheckout, newList, null, IcsBundleKt.icsMessage("task.sync.title", new Object[0]), true){
                    final /* synthetic */ THashSet $toDelete;
                    final /* synthetic */ THashSet $toCheckout;
                    final /* synthetic */ List $newList;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        indicator.setIndeterminate(true);
                        File root = IcsManagerKt.getIcsManager().getReadOnlySourcesManager().getRootDir();
                        if (CollectionsKt.isNotEmpty((Collection)((Collection)this.$toDelete))) {
                            indicator.setText("Deleting old repositories");
                            for (String path : this.$toDelete) {
                                indicator.checkCanceled();
                                try {
                                    indicator.setText2(path);
                                    FileUtil.delete((File)new File(root, path));
                                }
                                catch (Exception e) {
                                    IcsManagerKt.getLOG().error((Throwable)e);
                                }
                            }
                        }
                        if (CollectionsKt.isNotEmpty((Collection)((Collection)this.$toCheckout))) {
                            for (ReadonlySource source : this.$toCheckout) {
                                indicator.checkCanceled();
                                try {
                                    File dir;
                                    StringBuilder stringBuilder = new StringBuilder().append("Cloning ");
                                    String string = source.getUrl();
                                    if (string == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    indicator.setText(stringBuilder.append(StringUtil.trimMiddle((String)string, (int)255)).toString());
                                    String string2 = source.getPath();
                                    if (string2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    if ((dir = new File(root, string2)).exists()) {
                                        FileUtil.delete((File)dir);
                                    }
                                    String string3 = source.getUrl();
                                    if (string3 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    NotNullLazyValue notNullLazyValue = (NotNullLazyValue)IcsManagerKt.getIcsManager().getCredentialsStore();
                                    ProgressMonitor progressMonitor = JGitProgressMonitorKt.asProgressMonitor(indicator);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)progressMonitor, (String)"indicator.asProgressMonitor()");
                                    GitExKt.cloneBare(string3, dir, (NotNullLazyValue<CredentialsStore>)notNullLazyValue, progressMonitor).close();
                                }
                                catch (Exception e) {
                                    IcsManagerKt.getLOG().error((Throwable)e);
                                }
                            }
                        }
                        ReadOnlySourcesManager readOnlySourcesManager = IcsManagerKt.getIcsManager().getReadOnlySourcesManager();
                        List list = this.$newList;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"newList");
                        readOnlySourcesManager.setSources(list);
                    }
                    {
                        this.$toDelete = $captured_local_variable$0;
                        this.$toCheckout = $captured_local_variable$1;
                        this.$newList = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                    }
                });
            }

            public void reset(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                this.$editor.reset(settings.getReadOnlySources());
            }

            @NotNull
            public JComponent getComponent() {
                return this.$editor.createComponent();
            }
            {
                this.$editor = $captured_local_variable$0;
            }
        };
    }
}

