/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.DefaultMenuLayout;
import org.jetbrains.annotations.NotNull;

public class JBPopupMenu
extends JPopupMenu {
    @Override
    public final void updateUI() {
        super.updateUI();
        this.setLayout(new MyLayout(this));
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (!(mgr instanceof MyLayout)) {
            return;
        }
        super.setLayout(mgr);
    }

    @Override
    public void paint(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g);
        super.paint(g);
        LayoutManager layout = this.getLayout();
        if (layout instanceof MyLayout) {
            ((MyLayout)layout).paintIfNeed(g);
        }
    }

    private static class MyLayout
    extends DefaultMenuLayout
    implements ActionListener {
        private JPopupMenu myTarget;
        int myShift = 0;
        int myScrollDirection = 0;
        Timer myTimer;
        private Color[] dim = new Color[]{JBColor.background(), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.9), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.8), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.7), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.6), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.5), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.4), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.3), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.2), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.1)};

        public MyLayout(JPopupMenu target) {
            super(target, 3);
            this.myTarget = target;
            this.myTimer = new Timer(40, this);
            this.myTarget.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    MyLayout.this.switchTimer(true);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    MyLayout.this.switchTimer(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    MyLayout.this.switchTimer(false);
                }
            });
            if (this.myTarget.isVisible()) {
                this.switchTimer(true);
            }
        }

        private void switchTimer(boolean on) {
            if (on && !this.myTimer.isRunning()) {
                this.myTimer.start();
            }
            if (!on && this.myTimer.isRunning()) {
                this.myTimer.stop();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.myTarget.isShowing()) {
                return;
            }
            PointerInfo info = MouseInfo.getPointerInfo();
            if (info == null) {
                return;
            }
            Point mouseLocation = info.getLocation();
            Point targetLocation = this.myTarget.getLocationOnScreen();
            if (mouseLocation.x < targetLocation.x || mouseLocation.x > targetLocation.x + this.myTarget.getWidth()) {
                return;
            }
            this.myScrollDirection = Math.abs(mouseLocation.y - targetLocation.y - this.getMaxHeight()) < 10 ? 1 : (Math.abs(mouseLocation.y - targetLocation.y) < 10 ? -1 : 0);
            if (this.myScrollDirection == 0) {
                this.myTarget.revalidate();
                this.myTarget.repaint();
                return;
            }
            SwingUtilities.convertPointFromScreen(mouseLocation, this.myTarget);
            this.myTarget.dispatchEvent(new MouseEvent(this.myTarget, 504, System.currentTimeMillis(), 0, mouseLocation.x, mouseLocation.y, 0, false));
            int newShift = this.myShift + 5 * this.myScrollDirection;
            newShift = Math.max(0, Math.min(super.preferredLayoutSize((Container)this.myTarget).height - this.getMaxHeight(), newShift));
            if (newShift != this.myShift) {
                this.myShift = newShift;
                this.myTarget.revalidate();
                this.myTarget.repaint();
            }
        }

        public void paintIfNeed(Graphics g) {
            int i;
            if (this.myShift > 0) {
                for (i = 0; i < this.dim.length; ++i) {
                    g.setColor(this.dim[i]);
                    g.drawLine(0, i, this.myTarget.getWidth(), i);
                }
                AllIcons.General.SplitUp.paintIcon(this.myTarget, g, this.myTarget.getWidth() / 2 - AllIcons.General.SplitUp.getIconWidth() / 2, 0);
            }
            if (super.preferredLayoutSize((Container)this.myTarget).height - this.getMaxHeight() - this.myShift > 0) {
                for (i = 0; i < this.dim.length; ++i) {
                    g.setColor(this.dim[i]);
                    g.drawLine(0, this.myTarget.getHeight() - i, this.myTarget.getWidth(), this.myTarget.getHeight() - i);
                }
                AllIcons.General.SplitDown.paintIcon(this.myTarget, g, this.myTarget.getWidth() / 2 - AllIcons.General.SplitDown.getIconWidth() / 2, this.myTarget.getHeight() - AllIcons.General.SplitDown.getIconHeight());
            }
        }

        @Override
        public void layoutContainer(Container target) {
            Insets insets = target.getInsets();
            int width = target.getWidth() - insets.left - insets.right;
            Component[] components = target.getComponents();
            int y = -this.myShift + insets.top;
            for (Component component : components) {
                int height = component.getPreferredSize().height;
                component.setBounds(insets.left, y, width, height);
                y += height;
            }
        }

        private int getMaxHeight() {
            GraphicsConfiguration configuration = this.myTarget.getGraphicsConfiguration();
            if (configuration == null && this.myTarget.getInvoker() != null) {
                configuration = this.myTarget.getInvoker().getGraphicsConfiguration();
            }
            if (configuration == null) {
                return Short.MAX_VALUE;
            }
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle(configuration);
            return screenRectangle.height;
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(Container target) {
            Dimension dimension = super.preferredLayoutSize(target);
            dimension.height = Math.min(this.getMaxHeight(), dimension.height);
            Dimension dimension2 = dimension;
            if (dimension2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/JBPopupMenu$MyLayout", "preferredLayoutSize"));
            }
            return dimension2;
        }
    }
}

