/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.CharIterator;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0005G\u0006a\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ\u0005\u0006\u0003\f\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u0003\u000e\u0003a1Q\u0005\u0004E\u0007\u001b\u0005A\"!\u0007\u0003\t\u000f5\u0011A\u0012\u0001M\b3\rAI!D\u0001\u0019\u000b\u0015Z\u0001\u0002C\u0007\u00021\tI2\u0001#\u0002\u000e\u0003aE\u0011d\u0001E\u0005\u001b\u0005AR\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/UnderscoreChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkIdentifier", "identifier", "Lcom/intellij/psi/PsiElement;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;"}, moduleName="kotlin-compiler")
public final class UnderscoreChecker
implements DeclarationChecker {
    public static final UnderscoreChecker INSTANCE;
    public static final UnderscoreChecker INSTANCE$;

    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
            if (identifier == null || StringsKt.isEmpty(identifier.getText())) {
                return;
            }
            String $receiver = identifier.getText();
            CharIterator charIterator = StringsKt.iterator($receiver);
            while (charIterator.hasNext()) {
                char element = charIterator.nextChar();
                char it = element;
                if (it == '_') continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            diagnosticHolder.report(Errors.UNDERSCORE_IS_RESERVED.on(identifier));
        }
    }

    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        this.checkIdentifier(declaration.getNameIdentifier(), diagnosticHolder);
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        if (declaration instanceof KtCallableDeclaration) {
            for (KtParameter parameter : ((KtCallableDeclaration)declaration).getValueParameters()) {
                KtNamedDeclaration ktNamedDeclaration = parameter;
                Intrinsics.checkExpressionValueIsNotNull(ktNamedDeclaration, "parameter");
                this.checkNamed(ktNamedDeclaration, diagnosticHolder);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            for (KtTypeParameter typeParameter : ((KtTypeParameterListOwner)declaration).getTypeParameters()) {
                KtNamedDeclaration ktNamedDeclaration = typeParameter;
                Intrinsics.checkExpressionValueIsNotNull(ktNamedDeclaration, "typeParameter");
                this.checkNamed(ktNamedDeclaration, diagnosticHolder);
            }
        }
        if (!(declaration instanceof KtNamedDeclaration)) {
            return;
        }
        this.checkNamed((KtNamedDeclaration)declaration, diagnosticHolder);
    }

    static {
        new UnderscoreChecker();
    }

    private UnderscoreChecker() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

