/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.types.KotlinType;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\u0004\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u000f)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\t\f\u0015\u0001A\u0002A\r\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0002\u0005V\u0011b\u0001E\u0002\u001b\u0005A\u0012!C\u0002\t\u00055\t\u0001TA)\u0004\u0003!\u0019QU\b\u0003\f\u0011\u0019iQ\u0001E\u0004\u0016\u00051\u0005AU\u0002S\u0007#\t!\u0001\u0001#\u0004\u0012\u0005\u0011\u0005\u0001rB\r\n\u0011!iq!\u0003\u0002\n\u0003\u00116\u0011BA\u0005\u0002I\u001fA\n\"G\u0002\t\u00135\tAuB)\u0004\u0003!MQ\u0005\u0003\u0003\u0002\u0011)i\u0011\u0001'\u0006\u001a\u0007!YQ\"\u0001\r\u0002K!!\u0011\u0001c\u0006\u000e\u0003aa\u0011d\u0001\u0005\f\u001b\u0005A\u0012!\n\u0003\u0005\u0017!eQ\"\u0001M\u000bS3!1\n\u0003E\u0004\u001b\u000fAB!U\u0002\u0002\t\u0013\t6\u0001B\u0003\u0001\u001b\t!Q\u0001c\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/constants/CharValue;", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueConstant;", "", "value", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(CLorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/annotations/NotNull;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getPrintablePart", "", "c", "isPrintableUnicode", "", "toString"}, moduleName="kotlin-compiler")
public final class CharValue
extends IntegerValueConstant<Character> {
    @NotNull
    private final KotlinType type;

    @Override
    @NotNull
    public KotlinType getType() {
        return this.type;
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitCharValue(this, data);
    }

    @Override
    @NotNull
    public String toString() {
        return StringsKt.format("\\u%04X ('%s')", ((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue()));
    }

    private final String getPrintablePart(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        return this.isPrintableUnicode(c) ? Character.toString(c) : "?";
    }

    private final boolean isPrintableUnicode(char c) {
        byte t = (byte)Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    public CharValue(char value2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        super(Character.valueOf(value2));
        this.type = builtIns.getCharType();
    }
}

