/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00011\u0001\u0011$\u0001M\u0001C\u000b\t6!\u0001\u0005\u0002KQ!1\u0002c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u0007KA!\u0011\u0001#\u0004\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/OverloadsAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkDeclaration"}, moduleName="kotlin-compiler")
public final class OverloadsAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        if (AnnotationUtilKt.hasJvmOverloadsAnnotation(descriptor2)) {
            this.checkDeclaration(declaration, descriptor2, diagnosticHolder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDeclaration(KtDeclaration declaration, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder) {
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getModality(), (Object)Modality.ABSTRACT)) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_ABSTRACT.on((KtDeclaration)((PsiElement)declaration)));
        } else if (!((CallableDescriptor)descriptor2).getVisibility().isPublicAPI() && Intrinsics.areEqual(((CallableDescriptor)descriptor2).getVisibility(), Visibilities.INTERNAL) ^ true || DescriptorUtils.isLocal(descriptor2)) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_PRIVATE.on((KtDeclaration)((PsiElement)declaration)));
        } else {
            boolean bl;
            block7: {
                void $receiver;
                Iterable iterable = ((CallableDescriptor)descriptor2).getValueParameters();
                for (Object element : $receiver) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element;
                    if (!it.declaresDefaultValue()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (bl) {
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_WITHOUT_DEFAULT_ARGUMENTS.on((KtDeclaration)((PsiElement)declaration)));
            }
        }
    }
}

