/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.holders;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.CustomMembersGenerator;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.holders.DeclarationType;
import org.jetbrains.plugins.groovy.lang.completion.closureParameters.ClosureDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;

public class NonCodeMembersHolder
implements CustomMembersHolder {
    public static final Key<String> DOCUMENTATION = Key.create((String)"GdslDocumentation");
    public static final Key<String> DOCUMENTATION_URL = Key.create((String)"GdslDocumentationUrl");
    private final List<PsiElement> myDeclarations = new ArrayList<PsiElement>();

    public static NonCodeMembersHolder generateMembers(List<Map> methods, PsiFile place) {
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)place, (CachedValueProvider)new CachedValueProvider<Map<List<Map>, NonCodeMembersHolder>>(){

            public CachedValueProvider.Result<Map<List<Map>, NonCodeMembersHolder>> compute() {
                ConcurrentMap map = ContainerUtil.createConcurrentSoftMap();
                return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
        NonCodeMembersHolder result = (NonCodeMembersHolder)map.get(methods);
        if (result == null) {
            result = new NonCodeMembersHolder(methods, (PsiElement)place);
            map.put(methods, result);
        }
        return result;
    }

    private NonCodeMembersHolder(List<Map> data, PsiElement place) {
        PsiManager manager = place.getManager();
        for (Map prop : data) {
            Object decltype = prop.get("declarationType");
            if (decltype == DeclarationType.CLOSURE) {
                PsiElement closureDescriptor = NonCodeMembersHolder.createClosureDescriptor(prop, place, manager);
                if (closureDescriptor == null) continue;
                this.myDeclarations.add(closureDescriptor);
                continue;
            }
            if (decltype == DeclarationType.VARIABLE) {
                this.myDeclarations.add(NonCodeMembersHolder.createVariable(prop, place, manager));
                continue;
            }
            GrLightMethodBuilder method = NonCodeMembersHolder.createMethod(prop, place, manager);
            this.myDeclarations.add(method);
        }
    }

    private static PsiElement createVariable(Map prop, PsiElement place, PsiManager manager) {
        String name = String.valueOf(prop.get("name"));
        String type = String.valueOf(prop.get("type"));
        return new GrLightVariable(manager, name, type, Collections.<PsiElement>emptyList(), (PsiElement)place.getContainingFile());
    }

    @Nullable
    private static PsiElement createClosureDescriptor(Map prop, PsiElement place, PsiManager manager) {
        Object docUrl;
        Object doc;
        ClosureDescriptor closure = new ClosureDescriptor(manager);
        Object method = prop.get("method");
        if (!(method instanceof Map)) {
            return null;
        }
        closure.setMethod((Map)method);
        Object closureParams = prop.get("params");
        if (closureParams instanceof Map) {
            boolean first = true;
            for (Object paramName : ((Map)closureParams).keySet()) {
                Object value = ((Map)closureParams).get(paramName);
                boolean isNamed = first && value instanceof List;
                first = false;
                String typeName = isNamed ? "java.util.Map" : String.valueOf(value);
                closure.addParameter(typeName, String.valueOf(paramName));
            }
        }
        if ((doc = prop.get("doc")) instanceof String) {
            closure.putUserData(DOCUMENTATION, (String)doc);
        }
        if ((docUrl = prop.get("docUrl")) instanceof String) {
            closure.putUserData(DOCUMENTATION_URL, (String)docUrl);
        }
        return closure;
    }

    private static GrLightMethodBuilder createMethod(Map prop, PsiElement place, PsiManager manager) {
        PsiClass foundClass;
        Object qName;
        Object docUrl;
        Object doc;
        Object toThrow;
        Object bindsTo;
        String name = String.valueOf(prop.get("name"));
        GrLightMethodBuilder method = new GrLightMethodBuilder(manager, name).addModifier("public");
        if (Boolean.TRUE.equals(prop.get("constructor"))) {
            method.setConstructor(true);
        } else {
            method.setReturnType(NonCodeMembersHolder.convertToPsiType(String.valueOf(prop.get("type")), place));
        }
        Object params = prop.get("params");
        if (params instanceof Map) {
            boolean first = true;
            for (Object paramName : ((Map)params).keySet()) {
                Object value = ((Map)params).get(paramName);
                boolean isNamed = first && value instanceof List;
                first = false;
                String typeName = isNamed ? "java.util.Map" : String.valueOf(value);
                method.addParameter(String.valueOf(paramName), NonCodeMembersHolder.convertToPsiType(typeName, place), false);
                if (!isNamed) continue;
                HashMap namedParams = ContainerUtil.newHashMap();
                for (Object o : (List)value) {
                    if (!(o instanceof CustomMembersGenerator.ParameterDescriptor)) continue;
                    namedParams.put(((CustomMembersGenerator.ParameterDescriptor)o).name, ((CustomMembersGenerator.ParameterDescriptor)o).descriptor);
                }
                method.setNamedParameters(namedParams);
            }
        }
        if (Boolean.TRUE.equals(prop.get("isStatic"))) {
            method.addModifier("static");
        }
        if ((bindsTo = prop.get("bindsTo")) instanceof PsiElement) {
            method.setNavigationElement((PsiElement)bindsTo);
        }
        if ((toThrow = prop.get("throws")) instanceof List) {
            for (Object o : (List)toThrow) {
                PsiType psiType = NonCodeMembersHolder.convertToPsiType(String.valueOf(o), place);
                if (!(psiType instanceof PsiClassType)) continue;
                method.addException((PsiClassType)psiType);
            }
        }
        if ((doc = prop.get("doc")) instanceof String) {
            method.putUserData(DOCUMENTATION, (String)doc);
        }
        if ((docUrl = prop.get("docUrl")) instanceof String) {
            method.putUserData(DOCUMENTATION_URL, (String)docUrl);
        }
        if ((qName = prop.get("containingClass")) instanceof String && (foundClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass((String)qName, place.getResolveScope())) != null) {
            method.setContainingClass(foundClass);
        }
        return method;
    }

    private static PsiType convertToPsiType(String type, PsiElement place) {
        return JavaPsiFacade.getElementFactory((Project)place.getProject()).createTypeFromText(type, place);
    }

    @Override
    public boolean processMembers(GroovyClassDescriptor descriptor, PsiScopeProcessor processor, ResolveState state) {
        for (PsiElement method : this.myDeclarations) {
            if (processor.execute(method, state)) continue;
            return false;
        }
        return true;
    }
}

