/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;
import org.jetbrains.jps.incremental.storage.StorageOwner;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.jps.build.GeneratedJvmClass;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.incremental.CacheFormatVersion;
import org.jetbrains.kotlin.jps.incremental.ChangesInfo;
import org.jetbrains.kotlin.jps.incremental.DifferenceKind;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl$ConstantsMapExternalizer$WhenMappings;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.jps.incremental.PathCollectionExternalizer;
import org.jetbrains.kotlin.jps.incremental.PathFunctionPair;
import org.jetbrains.kotlin.jps.incremental.PathFunctionPairKeyDescriptor;
import org.jetbrains.kotlin.jps.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.jps.incremental.ProtoMapValue;
import org.jetbrains.kotlin.jps.incremental.ProtoMapValueExternalizer;
import org.jetbrains.kotlin.jps.incremental.StringListExternalizer;
import org.jetbrains.kotlin.jps.incremental.StringToLongMapExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.BasicMap;
import org.jetbrains.kotlin.jps.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.jps.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeaderKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0003\u0011\rQ!\u0001\u0005\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0011\u0017)\u0011\u0001b\u0001\u0006\u0003!yQ\u0001A\u0003\u0002\u0011%)\u0011\u0001\"\u0002\u0006\u00031\tQ!\u0001C\u0003\u000b\u0005A\u0001#B\u0001\u0005\u000e\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u0003\u00111A\u0002\u0001\t.3\u0005A\n!G\u0001\u0019\u0003u1Q6\fX/_?\u0002\f'm\u00193f\u0005V\u0011b\u0001E\u0002\u001b\u0005A\"!C\u0002\t\u00065\t\u0001dA)\u0004\u0003!\u001dQe\u0002E\u0015\u001b\u0005AR#G\u0002\t,5\t\u0001\u0004A\u0013\u0005\t-Aa#D\u0001\u0019+\u0015\u001a\u0001RF\u0007\u00021])C\u0001B\u0006\t05\t\u0001$F\u0013\u0005\t\u000fA\u0001$D\u0001\u0019'\u0015BAa\u0003E\u0019\u001b\u0005AR#G\u0002\t35\t\u00014G\u0013\t\t-A!$D\u0001\u0019'e\u0019\u0001RG\u0007\u00021M)c\u0001C\u000e\u000e\t%\u0011\u0011\"\u0001\r\u00031o)S\u0001B\u0006\t95\u0011A\u0012\u0001M\u001dK%!1\u0002C\u000f\u000e\u00051\u0005\u0001dE\r\u0004\u0011wi\u0011\u0001G\n&\u000f\u0011Y\u0001BH\u0007\u0005\u0013\tI\u0011\u0001G\n\u00198\u0015:Aa\u0003E\u001f\u001b\u0011I!!C\u0001\u0019'a]R%\u0003\u0003\f\u0011}i!\u0001$\u0001\u0019@e\u0019\u0001\u0002I\u0007\u00021M)C\u0002B\u0006\tB5)\u0011BA\u0005\u00021Ma\t\u0001g\u000e\u001a\u0007!\tS\"\u0001\r\u0014K)A\u0019%D\u0001\u0019+e1\u0001BI\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0002\u0019F\u0015\u0002Ba\u0003\u0005$\u001b\u0005AR#G\u0002\tH5\t\u0001dE\r\u0004\u0011\u0011j\u0011\u0001G\n\u001a\u0007!%S\"\u0001\r\u0014Ko!\u0011\u0001C\u0013\u000e\u0003\u0011.\u0013C\u0001\u0003\u0001\u0011\u0019\n\"\u0001\"\u0001\tNEQA!\u0001E&+\u001dI!!C\u0001%M%\u0011\u0011\"\u0001S'11I2\u0001C\u0014\u000e\u0003\u0011.\u0013kA\u0001\tP\u0015\u001a\u0001\u0002K\u0007\u00021U)s\u0001#\u0015\u000e\u0003a9\u0012d\u0001\u0005*\u001b\u0005A\u001a&\n\b\tU5\t\u0001dF\r\u0007\u0011+jA!\u0003\u0002\n\u0003a\u0011\u0001tG\r\u0004\u0011-j\u0011\u0001\u0007\u0002&\u0018\u0011\t\u0001rK\u0007\u00021U)\u0012\u0001G\f\u001a\n!aS\"\u0001M-!\u000e\u0005\u0011f\u0002\u0003B\u0011!!Q\"\u0001\r\u0003#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001\u0012B\u0007\u00021\u0015\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\u0006\u001b\u0005Ab!U\u0002\u0002\u000b\u0001I#\u0002B!\t\u0011\u001biA!\u0003\u0002\n\u0003a\u0001\u0001dB)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!=Q\"\u0001\r\t#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001\u0012C\u0007\u00021%\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\n\u001b\u0005A\"\"U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011+i\u0011\u0001G\u0006R\u0007\u0005)\u0001!\u000b\b\u0005\u0003\"A9\"\u0004\u0005\n\r%)\u0011\"\u0001C\u0002\u0013\u0005!\u0019\u0001\u0007\u0007\u0019\u000fE\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002#\u0007\u000e\u0003ai\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u001c5\t\u0001DD)\u0004\u0003\u0015\u0001\u00116\u0003\u0003B\u0011!uQr\u0001\r\u0003#\u000e\tAaD)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!}Q\"\u0001\r\u0011#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001\u0012E\u0007\u00021E\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\u0012\u001b\u0005A\"#U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u000bi\u0011\u0001G\u0002R\u0007\u0005)\u0001!\u000b\u0007\u0005\u0003\"A)#D\u0001\u0019\u0005U\t\u0001d\u0005\u000f\"#\u000e\u0019QB\u0001C\u0014\u0011Q\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;", "Lorg/jetbrains/jps/incremental/storage/StorageOwner;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "targetDataRoot", "Ljava/io/File;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Ljava/io/File;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "baseDir", "cacheFormatVersion", "Lorg/jetbrains/kotlin/jps/incremental/CacheFormatVersion;", "constantsMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ConstantsMap;", "dependents", "Ljava/util/ArrayList;", "dirtyInlineFunctionsMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyInlineFunctionsMap;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyOutputClassesMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsMap;", "inlinedTo", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsFilesMap;", "maps", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMap;", "multifileClassFacadeMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassFacadeMap;", "multifileClassPartMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassPartMap;", "outputDir", "Lorg/jetbrains/annotations/Nullable;", "packagePartMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$PackagePartMap;", "protoMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ProtoMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$SourceToClassesMap;", "storageFile", "", "getStorageFile", "(Ljava/lang/String;)Ljava/io/File;", "addDependentCache", "", "cache", "clean", "clearCacheForRemovedClasses", "Lorg/jetbrains/kotlin/jps/incremental/ChangesInfo;", "close", "dump", "flush", "memoryCachesOnly", "", "getClassFilePath", "internalClassName", "getFilesToReinline", "", "getModuleMappingData", "", "getMultifileFacade", "partInternalName", "getObsoleteMultifileClasses", "getObsoletePackageParts", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "fqName", "getStableMultifileFacadeParts", "facadeInternalName", "markOutputClassesDirty", "removedAndCompiledSources", "", "registerInline", "fromPath", "jvmSignature", "toPath", "registerMap", "M", "K", "V", "map", "(Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMap;)Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMap;", "saveCacheFormatVersion", "saveFileToCache", "generatedClass", "Lorg/jetbrains/kotlin/jps/build/GeneratedJvmClass;", "saveModuleMappingToCache", "sourceFiles", "file", "logIfSomethingChanged", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Companion", "ConstantsMap", "ConstantsMapExternalizer", "DirtyInlineFunctionsMap", "DirtyOutputClassesMap", "InlineFunctionsFilesMap", "InlineFunctionsMap", "MultifileClassFacadeMap", "MultifileClassPartMap", "PackagePartMap", "ProtoMap", "SourceToClassesMap"}, moduleName="jps-plugin")
public final class IncrementalCacheImpl
implements StorageOwner,
IncrementalCache {
    @NotNull
    public static final String CACHE_EXTENSION = "tab";
    @NotNull
    public static final String PROTO_MAP = "proto";
    @NotNull
    public static final String CONSTANTS_MAP = "constants";
    @NotNull
    public static final String INLINE_FUNCTIONS = "inline-functions";
    @NotNull
    public static final String PACKAGE_PARTS = "package-parts";
    @NotNull
    public static final String MULTIFILE_CLASS_FACADES = "multifile-class-facades";
    @NotNull
    public static final String MULTIFILE_CLASS_PARTS = "multifile-class-parts";
    @NotNull
    public static final String SOURCE_TO_CLASSES = "source-to-classes";
    @NotNull
    public static final String DIRTY_OUTPUT_CLASSES = "dirty-output-classes";
    @NotNull
    public static final String DIRTY_INLINE_FUNCTIONS = "dirty-inline-functions";
    @NotNull
    public static final String INLINED_TO = "inlined-to";
    private static final String MODULE_MAPPING_FILE_NAME = ".kotlin_module";
    private final File baseDir;
    private final ArrayList<BasicMap<?, ?>> maps;
    private final ProtoMap protoMap;
    private final ConstantsMap constantsMap;
    private final InlineFunctionsMap inlineFunctionsMap;
    private final PackagePartMap packagePartMap;
    private final MultifileClassFacadeMap multifileClassFacadeMap;
    private final MultifileClassPartMap multifileClassPartMap;
    private final SourceToClassesMap sourceToClassesMap;
    private final DirtyOutputClassesMap dirtyOutputClassesMap;
    private final DirtyInlineFunctionsMap dirtyInlineFunctionsMap;
    private final InlineFunctionsFilesMap inlinedTo;
    private final CacheFormatVersion cacheFormatVersion;
    private final ArrayList<IncrementalCacheImpl> dependents;
    private final File outputDir;
    private final ModuleBuildTarget target;
    public static final Companion Companion = org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl$Companion.INSTANCE;

    static {
        CACHE_EXTENSION = CACHE_EXTENSION;
        PROTO_MAP = PROTO_MAP;
        CONSTANTS_MAP = CONSTANTS_MAP;
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        PACKAGE_PARTS = PACKAGE_PARTS;
        MULTIFILE_CLASS_FACADES = MULTIFILE_CLASS_FACADES;
        MULTIFILE_CLASS_PARTS = MULTIFILE_CLASS_PARTS;
        SOURCE_TO_CLASSES = SOURCE_TO_CLASSES;
        DIRTY_OUTPUT_CLASSES = DIRTY_OUTPUT_CLASSES;
        DIRTY_INLINE_FUNCTIONS = DIRTY_INLINE_FUNCTIONS;
        INLINED_TO = INLINED_TO;
        MODULE_MAPPING_FILE_NAME = "." + ModuleMapping.Companion.getMAPPING_FILE_EXT();
    }

    private final File getStorageFile(String $receiver) {
        return new File(this.baseDir, $receiver + "." + Companion.getCACHE_EXTENSION());
    }

    private final <K, V, M extends BasicMap<K, V>> M registerMap(M map) {
        this.maps.add(map);
        return map;
    }

    public void registerInline(@NotNull String fromPath, @NotNull String jvmSignature, @NotNull String toPath) {
        Intrinsics.checkParameterIsNotNull((Object)fromPath, (String)"fromPath");
        Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
        Intrinsics.checkParameterIsNotNull((Object)toPath, (String)"toPath");
        this.inlinedTo.add(fromPath, jvmSignature, toPath);
    }

    public final void addDependentCache(@NotNull IncrementalCacheImpl cache) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.dependents.add(cache);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.maps;
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            BasicMap basicMap = (BasicMap)item;
            Collection collection = destination;
            String string = it.dump();
            collection.add(string);
        }
        return StringsKt.join$default((Iterable)((List)var3_3), (String)"\n\n", null, null, (int)0, null, (int)30);
    }

    /*
     * WARNING - void declaration
     */
    public final void markOutputClassesDirty(@NotNull List<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, (String)"removedAndCompiledSources");
        for (File file : removedAndCompiledSources) {
            void $receiver;
            Collection<JvmClassName> classes2 = this.sourceToClassesMap.get(file);
            Iterable iterable = classes2;
            for (Object element : $receiver) {
                JvmClassName it = (JvmClassName)element;
                DirtyOutputClassesMap dirtyOutputClassesMap = this.dirtyOutputClassesMap;
                String string = it.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.internalName");
                dirtyOutputClassesMap.markDirty(string);
            }
            this.sourceToClassesMap.clearOutputsForSource(file);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> getFilesToReinline() {
        void destination;
        void $receiver;
        Object addFilesAffectedByChangedInlineFuns$;
        Object className2;
        THashSet result = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        Object object = MapsKt.iterator(this.dirtyInlineFunctionsMap.getEntries());
        while (object.hasNext()) {
            void $receiver2;
            void $receiver3;
            void $receiver4;
            Map.Entry entry;
            Map.Entry functions2 = entry = (Map.Entry)object.next();
            className2 = (JvmClassName)$receiver4.getKey();
            Map.Entry $i$f$component1 = entry;
            List list = (List)$receiver3.getValue();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            String classFilePath = this.getClassFilePath(string);
            addFilesAffectedByChangedInlineFuns$ = new Function1<IncrementalCacheImpl, Unit>(list, classFilePath, result){
                final /* synthetic */ List $functions;
                final /* synthetic */ String $classFilePath;
                final /* synthetic */ THashSet $result;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull IncrementalCacheImpl cache) {
                    void destination;
                    void $receiver;
                    Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
                    Iterable $receiver2 = this.$functions;
                    Iterable iterable = $receiver2;
                    Collection collection = new ArrayList<E>();
                    for (T element : $receiver) {
                        String it = (String)element;
                        Iterable list = IncrementalCacheImpl.access$getInlinedTo$p(cache).get(this.$classFilePath, it);
                        CollectionsKt.addAll((Collection)destination, (Iterable)list);
                    }
                    List targetFiles = (List)destination;
                    this.$result.addAll((Collection)targetFiles);
                }
                {
                    this.$functions = list;
                    this.$classFilePath = string;
                    this.$result = tHashSet;
                    super(1);
                }
            };
            ((Object)addFilesAffectedByChangedInlineFuns$).invoke(this);
            Iterable iterable = this.dependents;
            for (Object element : $receiver2) {
                IncrementalCacheImpl p1 = (IncrementalCacheImpl)element;
                addFilesAffectedByChangedInlineFuns$.invoke(p1);
            }
        }
        this.dirtyInlineFunctionsMap.clean();
        Iterable $receiver5 = (Iterable)result;
        object = $receiver5;
        className2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver5, (int)10));
        for (Object item : $receiver) {
            void it;
            addFilesAffectedByChangedInlineFuns$ = (String)item;
            void var14_12 = destination;
            File file = new File((String)it);
            var14_12.add(file);
        }
        return (List)destination;
    }

    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        String string = new File(this.outputDir, internalClassName + ".class").getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(outputDir, \"$intern\u2026ame.class\").canonicalPath");
        return string;
    }

    public final void saveCacheFormatVersion() {
        this.cacheFormatVersion.saveIfNeeded();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesInfo saveModuleMappingToCache(@NotNull Collection<? extends File> sourceFiles, @NotNull File file) {
        void $receiver;
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName((String)IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        byte[] byArray = FilesKt.readBytes((File)file);
        JvmClassName jvmClassName3 = jvmClassName2;
        ProtoMap protoMap = this.protoMap;
        Object[] objectArray = new String[0];
        protoMap.process(jvmClassName3, byArray, (String[])objectArray, false, false);
        this.dirtyOutputClassesMap.notDirty(IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Iterable $i$f$emptyArray = sourceFiles;
        for (Object element : $receiver) {
            File it = (File)element;
            SourceToClassesMap sourceToClassesMap = this.sourceToClassesMap;
            JvmClassName jvmClassName4 = jvmClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"jvmClassName");
            sourceToClassesMap.add(it, jvmClassName4);
        }
        return ChangesInfo.Companion.getNO_CHANGES();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesInfo saveFileToCache(@NotNull GeneratedJvmClass generatedClass) {
        Object partNames;
        void $receiver22;
        ChangesInfo changesInfo;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)generatedClass, (String)"generatedClass");
        Object sourceFiles = generatedClass.getSourceFiles();
        LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
        JvmClassName className2 = JvmClassName.byClassId((ClassId)kotlinClass.getClassId());
        String string = className2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
        this.dirtyOutputClassesMap.notDirty(string);
        Iterable iterable = (Iterable)sourceFiles;
        for (Object element : $receiver) {
            File it = (File)element;
            SourceToClassesMap sourceToClassesMap = this.sourceToClassesMap;
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            sourceToClassesMap.add(it, jvmClassName);
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (KotlinClassHeaderKt.isCompatiblePackageFacadeKind((KotlinClassHeader)header)) {
            changesInfo = ProtoMap.process$default(this.protoMap, kotlinClass, true, false, 4);
        } else if (KotlinClassHeaderKt.isCompatibleFileFacadeKind((KotlinClassHeader)header)) {
            void value;
            Object element;
            element = sourceFiles;
            boolean $receiver22 = $receiver22.size() == 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && value == false) {
                String message = "Package part from several source files: " + sourceFiles;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            this.packagePartMap.addPackagePart(jvmClassName);
            changesInfo = ProtoMap.process$default(this.protoMap, kotlinClass, true, false, 4).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass));
        } else if (KotlinClassHeaderKt.isCompatibleMultifileClassKind((KotlinClassHeader)header)) {
            Object object = kotlinClass.getClassHeader().getFilePartClassNames();
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Multifile class has no parts: " + kotlinClass.getClassName())));
            }
            partNames = object;
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            this.multifileClassFacadeMap.add(jvmClassName, (List<? extends String>)partNames);
            changesInfo = this.constantsMap.process(kotlinClass).plus(this.inlineFunctionsMap.process(kotlinClass));
        } else if (KotlinClassHeaderKt.isCompatibleMultifileClassPartKind((KotlinClassHeader)header)) {
            void value;
            partNames = sourceFiles;
            boolean $receiver3 = $receiver22.size() == 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && value == false) {
                String message = "Multifile class part from several source files: " + sourceFiles;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            this.packagePartMap.addPackagePart(jvmClassName);
            String string2 = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"className.internalName");
            String string3 = header.getMultifileClassName();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            this.multifileClassPartMap.add(string2, string3);
            changesInfo = ProtoMap.process$default(this.protoMap, kotlinClass, true, false, 4).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass));
        } else {
            changesInfo = KotlinClassHeaderKt.isCompatibleClassKind((KotlinClassHeader)header) && !header.isLocalClass() ? ProtoMap.process$default(this.protoMap, kotlinClass, false, false, 4).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass)) : ChangesInfo.Companion.getNO_CHANGES();
        }
        ChangesInfo changesInfo2 = changesInfo;
        JvmClassName jvmClassName = className2;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
        this.logIfSomethingChanged(changesInfo2, jvmClassName);
        return changesInfo2;
    }

    private final void logIfSomethingChanged(ChangesInfo $receiver, JvmClassName className2) {
        if (Intrinsics.areEqual((Object)$receiver, (Object)ChangesInfo.Companion.getNO_CHANGES())) {
            return;
        }
        KotlinBuilder.Companion.getLOG().debug(className2 + " is changed: " + $receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesInfo clearCacheForRemovedClasses() {
        void initial;
        ChangesInfo destination;
        Iterable $receiver;
        Iterable $receiver2 = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void p1;
            String string = (String)item;
            void var13_7 = destination;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)p1);
            var13_7.add(jvmClassName);
        }
        List dirtyClasses = CollectionsKt.toList((Iterable)((List)((Object)destination)));
        $receiver = dirtyClasses;
        destination = ChangesInfo.Companion.getNO_CHANGES();
        ChangesInfo accumulator = initial;
        for (Object element : $receiver) {
            void className2;
            JvmClassName $i$a$1 = (JvmClassName)element;
            ChangesInfo info = accumulator;
            ProtoMap protoMap = this.protoMap;
            void v1 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"className");
            boolean bl = protoMap.contains((JvmClassName)v1);
            ConstantsMap constantsMap = this.constantsMap;
            void v4 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"className");
            ChangesInfo newInfo = new ChangesInfo(bl, constantsMap.contains((JvmClassName)v4), false, false, 12, null);
            void v5 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"className");
            this.logIfSomethingChanged(newInfo, (JvmClassName)v5);
            accumulator = info.plus(newInfo);
        }
        ChangesInfo changesInfo = accumulator;
        $receiver = dirtyClasses;
        for (Object element : $receiver) {
            JvmClassName it = (JvmClassName)element;
            ProtoMap protoMap = this.protoMap;
            JvmClassName jvmClassName = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"it");
            protoMap.remove(jvmClassName);
            PackagePartMap packagePartMap = this.packagePartMap;
            JvmClassName jvmClassName2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"it");
            packagePartMap.remove(jvmClassName2);
            MultifileClassFacadeMap multifileClassFacadeMap = this.multifileClassFacadeMap;
            JvmClassName jvmClassName3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"it");
            multifileClassFacadeMap.remove(jvmClassName3);
            MultifileClassPartMap multifileClassPartMap = this.multifileClassPartMap;
            JvmClassName jvmClassName4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"it");
            multifileClassPartMap.remove(jvmClassName4);
            ConstantsMap constantsMap = this.constantsMap;
            JvmClassName jvmClassName5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName5, (String)"it");
            constantsMap.remove(jvmClassName5);
            InlineFunctionsMap inlineFunctionsMap = this.inlineFunctionsMap;
            JvmClassName jvmClassName6 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName6, (String)"it");
            inlineFunctionsMap.remove(jvmClassName6);
        }
        this.dirtyOutputClassesMap.clean();
        return changesInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void destination;
        void $receiver;
        Iterable $receiver2 = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            String it = (String)element;
            PackagePartMap packagePartMap = this.packagePartMap;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(it)");
            if (!packagePartMap.isPackagePart(jvmClassName)) continue;
            destination.add(element);
        }
        List obsoletePackageParts = (List)destination;
        KotlinBuilder.Companion.getLOG().debug("Obsolete package parts: " + obsoletePackageParts);
        return obsoletePackageParts;
    }

    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String fqName) {
        JvmPackagePartProto jvmPackagePartProto;
        Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)fqName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(fqName)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        if (protoMapValue != null) {
            ProtoMapValue $receiver = protoMapValue;
            ProtoMapValue value = $receiver;
            jvmPackagePartProto = new JvmPackagePartProto(value.getBytes(), value.getStrings());
        } else {
            jvmPackagePartProto = null;
        }
        return jvmPackagePartProto;
    }

    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        LinkedHashSet obsoleteMultifileClasses = SetsKt.linkedSetOf((Object[])new String[0]);
        for (String dirtyClass : this.dirtyOutputClassesMap.getDirtyOutputClasses()) {
            String dirtyFacade;
            if (this.multifileClassPartMap.getFacadeName(dirtyClass) == null) {
                continue;
            }
            obsoleteMultifileClasses.add(dirtyFacade);
        }
        KotlinBuilder.Companion.getLOG().debug("Obsolete multifile class facades: " + obsoleteMultifileClasses);
        return obsoleteMultifileClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)facadeInternalName, (String)"facadeInternalName");
        List<String> list = this.multifileClassFacadeMap.getMultifileClassParts(facadeInternalName);
        if (list == null) {
            return null;
        }
        List<String> partNames = list;
        Iterable $receiver2 = partNames;
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            String it = (String)element;
            if (!(!this.dirtyOutputClassesMap.isDirty(it))) continue;
            destination.add(element);
        }
        return (List)destination;
    }

    @Nullable
    public String getMultifileFacade(@NotNull String partInternalName) {
        Intrinsics.checkParameterIsNotNull((Object)partInternalName, (String)"partInternalName");
        return this.multifileClassPartMap.getFacadeName(partInternalName);
    }

    @Nullable
    public byte[] getModuleMappingData() {
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026MODULE_MAPPING_FILE_NAME)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        return (byte[])(protoMapValue != null ? protoMapValue.getBytes() : null);
    }

    public void flush(boolean memoryCachesOnly) {
        Iterable $receiver = this.maps;
        for (Object element : $receiver) {
            BasicMap it = (BasicMap)element;
            it.flush(memoryCachesOnly);
        }
    }

    public void clean() {
        Iterable $receiver = this.maps;
        for (Object element : $receiver) {
            BasicMap it = (BasicMap)element;
            it.clean();
        }
        this.cacheFormatVersion.clean();
    }

    public void close() {
        Iterable $receiver = this.maps;
        for (Object element : $receiver) {
            BasicMap it = (BasicMap)element;
            it.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public IncrementalCacheImpl(@NotNull File targetDataRoot, @NotNull ModuleBuildTarget target) {
        File file;
        void value;
        Intrinsics.checkParameterIsNotNull((Object)targetDataRoot, (String)"targetDataRoot");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.target = target;
        this.baseDir = new File(targetDataRoot, IncrementalCacheImplKt.getCACHE_DIRECTORY_NAME());
        this.maps = CollectionsKt.arrayListOf((Object[])new BasicMap[0]);
        this.protoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(Companion.getPROTO_MAP())));
        this.constantsMap = (ConstantsMap)this.registerMap((BasicMap)new ConstantsMap(this.getStorageFile(Companion.getCONSTANTS_MAP())));
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(Companion.getINLINE_FUNCTIONS())));
        this.packagePartMap = (PackagePartMap)this.registerMap((BasicMap)new PackagePartMap(this.getStorageFile(Companion.getPACKAGE_PARTS())));
        this.multifileClassFacadeMap = (MultifileClassFacadeMap)this.registerMap((BasicMap)new MultifileClassFacadeMap(this.getStorageFile(Companion.getMULTIFILE_CLASS_FACADES())));
        this.multifileClassPartMap = (MultifileClassPartMap)this.registerMap((BasicMap)new MultifileClassPartMap(this.getStorageFile(Companion.getMULTIFILE_CLASS_PARTS())));
        this.sourceToClassesMap = (SourceToClassesMap)this.registerMap((BasicMap)new SourceToClassesMap(this.getStorageFile(Companion.getSOURCE_TO_CLASSES())));
        this.dirtyOutputClassesMap = (DirtyOutputClassesMap)this.registerMap((BasicMap)new DirtyOutputClassesMap(this.getStorageFile(Companion.getDIRTY_OUTPUT_CLASSES())));
        this.dirtyInlineFunctionsMap = (DirtyInlineFunctionsMap)this.registerMap((BasicMap)new DirtyInlineFunctionsMap(this.getStorageFile(Companion.getDIRTY_INLINE_FUNCTIONS())));
        this.inlinedTo = (InlineFunctionsFilesMap)this.registerMap((BasicMap)new InlineFunctionsFilesMap(this.getStorageFile(Companion.getINLINED_TO())));
        this.cacheFormatVersion = new CacheFormatVersion(targetDataRoot);
        this.dependents = CollectionsKt.arrayListOf((Object[])new IncrementalCacheImpl[0]);
        File file2 = this.target.getOutputDir();
        IncrementalCacheImpl incrementalCacheImpl = this;
        if (value == null) {
            String message = "Target is expected to have output directory: " + this.target;
            throw (Throwable)new IllegalArgumentException(message.toString());
        }
        incrementalCacheImpl.outputDir = file = file2;
    }

    @NotNull
    public static final /* synthetic */ InlineFunctionsFilesMap access$getInlinedTo$p(IncrementalCacheImpl $this) {
        return $this.inlinedTo;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\r\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!k\u0006\u0005\u0007\"\u000b\u00012A\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0002\t\u0007%^Aa\u0011%\u0002\u0011\u000fi\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011!\u0001bAU\f\t\rC\u0015\u0001#\u0003\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001\u0003\u0006\u0011\rI;\u0002B\"I\u0003!-Q\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!a\u0001C\u0002*\u0018\u0011\u0019\u0005*\u0001E\u0007\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u000f!\u0019\u0011v\u0003\u0003D\u0011\u0006Ay!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011A\u0001\u0003\u0005\u0004S/!\u0011\tS\u0001\t\u00125\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t%A1!k\u0006\u0005\u0007\"\u000b\u00012C\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\u0002\u0006\t\u0007%^Aa\u0011%\u0002\u0011+i\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011Y\u0001bAU\f\t\rC\u0015\u0001c\u0006\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001\u0003\r\u0011\rI;\u0002B\"I\u0003!eQ\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!Q\u0002C\u0002*\u0018\u0011\u0019\u0005*\u0001E\u000e\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u001d!\u0019\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$Companion;", "", "()V", "CACHE_EXTENSION", "", "getCACHE_EXTENSION", "()Ljava/lang/String;", "CONSTANTS_MAP", "getCONSTANTS_MAP", "DIRTY_INLINE_FUNCTIONS", "getDIRTY_INLINE_FUNCTIONS", "DIRTY_OUTPUT_CLASSES", "getDIRTY_OUTPUT_CLASSES", "INLINED_TO", "getINLINED_TO", "INLINE_FUNCTIONS", "getINLINE_FUNCTIONS", "MODULE_MAPPING_FILE_NAME", "getMODULE_MAPPING_FILE_NAME", "MULTIFILE_CLASS_FACADES", "getMULTIFILE_CLASS_FACADES", "MULTIFILE_CLASS_PARTS", "getMULTIFILE_CLASS_PARTS", "PACKAGE_PARTS", "getPACKAGE_PARTS", "PROTO_MAP", "getPROTO_MAP", "SOURCE_TO_CLASSES", "getSOURCE_TO_CLASSES"}, moduleName="jps-plugin")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getCACHE_EXTENSION() {
            return CACHE_EXTENSION;
        }

        @NotNull
        public final String getPROTO_MAP() {
            return PROTO_MAP;
        }

        @NotNull
        public final String getCONSTANTS_MAP() {
            return CONSTANTS_MAP;
        }

        @NotNull
        public final String getINLINE_FUNCTIONS() {
            return INLINE_FUNCTIONS;
        }

        @NotNull
        public final String getPACKAGE_PARTS() {
            return PACKAGE_PARTS;
        }

        @NotNull
        public final String getMULTIFILE_CLASS_FACADES() {
            return MULTIFILE_CLASS_FACADES;
        }

        @NotNull
        public final String getMULTIFILE_CLASS_PARTS() {
            return MULTIFILE_CLASS_PARTS;
        }

        @NotNull
        public final String getSOURCE_TO_CLASSES() {
            return SOURCE_TO_CLASSES;
        }

        @NotNull
        public final String getDIRTY_OUTPUT_CLASSES() {
            return DIRTY_OUTPUT_CLASSES;
        }

        @NotNull
        public final String getDIRTY_INLINE_FUNCTIONS() {
            return DIRTY_INLINE_FUNCTIONS;
        }

        @NotNull
        public final String getINLINED_TO() {
            return INLINED_TO;
        }

        private final String getMODULE_MAPPING_FILE_NAME() {
            return MODULE_MAPPING_FILE_NAME;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001\"C\u0003\u0001\u000b\u0005A\t\"B\u0001\u0005\u0005\u0015\t\u0001\"\u0001\u0003B\u00051\u0001\u0011\u0004B\u0005\u0003\u0013\u0005A\u0012\u0001'\u0001\"\u0011%%\u00012A\u0007\u00021\t\u00016\u0011A)\u0004\u0003!\u0015Qe\u0002\u0005\u0004\u001b\u0005A:!G\u0002\t\t5\t\u0001\u0014B\u0013\t\t)AQ!D\u0001\u0019\fe\u0019\u0001BB\u0007\u00021\u0005)\u0003\u0002#\u0004\u000e\u00051\u0005\u0001$A\r\u0004\u0011\u0011i\u0011\u0001'\u0003&!!9Q\"\u0001M\b3\rA\u0001\"D\u0001\u0019\u0012e\u0019\u0001\"C\u0007\u00021\u000fIB\u0001B\u0001\t\u00145\t\u0001tAS\u001d\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!!Q\"\u0001M\u00053\rA!\"D\u0001\u0019\u0016e1\u0001bC\u0007\u0005\u0013\tI\u0011\u0001g\u0003\u0019\u0018e\u0019\u0001\"C\u0007\u00021\u000fI2\u0001c\u0005\u000e\u0003a\u001d\u0011kA\u0001\t\u0019\u0015nB!\u0001E\r\u001b\u0005Az!G\u0002\t\t5\t\u0001\u0014B\r\u0004\u00115i\u0011\u0001'\u0006\u001a\r!YQ\u0002B\u0005\u0003\u0013\u0005AZ\u0001g\u0006\u001a\u0007!IQ\"\u0001M\u00043\rA\u0019\"D\u0001\u0019\bE\u001b\u0011\u0001\u0003\u0007&\u000f!mQ\"\u0001\r\u000f3\rAA!D\u0001\u0019\n\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ProtoMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/jps/incremental/ProtoMapValue;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "Lorg/jetbrains/kotlin/jps/incremental/ChangesInfo;", "kotlinClass", "Lorg/jetbrains/kotlin/jps/incremental/LocalFileKotlinClass;", "isPackage", "checkChangesIsOpenPart", "data", "", "strings", "", "(Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;[B[Ljava/lang/String;ZZ)Lorg/jetbrains/kotlin/jps/incremental/ChangesInfo;", "put", "bytes", "remove", ""}, moduleName="jps-plugin")
    private final class ProtoMap
    extends BasicStringMap<ProtoMapValue> {
        @NotNull
        public final ChangesInfo process(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage, boolean checkChangesIsOpenPart) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            KotlinClassHeader header = kotlinClass.getClassHeader();
            String[] stringArray = header.getAnnotationData();
            if (stringArray == null) {
                Intrinsics.throwNpe();
            }
            byte[] bytes = BitEncoding.decodeBytes((String[])stringArray);
            JvmClassName jvmClassName = kotlinClass.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"bytes");
            String[] stringArray2 = header.getStrings();
            if (stringArray2 == null) {
                Intrinsics.throwNpe();
            }
            return this.put(jvmClassName, bytes, stringArray2, isPackage, checkChangesIsOpenPart);
        }

        @NotNull
        public static /* synthetic */ ChangesInfo process$default(ProtoMap protoMap, LocalFileKotlinClass localFileKotlinClass, boolean bl, boolean bl2, int n) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return protoMap.process(localFileKotlinClass, bl, bl2);
        }

        @NotNull
        public final ChangesInfo process(@NotNull JvmClassName className2, @NotNull byte[] data, @NotNull String[] strings, boolean isPackage, boolean checkChangesIsOpenPart) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
            return this.put(className2, data, strings, isPackage, checkChangesIsOpenPart);
        }

        private final ChangesInfo put(JvmClassName className2, byte[] bytes, String[] strings, boolean isPackage, boolean checkChangesIsOpenPart) {
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            ProtoMapValue oldData = (ProtoMapValue)lazyStorage.get(string);
            ProtoMapValue data = new ProtoMapValue(isPackage, bytes, strings);
            if (oldData == null || !Arrays.equals(bytes, oldData.getBytes()) || !Arrays.equals(strings, oldData.getStrings()) || isPackage != oldData.isPackageFacade()) {
                LazyStorage<String, ProtoMapValue> lazyStorage2 = this.getStorage();
                String string2 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                lazyStorage2.set(string2, data);
            }
            return new ChangesInfo(oldData == null || !checkChangesIsOpenPart || Intrinsics.areEqual((Object)ProtoDifferenceUtilsKt.difference(oldData, data), (Object)DifferenceKind.NONE.INSTANCE) ^ true, false, false, false, 14, null);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Nullable
        public final ProtoMapValue get(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return (ProtoMapValue)lazyStorage.get(string);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull ProtoMapValue value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return (value.isPackageFacade() ? "1" : "0") + Long.toHexString(IncrementalCacheImplKt.access$md5(value.getBytes()));
        }

        public ProtoMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ProtoMapValueExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\n\u0006\u0003!9Q!\u0001\u0005\u0001\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\n\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001C\u0001\u0005\u0003\na\u0001!\u0007\u0006\n\u0011%9\u0011BA\u0005\u00021\u0007I!!C\u0001\u0019\u0005a\t\u0001\u0014A\u0011\t\u0013\u0013A)!D\u0001\u0019\u0007A\u001b\t!U\u0002\u0002\u0011\u000f)s\u0001\u0003\u0003\u000e\u0003a%\u0011d\u0001\u0005\u0006\u001b\u0005AZ!\n\b\u0005\u0015!1Q\"\u0001M\u00023%Ai!D\u0004\n\u0005%\t\u00014A\u0005\u0003\u0013\u0005A\"\u0001G\u0001&\u001f\u0011\t\u0001bB\u0007\t\u0013\tI\u0011\u0001g\u0001\n\u0005%\t\u0001D\u0001G\u00011\u0005I2\u0001c\u0004\u000e\u0003aAQe\u0002E\t\u001b\u0005A\u0012\"G\u0002\t\u00145\t\u0001DC\u0013\u0014\t\u0005A)\"D\u0001\u0019\u0013e\u0019\u0001\"B\u0007\u00021\u0017I\"\u0002C\u0006\u000e\u0011%\u0011\u0011\"\u0001M\u0002\u0013\tI\u0011\u0001\u0007\u0002\r\u0002a\tQe\u0002E\f\u001b\u0005AB\"G\u0002\t\u000b5\t\u00014\u0002"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ConstantsMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "getConstantsMap", "bytes", "", "process", "Lorg/jetbrains/kotlin/jps/incremental/ChangesInfo;", "kotlinClass", "Lorg/jetbrains/kotlin/jps/incremental/LocalFileKotlinClass;", "put", "constantsMap", "remove", ""}, moduleName="jps-plugin")
    private final class ConstantsMap
    extends BasicStringMap<Map<String, ? extends Object>> {
        private final Map<String, Object> getConstantsMap(byte[] bytes) {
            HashMap result = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result, 327680){
                final /* synthetic */ HashMap $result;

                @Nullable
                public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    int staticFinal = 8 | 0x10 | 2;
                    if (value != null && (access & staticFinal) == (8 | 0x10)) {
                        MapsKt.set((Map)this.$result, (Object)name, (Object)value);
                    }
                    return null;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, 1 | 2 | 4);
            return result.isEmpty() ? (HashMap)null : result;
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @NotNull
        public final ChangesInfo process(@NotNull LocalFileKotlinClass kotlinClass) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getConstantsMap(kotlinClass.getFileContents()));
        }

        private final ChangesInfo put(JvmClassName className2, Map<String, ? extends Object> constantsMap) {
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            Map oldMap = (Map)lazyStorage.get(string);
            if (Intrinsics.areEqual((Object)oldMap, constantsMap)) {
                return ChangesInfo.Companion.getNO_CHANGES();
            }
            if (constantsMap != null) {
                LazyStorage<String, Map<String, ? extends Object>> lazyStorage2 = this.getStorage();
                String string2 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                lazyStorage2.set(string2, constantsMap);
            } else {
                LazyStorage lazyStorage3 = this.getStorage();
                String string3 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"key");
                lazyStorage3.remove(string3);
            }
            return new ChangesInfo(false, true, false, false, 13, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.put(className2, null);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.access$dumpMap(value, (Function1)Reflection.function((FunctionReference)dumpValue.1.INSTANCE));
        }

        public ConstantsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ConstantsMapExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\n\u0006\u0003!9Q!\u0001\u0005\u0001\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tA!Y\u0001\r\u0001eQ\u0011\u0002C\u0005\b\u0013\tI\u0011\u0001g\u0001\n\u0005%\t\u0001D\u0001\r\u00021\u0003i\naBQ\u0004\t\u0005\t6!\u0001E\u0003K=!1\u0002C\u0002\u000e\u0011%\u0011\u0011\"\u0001M\u0002\u0013\tI\u0011\u0001\u0007\u0002\r\u0002a\t\u0011d\u0001E\u0004\u001b\u0005AB!J\n\u0005\u0017!%Q\"\u0001\r\u00063\rAY!D\u0001\u0019\reQ\u0001RB\u0007\t\u0013\tI\u0011\u0001g\u0001\n\u0005%\t\u0001D\u0001G\u00011\u0005\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ConstantsMapExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "", "", "()V", "read", "in", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "map", "Kind"}, moduleName="jps-plugin")
    private static final class ConstantsMapExternalizer
    implements DataExternalizer<Map<String, ? extends Object>> {
        public static final ConstantsMapExternalizer INSTANCE;
        public static final ConstantsMapExternalizer INSTANCE$;

        /*
         * WARNING - void declaration
         */
        public void save(@NotNull DataOutput out, @Nullable Map<String, ? extends Object> map) {
            void $receiver;
            void $receiver2;
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Map<String, ? extends Object> map2 = map;
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            Map<String, ? extends Object> map3 = map2;
            DataOutput dataOutput = out;
            int n = $receiver2.size();
            dataOutput.writeInt(n);
            Map<String, ? extends Object> map4 = map;
            for (String name : CollectionsKt.sorted((Iterable)$receiver.keySet())) {
                Enum $receiver3;
                Object value;
                Object object;
                IOUtil.writeString((String)name, (DataOutput)out);
                if (map.get(name) == null) {
                    Intrinsics.throwNpe();
                }
                if ((object = value) instanceof Integer) {
                    Enum enum_ = Kind.INT;
                    dataOutput = out;
                    n = $receiver3.ordinal();
                    dataOutput.writeByte(n);
                    out.writeInt(((Number)value).intValue());
                    continue;
                }
                if (object instanceof Float) {
                    $receiver3 = Kind.FLOAT;
                    dataOutput = out;
                    n = $receiver3.ordinal();
                    dataOutput.writeByte(n);
                    out.writeFloat(((Number)value).floatValue());
                    continue;
                }
                if (object instanceof Long) {
                    $receiver3 = Kind.LONG;
                    dataOutput = out;
                    n = $receiver3.ordinal();
                    dataOutput.writeByte(n);
                    out.writeLong(((Number)value).longValue());
                    continue;
                }
                if (object instanceof Double) {
                    $receiver3 = Kind.DOUBLE;
                    dataOutput = out;
                    n = $receiver3.ordinal();
                    dataOutput.writeByte(n);
                    out.writeDouble(((Number)value).doubleValue());
                    continue;
                }
                if (object instanceof String) {
                    $receiver3 = Kind.STRING;
                    dataOutput = out;
                    n = $receiver3.ordinal();
                    dataOutput.writeByte(n);
                    IOUtil.writeString((String)((String)value), (DataOutput)out);
                    continue;
                }
                throw (Throwable)new IllegalStateException("Unexpected constant class: " + value.getClass());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public Map<String, Object> read(@NotNull DataInput in) {
            Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
            int size = in.readInt();
            HashMap map = new HashMap(size);
            int n = 0;
            int n2 = size - 1;
            if (n <= n2) {
                void index;
                do {
                    String name;
                    Object object;
                    void it = ++index;
                    if (IOUtil.readString((DataInput)in) == null) {
                        Intrinsics.throwNpe();
                    }
                    Kind kind = Kind.values()[in.readByte()];
                    switch (IncrementalCacheImpl$ConstantsMapExternalizer$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                        case 1: {
                            object = in.readInt();
                            break;
                        }
                        case 2: {
                            object = Float.valueOf(in.readFloat());
                            break;
                        }
                        case 3: {
                            object = in.readLong();
                            break;
                        }
                        case 4: {
                            object = in.readDouble();
                            break;
                        }
                        case 5: {
                            object = IOUtil.readString((DataInput)in);
                            if (object != null) break;
                            Intrinsics.throwNpe();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    Object value = object;
                    MapsKt.set((Map)map, (Object)name, (Object)value);
                } while (index != n2);
            }
            return map;
        }

        static {
            new ConstantsMapExternalizer();
        }

        private ConstantsMapExternalizer() {
            INSTANCE = this;
            INSTANCE$ = this;
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001B\u0002\u0005\u0003\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\t,1\u0001B\u0003\u0007\u000f\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ConstantsMapExternalizer$Kind;", "", "(Ljava/lang/String;I)V", "INT", "FLOAT", "LONG", "DOUBLE", "STRING"}, moduleName="jps-plugin")
        private static final class Kind
        extends Enum<Kind> {
            public static final /* enum */ Kind INT;
            public static final /* enum */ Kind FLOAT;
            public static final /* enum */ Kind LONG;
            public static final /* enum */ Kind DOUBLE;
            public static final /* enum */ Kind STRING;
            private static final /* synthetic */ Kind[] $VALUES;

            static {
                Kind[] kindArray = new Kind[5];
                Kind[] kindArray2 = kindArray;
                kindArray[0] = INT = new Kind();
                kindArray[1] = FLOAT = new Kind();
                kindArray[2] = LONG = new Kind();
                kindArray[3] = DOUBLE = new Kind();
                kindArray[4] = STRING = new Kind();
                $VALUES = kindArray;
            }

            public static Kind[] values() {
                return (Kind[])$VALUES.clone();
            }

            public static Kind valueOf(String string) {
                return Enum.valueOf(Kind.class, string);
            }
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\n\u0006\u0003!9Q!\u0001E\u0005\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0005\n\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\t\u0005\u0013A\u0002A\r\u000b\u0013!Iq!\u0003\u0002\n\u0003a\r\u0011BA\u0005\u00021\tA\u0012\u0001'\u0001\"\u0011%%\u0001RA\u0007\u00021\r\u00016\u0011A)\u0004\u0003!\u001dQE\u0004\u0003\u000b\u0011\u0011i\u0011\u0001g\u0001\u001a\u0013!%QbB\u0005\u0003\u0013\u0005A\u001a!\u0003\u0002\n\u0003a\u0011\u0001$A\u0013\u000f\t\u0005AQ!D\u0004\n\u0005%\t\u00014A\u0005\u0003\u0013\u0005A\"\u0001G\u0001\u001a\u0007!-Q\"\u0001\r\u0007K\u001dAi!D\u0001\u0019\u000fe\u0019\u0001rB\u0007\u00021!)#\u0003B\u0001\t\u00125\t\u0001dB\r\u0004\u0011%i\u0011\u0001g\u0005\u001a\u0013!QQbB\u0005\u0003\u0013\u0005A\u001a!\u0003\u0002\n\u0003a\u0011\u0001$A\u0013\b\u0011+i\u0011\u0001G\u0006\u001a\u0007!IQ\"\u0001M\n"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getInlineFunctionsMap", "bytes", "", "process", "Lorg/jetbrains/kotlin/jps/incremental/ChangesInfo;", "kotlinClass", "Lorg/jetbrains/kotlin/jps/incremental/LocalFileKotlinClass;", "put", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "newMap", "remove", ""}, moduleName="jps-plugin")
    private final class InlineFunctionsMap
    extends BasicStringMap<Map<String, ? extends Long>> {
        private final Map<String, Long> getInlineFunctionsMap(byte[] bytes) {
            HashMap result = new HashMap();
            Set inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames((byte[])bytes);
            if (inlineFunctions.isEmpty()) {
                return MapsKt.emptyMap();
            }
            new ClassReader(bytes).accept(new ClassVisitor(inlineFunctions, result, 327680){
                final /* synthetic */ Set $inlineFunctions;
                final /* synthetic */ HashMap $result;

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    ClassWriter dummyClassWriter = new ClassWriter(327680);
                    return new MethodVisitor(this, name, desc, dummyClassWriter, 327680, dummyClassWriter.visitMethod(0, name, desc, (String)null, exceptions)){
                        final /* synthetic */ getInlineFunctionsMap.1 this$0;
                        final /* synthetic */ String $name;
                        final /* synthetic */ String $desc;
                        final /* synthetic */ ClassWriter $dummyClassWriter;

                        public void visitEnd() {
                            String jvmName = this.$name + this.$desc;
                            if (this.this$0.$inlineFunctions.contains(jvmName) ^ true) {
                                return;
                            }
                            byte[] byArray = this.$dummyClassWriter.toByteArray();
                            if (byArray == null) {
                                Intrinsics.throwNpe();
                            }
                            byte[] dummyBytes = byArray;
                            long hash = IncrementalCacheImplKt.access$md5(dummyBytes);
                            MapsKt.set((Map)this.this$0.$result, (Object)jvmName, (Object)hash);
                        }
                        {
                            this.this$0 = $outer;
                            this.$name = $captured_local_variable$1;
                            this.$desc = $captured_local_variable$2;
                            this.$dummyClassWriter = $captured_local_variable$3;
                            super($super_call_param$4, $super_call_param$5);
                        }
                    };
                }
                {
                    this.$inlineFunctions = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            }, 0);
            return result;
        }

        @NotNull
        public final ChangesInfo process(@NotNull LocalFileKotlinClass kotlinClass) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getInlineFunctionsMap(kotlinClass.getFileContents()));
        }

        private final ChangesInfo put(JvmClassName className2, Map<String, ? extends Long> newMap) {
            Map<String, ? extends Long> $receiver;
            String internalName = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = internalName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"internalName");
            Map map = (Map)lazyStorage.get(string);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map oldMap = map;
            HashSet added = SetsKt.hashSetOf((Object[])new String[0]);
            HashSet changed = SetsKt.hashSetOf((Object[])new String[0]);
            Map map2 = oldMap;
            Set set = $receiver.keySet();
            $receiver = newMap;
            Set set2 = set;
            Set<String> set3 = $receiver.keySet();
            Set allFunctions = SetsKt.plus(set2, (Iterable)set3);
            for (String fn : allFunctions) {
                Long oldHash = (Long)oldMap.get(fn);
                Long newHash = newMap.get(fn);
                if (oldHash == null) {
                    added.add(fn);
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)oldHash, (Object)newHash) ^ true)) continue;
                changed.add(fn);
            }
            if (MapsKt.isNotEmpty(newMap)) {
                LazyStorage<String, Map<String, ? extends Long>> lazyStorage2 = this.getStorage();
                String string2 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"internalName");
                lazyStorage2.set(string2, newMap);
            } else {
                LazyStorage lazyStorage3 = this.getStorage();
                String string3 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"internalName");
                lazyStorage3.remove(string3);
            }
            if (CollectionsKt.isNotEmpty((Collection)changed)) {
                IncrementalCacheImpl.this.dirtyInlineFunctionsMap.put(className2, CollectionsKt.toList((Iterable)changed));
            }
            return new ChangesInfo(false, false, CollectionsKt.isNotEmpty((Collection)changed), CollectionsKt.isNotEmpty((Collection)added), 3, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Long> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.access$dumpMap(value, dumpValue.1.INSTANCE);
        }

        public InlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringToLongMapExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!B\u0001\u0005\u0004\u0011\t%\u0001\u0004\u0001\u001a\t%\u0011\u0011\"\u0001\r\u00021\u0003\t\u0003\"#\u0003\t\u00045\t\u0001D\u0001)\u0004\u0002E\u001b\u0011\u0001#\u0002&\u000f!\u0019Q\"\u0001M\u00043\rAA!D\u0001\u0019\n\u0015BAA\u0003\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001$A\u0013\b\u0011\u001bi\u0011\u0001G\u0001\u001a\u0007!!Q\"\u0001M\u0005K\u001dAq!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u0013\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$PackagePartMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "addPackagePart", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "isPackagePart", "remove"}, moduleName="jps-plugin")
    private final class PackagePartMap
    extends BasicStringMap<Boolean> {
        public final void addPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage<String, Boolean> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, true);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        public final boolean isPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public PackagePartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\t\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0002\u0005\u0003\na\u0001!G\u0004\n\u000b%!\u0011BA\u0005\u00021\u0007A\u0012\u0001'\u0001\"\u0011%%\u0001BA\u0007\u00021\u000b\u00016\u0011A)\u0004\u0003!\u0019QE\u0004E\u0004\u001b\u0005AB!G\u0002\t\n5\t\u0001$B\r\u0007\u0011\u0017iA!\u0003\u0002\n\u0003a\r\u0001$A\u0013\f\t)Aa!D\u0001\u0019\u0004e1\u0001RB\u0007\u0005\u0013\tI\u0011\u0001g\u0001\u0019\u0003\u0015Z\u0001bB\u0007\u0006\u0013\tI\u0011\u0001g\u0001\r\u0002a\t\u0011d\u0001E\u0005\u001b\u0005A\u001a!J\u0004\t\u00105\t\u0001\u0004B\r\u0004\u0011!i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassFacadeMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "facadeName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "partNames", "dumpValue", "value", "getMultifileClassParts", "remove", "className"}, moduleName="jps-plugin")
    private final class MultifileClassFacadeMap
    extends BasicStringMap<List<? extends String>> {
        public final void add(@NotNull JvmClassName facadeName, @NotNull List<? extends String> partNames) {
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            Intrinsics.checkParameterIsNotNull(partNames, (String)"partNames");
            LazyStorage<String, List<? extends String>> lazyStorage = this.getStorage();
            String string = facadeName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"facadeName.internalName");
            lazyStorage.set(string, partNames);
        }

        @Nullable
        public final List<String> getMultifileClassParts(@NotNull String facadeName) {
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            return (List)this.getStorage().get(facadeName);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull List<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return value.toString();
        }

        public MultifileClassFacadeMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringListExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0003\u0011\u001dQ!\u0001\u0007\u0002\t\u0005\u0013A\u0002A\r\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0002\u0005B\u0011\u0012\u0002E\u0002\u001b\u0005A\"\u0001UB\u0001#\u000e\t\u0001RA\u0013\f\u0011\ri\u0011\u0001g\u0002\u001a\u0007!!Q\"\u0001\r\u00023\rAI!D\u0001\u0019\u0003\u0015BAA\u0003\u0005\u0006\u001b\u0005A\u0012!G\u0002\t\f5\t\u0001$A\u0013\t\u0011\u0019i!\u0001$\u0001\u0019\u0003e\u0019\u0001\u0002B\u0007\u00021\u0005)s\u0001#\u0004\u000e\u0003a\u001d\u0011d\u0001\u0005\b\u001b\u0005Az\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassPartMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "partName", "facadeName", "dumpValue", "value", "getFacadeName", "remove", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;"}, moduleName="jps-plugin")
    private final class MultifileClassPartMap
    extends BasicStringMap<String> {
        public final void add(@NotNull String partName, @NotNull String facadeName) {
            Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            this.getStorage().set(partName, facadeName);
        }

        @Nullable
        public final String getFacadeName(@NotNull String partName) {
            Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
            return (String)this.getStorage().get(partName);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return value;
        }

        public MultifileClassPartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)EnumeratorStringDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"EnumeratorStringDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\t\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u0001b\u0004\u0003B\u00051\u0001\u0011dB\u0005\u0006\u0013\u0011I!!C\u0001\u0019\u0004a\t\u0001\u0014A\u0011\t\u0013\u0013A!!D\u0001\u0019\u0006A\u001b\t!U\u0002\u0002\u0011\r)3\u0002c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005A*!G\u0002\t\u000b5\t\u00014B\u0013\b\u0011\u0019i\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001M\u0003K-!!\u0002#\u0004\u000e\u0003a\r\u0011D\u0002\u0005\b\u001b\u0011I!!C\u0001\u0019\u0004a\tQE\u0003E\b\u001b\u0011I!!C\u0001\u0019\faA\u0011d\u0001E\u0005\u001b\u0005A*\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$SourceToClassesMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "sourceFile", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "clearOutputsForSource", "dumpValue", "value", "get", ""}, moduleName="jps-plugin")
    private final class SourceToClassesMap
    extends BasicStringMap<List<? extends String>> {
        public final void clearOutputsForSource(@NotNull File sourceFile) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            lazyStorage.remove(string);
        }

        public final void add(@NotNull File sourceFile, @NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            lazyStorage.append(string, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(className2){
                final /* synthetic */ JvmClassName $className;

                public final void invoke(@NotNull DataOutput out) {
                    Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                    IOUtil.writeUTF((DataOutput)out, (String)this.$className.getInternalName());
                }
                {
                    this.$className = jvmClassName;
                    super(1);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<JvmClassName> get(@NotNull File sourceFile) {
            void destination;
            void $receiver;
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            Iterable $receiver2 = CollectionsKt.orEmpty((List)((List)lazyStorage.get(string)));
            Iterable iterable = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                String string2 = (String)item;
                void var11_8 = destination;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
                var11_8.add(jvmClassName);
            }
            return (List)destination;
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull List<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return value.toString();
        }

        public SourceToClassesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            KeyDescriptor keyDescriptor = (KeyDescriptor)PathStringDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyDescriptor, (String)"PathStringDescriptor.INSTANCE");
            super(storageFile, (KeyDescriptor<String>)keyDescriptor, (DataExternalizer)StringListExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0004\u0006\u0003\u0011\tQ!\u0001\u0005\u0010\u000b\u0005!\u0019!B\u0001\t\u0003\u0015\u0001A!\u0011\u0002\r\u0001e!\u0011BA\u0005\u00021\u0005A\n!\t\u0005\n\n!\rQ\"\u0001\r\u0003!\u000e\u0005\u0011kA\u0001\t\u0006\u0015BAA\u0003\u0005\u0004\u001b\u0005A:!G\u0002\t\t5\t\u0001$A\u0013\u0007\u0011\u0013iA!\u0003\u0002\n\u0003a\u001d\u0001$B\u0013\b\u0011\u0017i\u0011\u0001G\u0001\u001a\u0007!1Q\"\u0001M\u0004K\u001dAi!D\u0001\u0019\u000fe\u0019\u0001BB\u0007\u00021\u000f)s\u0001c\u0004\u000e\u0003a9\u0011d\u0001\u0005\u0007\u001b\u0005A:\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyOutputClassesMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "", "value", "getDirtyOutputClasses", "", "isDirty", "className", "markDirty", "", "notDirty"}, moduleName="jps-plugin")
    private final class DirtyOutputClassesMap
    extends BasicStringMap<Boolean> {
        public final void markDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.getStorage().set(className2, true);
        }

        public final void notDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.getStorage().remove(className2);
        }

        @NotNull
        public final Collection<String> getDirtyOutputClasses() {
            return this.getStorage().getKeys();
        }

        public final boolean isDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            return this.getStorage().contains(className2);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public DirtyOutputClassesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\t\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!\u0011R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0003\u0011\tA!\u0011\u0002\r\u0001e9\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001g\u0001\u0019\u0003a\u0005\u0011\u0005CE\u0005\u0011\ti\u0011\u0001'\u0002Q\u0007\u0003\t6!\u0001\u0005\u0004K-!!\u0002c\u0002\u000e\u0003a\r\u0011D\u0002\u0005\u0005\u001b\u0011I!!C\u0001\u0019\u0004a\tQ\u0005\u0004E\u0005\u001b)I!!C\u0001\u0019\f%)\u0011\u0002B\u0005\u0003\u0013\u0005A\u001a\u0001G\u0001\u0019\u000b\u0015r\u0001BB\u0007\u00021\u001bI2\u0001C\u0004\u000e\u0003a-\u0011D\u0002E\b\u001b\u0011I!!C\u0001\u0019\u0004a\t\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyInlineFunctionsMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getEntries", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "put", "", "className", "changedFunctions"}, moduleName="jps-plugin")
    private final class DirtyInlineFunctionsMap
    extends BasicStringMap<List<? extends String>> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<JvmClassName, List<? extends String>> getEntries() {
            Iterable $receiver = this.getStorage().getKeys();
            float capacity = (float)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver, (int)10) / 0.75f + 1.0f;
            LinkedHashMap<JvmClassName, List<? extends String>> result = new LinkedHashMap<JvmClassName, List<? extends String>>(Math.max((int)capacity, 16));
            for (Object element : $receiver) {
                List<? extends String> list;
                void it;
                String p1;
                String string = (String)element;
                LinkedHashMap<JvmClassName, List<? extends String>> linkedHashMap = result;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)p1);
                p1 = (String)element;
                if (this.getStorage().get((String)it) == null) {
                    Intrinsics.throwNpe();
                }
                linkedHashMap.put(jvmClassName, list);
            }
            return result;
        }

        public final void put(@NotNull JvmClassName className2, @NotNull List<? extends String> changedFunctions) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull(changedFunctions, (String)"changedFunctions");
            LazyStorage<String, List<? extends String>> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, changedFunctions);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull List<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection((Collection)value);
        }

        public DirtyInlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringListExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!yQ!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0005!A\u0001B!\u0003\u0019\u0001I\"\"\u0003\u0002\n\u0003a\t\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001\u0007\u0002\u0019\u0004a\u0005\u0011\u0005CE\u0005\u0011\u000bi\u0011\u0001G\u0002Q\u0007\u0003\t6!\u0001E\u0004K=AA!D\u0001\u0019\ne\u0019\u0001\"B\u0007\u00021\tI2\u0001c\u0003\u000e\u0003a\u0011\u0011d\u0001\u0005\u0007\u001b\u0005A\"!\n\u0005\u0005\u0015!5Q\"\u0001\r\u00033\rAq!D\u0001\u0019\u0003\u0015ZAA\u0003E\b\u001b\u0005A\"!\u0007\u0004\t\u00115!\u0011BA\u0005\u00021\tA\u001a!\n\b\t\u00125!\u0011BA\u0005\u00021\tA\u001a!G\u0002\t\u000b5\t\u0001DA\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0002"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsFilesMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMap;", "Lorg/jetbrains/kotlin/jps/incremental/PathFunctionPair;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "sourcePath", "jvmSignature", "targetPath", "dumpKey", "key", "dumpValue", "value", "get"}, moduleName="jps-plugin")
    private final class InlineFunctionsFilesMap
    extends BasicMap<PathFunctionPair, Collection<? extends String>> {
        public final void add(@NotNull String sourcePath, @NotNull String jvmSignature, @NotNull String targetPath) {
            Intrinsics.checkParameterIsNotNull((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
            Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
            PathFunctionPair key = new PathFunctionPair(sourcePath, jvmSignature);
            this.getStorage().append(key, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(targetPath){
                final /* synthetic */ String $targetPath;

                public final void invoke(@NotNull DataOutput out) {
                    Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                    IOUtil.writeUTF((DataOutput)out, (String)this.$targetPath);
                }
                {
                    this.$targetPath = string;
                    super(1);
                }
            }));
        }

        @NotNull
        public final Collection<String> get(@NotNull String sourcePath, @NotNull String jvmSignature) {
            Intrinsics.checkParameterIsNotNull((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
            PathFunctionPair key = new PathFunctionPair(sourcePath, jvmSignature);
            Collection collection = (Collection)this.getStorage().get(key);
            if (collection == null) {
                collection = SetsKt.emptySet();
            }
            return collection;
        }

        @Override
        @NotNull
        protected String dumpKey(@NotNull PathFunctionPair key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return "(" + key.getPath() + ", " + key.getFunction() + ")";
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        public InlineFunctionsFilesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, PathFunctionPairKeyDescriptor.INSTANCE, PathCollectionExternalizer.INSTANCE);
        }
    }
}

