/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.jps.incremental.ProtoMapValue;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\t\u0005\fA\u0002A\r\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\rQ\u0005\u0003\u0003\f\u0011\ti\u0011\u0001G\u0001\u001a\u0007!\u0015Q\"\u0001\r\u0004K1!1\u0002c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001$\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/ProtoMapValueExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/jps/incremental/ProtoMapValue;", "()V", "read", "in", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "value"}, moduleName="jps-plugin")
public final class ProtoMapValueExternalizer
implements DataExternalizer<ProtoMapValue> {
    public static final ProtoMapValueExternalizer INSTANCE;
    public static final ProtoMapValueExternalizer INSTANCE$;

    public void save(@NotNull DataOutput out, @NotNull ProtoMapValue value) {
        Object[] $receiver;
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        out.writeBoolean(value.isPackageFacade());
        byte[] byArray = value.getBytes();
        DataOutput dataOutput = out;
        int n = $receiver.length;
        dataOutput.writeInt(n);
        out.write(value.getBytes());
        $receiver = value.getStrings();
        dataOutput = out;
        n = $receiver.length;
        dataOutput.writeInt(n);
        String[] stringArray = value.getStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            out.writeUTF(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProtoMapValue read(@NotNull DataInput in) {
        Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
        boolean isPackageFacade = in.readBoolean();
        int bytesLength = in.readInt();
        byte[] bytes = new byte[bytesLength];
        in.readFully(bytes, 0, bytesLength);
        int stringsLength = in.readInt();
        String[] result = new String[stringsLength];
        int n = 0;
        int n2 = stringsLength - 1;
        if (n <= n2) {
            void i;
            do {
                String string;
                void var10_9 = ++i;
                void var14_11 = i;
                String[] stringArray = result;
                Intrinsics.checkExpressionValueIsNotNull((Object)in.readUTF(), (String)"`in`.readUTF()");
                stringArray[var14_11] = string;
            } while (i != n2);
        }
        String[] strings = (String[])((Object[])result);
        return new ProtoMapValue(isPackageFacade, bytes, strings);
    }

    static {
        new ProtoMapValueExternalizer();
    }

    private ProtoMapValueExternalizer() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

