/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileCreateEvent
extends VFileEvent {
    @NotNull
    private final VirtualFile myParent;
    private final boolean myDirectory;
    @NotNull
    private final String myChildName;
    private final boolean myReCreation;
    private VirtualFile myCreatedFile;

    @NotNull
    public String getChildName() {
        String string = this.myChildName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent", "getChildName"));
        }
        return string;
    }

    @NotNull
    public VirtualFile getParent() {
        VirtualFile virtualFile = this.myParent;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent", "getParent"));
        }
        return virtualFile;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[" + (this.myReCreation ? "re" : "") + "create " + (this.myDirectory ? "dir " : "file ") + this.myChildName + " in " + this.myParent.getUrl() + "]";
    }

    public VirtualFile getFile() {
        if (this.myCreatedFile != null) {
            return this.myCreatedFile;
        }
        this.myCreatedFile = this.myParent.findChild(this.myChildName);
        return this.myCreatedFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myParent.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o;
        if (this.myDirectory != event.myDirectory) {
            return false;
        }
        if (!this.myChildName.equals(event.myChildName)) {
            return false;
        }
        if (!this.myParent.equals(event.myParent)) {
            return false;
        }
        return this.myReCreation == event.myReCreation;
    }

    public int hashCode() {
        int result2 = this.myParent.hashCode();
        result2 = 31 * result2 + (this.myDirectory ? 1 : 0);
        result2 = 31 * result2 + this.myChildName.hashCode();
        result2 = 31 * result2 + (this.myReCreation ? 1 : 0);
        return result2;
    }
}

