/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocElementImpl;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\u0001R\u0001A\u0003\u0002\u0011\u001d)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005AY!\u0002\u0001\u0005\u00171\u0001\u0011$\u0001M\u0001C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015:A!\u0001E\u0005\u001b\u0011I!!C\u0001\u0019\u0004a)Q\u0005\u0002\u0003\f\u0011\u0017i\u0011\u0001\u0007\u0004&\u000b\u0011Y\u0001RB\u0007\u0003\u0019\u0003Ab!\n\u0003\t\u000f5\u0011A\u0012\u0001M\bK\u0015!1\u0002\u0003\u0005\u000e\u00051\u0005\u0001DB\u0013\f\t\u0005A\t\"D\u0001\u0019\u0013e1\u00012C\u0007\u0005\u0013\tI\u0011\u0001g\u0001\u0019\u000b%ZAa\u0011\u0005\t\u00065\u0011A\u0012\u0001\r\u00049\r\n6aA\u0007\u0003\t\u000fAA\u0001"}, strings={"Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocTag;", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocElementImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "knownTag", "Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;", "getKnownTag", "()Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;", "childrenAfterTagName", "", "getContent", "", "getName", "getSubjectLink", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "getSubjectName", "hasSubject", "", "contentChildren"}, moduleName="kotlin-compiler")
public class KDocTag
extends KDocElementImpl {
    @Override
    @Nullable
    public String getName() {
        Object tagName = this.findChildByType(KDocTokens.TAG_NAME);
        if (tagName != null) {
            return StringsKt.substring(tagName.getText(), 1);
        }
        return null;
    }

    @Nullable
    public String getSubjectName() {
        KDocLink kDocLink = this.getSubjectLink();
        return kDocLink != null ? kDocLink.getLinkText() : null;
    }

    @Nullable
    public final KDocLink getSubjectLink() {
        List<ASTNode> children = this.childrenAfterTagName();
        if (this.hasSubject(children)) {
            ASTNode aSTNode = CollectionsKt.firstOrNull(children);
            PsiElement psiElement2 = aSTNode != null ? aSTNode.getPsi() : null;
            if (!(psiElement2 instanceof KDocLink)) {
                psiElement2 = null;
            }
            return (KDocLink)psiElement2;
        }
        return null;
    }

    @Nullable
    public final KDocKnownTag getKnownTag() {
        return this.getName() != null ? KDocKnownTag.findByTagName(this.getName()) : (KDocKnownTag)null;
    }

    private final boolean hasSubject(List<? extends ASTNode> contentChildren) {
        KDocKnownTag kDocKnownTag = this.getKnownTag();
        if (kDocKnownTag != null ? kDocKnownTag.isReferenceRequired() : false) {
            ASTNode aSTNode = CollectionsKt.firstOrNull(contentChildren);
            return Intrinsics.areEqual(aSTNode != null ? aSTNode.getElementType() : null, KDocTokens.MARKDOWN_LINK);
        }
        return false;
    }

    private final List<ASTNode> childrenAfterTagName() {
        ASTNode it;
        Object item;
        Object $receiver = this.getNode().getChildren(null);
        boolean yielding = false;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < ((Object[])$receiver).length; ++i) {
            item = $receiver[i];
            if (yielding) {
                list.add(item);
                continue;
            }
            it = (ASTNode)item;
            if (Intrinsics.areEqual(it.getElementType(), KDocTokens.TAG_NAME)) continue;
            list.add(item);
            yielding = true;
        }
        $receiver = list;
        yielding = false;
        list = new ArrayList();
        Iterator iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            item = iterator2.next();
            if (yielding) {
                list.add(item);
                continue;
            }
            it = (ASTNode)item;
            if (Intrinsics.areEqual(it.getElementType(), TokenType.WHITE_SPACE)) continue;
            list.add(item);
            yielding = true;
        }
        return list;
    }

    @NotNull
    public String getContent() {
        StringBuilder builder = new StringBuilder();
        boolean contentStarted = false;
        boolean afterAsterisk = false;
        List<ASTNode> children = this.childrenAfterTagName();
        if (this.hasSubject(children)) {
            children = CollectionsKt.drop((Iterable)children, 1);
        }
        for (ASTNode node : children) {
            IElementType type2 = node.getElementType();
            if (KDocTokens.CONTENT_TOKENS.contains(type2)) {
                String string;
                if (!contentStarted || afterAsterisk) {
                    string = StringsKt.trimStart(node.getText());
                } else {
                    String string2 = node.getText();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull(string2, "node.text");
                }
                builder.append(string);
                contentStarted = true;
                afterAsterisk = false;
            }
            if (Intrinsics.areEqual(type2, KDocTokens.LEADING_ASTERISK)) {
                afterAsterisk = true;
            }
            if (Intrinsics.areEqual(type2, TokenType.WHITE_SPACE) && contentStarted) {
                builder.append(StringsKt.repeat("\n", StringUtil.countNewLines(node.getText())));
            }
            if (!Intrinsics.areEqual(type2, KDocElementTypes.KDOC_TAG)) continue;
            break;
        }
        return StringsKt.trimEnd(builder.toString(), ' ', '\t');
    }

    public KDocTag(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }
}

