/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.annotations;

import java.util.Iterator;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"/\u0015\u0001Q!\u0001\u0005\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005AY!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0007\u000e\u0011\u0001i!\u0001$\u0001\u0019\u0002U\t\u0001$AM\u0005\u0011\u0007i\u0011\u0001\u0007\u0002Q\u0007\u0003!6QAG\u0007\u0011\ri\u0011\u0001g\u0002\u0016\u0003a!Ak!\u0002\u000e\u000e!%Q\"\u0001M\u0004+\u0005AB\u0001VB\u0003\u001b\u001bAQ!D\u0001\u0019\bU\t\u0001\u0004\u0002+\u0004\u00065\u0019B!\u0001E\u0006\u001b\u0005A:!F\u0001\u0019\reU\u0001RB\u0007\b\u0013\tI\u0011\u0001\u0007\u0003\n\u0005%\t\u0001t\u0001\r\b!\u000e\u0005Ak!\u0002\u000e\u000e!=Q\"\u0001M\u0004+\u0005Ab\u0001VB\u0003\u001b\u001bA\u0001\"D\u0001\u0019\bU\t\u0001D\u0002+\u0004\u0006\u0001"}, strings={"argumentValue", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "parameterName", "", "AnnotationUtilKt", "hasIntrinsicAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "hasJvmSyntheticAnnotation", "hasPlatformStaticAnnotation", "isPlatformStaticIn", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "predicate", "Lkotlin/Function1;", "isPlatformStaticInCompanionObject", "isPlatformStaticInObjectOrClass"}, moduleName="kotlin-compiler")
public final class AnnotationUtilKt {
    public static final boolean hasPlatformStaticAnnotation(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getAnnotations().findAnnotation(new FqName("kotlin.platform.platformStatic")) != null || $receiver.getAnnotations().findAnnotation(new FqName("kotlin.jvm.JvmStatic")) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasJvmSyntheticAnnotation(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqName jvmSyntheticName = new FqName("kotlin.jvm.JvmSynthetic");
        if ($receiver.getAnnotations().findAnnotation(jvmSyntheticName) != null) return true;
        Annotations annotations2 = $receiver.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "annotations");
        if (Annotations.Companion.findUseSiteTargetedAnnotation(annotations2, AnnotationUseSiteTarget.FIELD, jvmSyntheticName) == null) return false;
        return true;
    }

    public static final boolean hasIntrinsicAnnotation(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getAnnotations().findAnnotation(new FqName("kotlin.jvm.internal.Intrinsic")) != null;
    }

    public static final boolean isPlatformStaticInObjectOrClass(CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return AnnotationUtilKt.isPlatformStaticIn($receiver, isPlatformStaticInObjectOrClass.1.INSTANCE);
    }

    public static final boolean isPlatformStaticInCompanionObject(CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return AnnotationUtilKt.isPlatformStaticIn($receiver, isPlatformStaticInCompanionObject.1.INSTANCE);
    }

    private static final boolean isPlatformStaticIn(CallableDescriptor $receiver, Function1<? super DeclarationDescriptor, ? extends Boolean> predicate) {
        boolean bl;
        CallableDescriptor callableDescriptor = $receiver;
        if (callableDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "propertyDescriptor.getContainingDeclaration()");
            bl = predicate.invoke(declarationDescriptor).booleanValue() && (AnnotationUtilKt.hasPlatformStaticAnnotation($receiver) || AnnotationUtilKt.hasPlatformStaticAnnotation(propertyDescriptor));
        } else {
            DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "getContainingDeclaration()");
            bl = predicate.invoke(declarationDescriptor) != false && AnnotationUtilKt.hasPlatformStaticAnnotation($receiver);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object argumentValue(AnnotationDescriptor $receiver, @NotNull String parameterName) {
        Object object;
        Object object2;
        block2: {
            void var3_3;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(parameterName, "parameterName");
            Object $receiver2 = $receiver.getAllValueArguments();
            $receiver2 = $receiver2.entrySet();
            Object single = null;
            boolean found = false;
            Iterator iterator2 = $receiver2.iterator();
            while (iterator2.hasNext()) {
                Object element = iterator2.next();
                Map.Entry it = (Map.Entry)element;
                if (!Intrinsics.areEqual(((ValueParameterDescriptor)it.getKey()).getName().asString(), parameterName)) continue;
                if (found) {
                    object2 = null;
                    break block2;
                }
                single = element;
                found = true;
            }
            object2 = !found ? null : var3_3;
        }
        return (object = (Map.Entry)object2) != null && (object = (ConstantValue)object.getValue()) != null ? ((ConstantValue)object).getValue() : null;
    }
}

