/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"_\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001c\u0003\u0006\u0003\u0011\u0015Q!\u0001\u0005\u0010\u000b\u0005a\u0011!B\u0001\u0005\t\u0015\t\u0001\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011E)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0010\u000b\u0005!\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UC\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\u0007!\u0011Q\"\u0001M\u0003#\u000e\t\u0001bA\u0013\b\u00119i\u0011\u0001'\b\u001a\u0007!yQ\"\u0001M\u0005K\u001d!\u0011\u0001c\b\u000e\t%\u0011\u0011\"\u0001\r\u000b1')S\u0002\u0003\t\u000e\u0003a\u0001\u0011$\u0003E\u0011\u001b\u001dI!!C\u0001\u0019$%\u0011\u0011\"\u0001M\u00071E)#\u0003B\u0001\t%5!\u0011BA\u0005\u00021)A*#\u0007\u0004\t\b5!\u0011BA\u0005\u00021\u0013A\u001a\"G\u0002\t'5\t\u0001tE\u0013\u001b\t\u0005A!#\u0004\u0003\n\u0005%\t\u0001D\u0003M\u00133\u0019A9!\u0004\u0003\n\u0005%\t\u0001\u0014\u0002M\n3\rA1#D\u0001\u0019(e9\u0001\u0002F\u0007\u0006\u0013\tI\u0011\u0001\u0007\u0006\r\u0002a%Re\u0001\u0005\t\u001b\u0005Aj\"\n\t\u0005\u0003!)R\"\u0001M\u00073\u0019A9!\u0004\u0003\n\u0005%\t\u0001\u0014\u0002M\n3\u0011AY#\u0004\u0002\r\u0002aQ\u0011&\u0004\u0003L\u0011!\u001dQ\u0002B\u0005\u0003\u0013\u0005AJ\u0001\u0007\u0003R\u0007\u0011)\u0001!\u0004\u0002\u0005\u000b!-\u0011F\u0005\u0003D9!9Q\"\u0001M\u00073\rAa!D\u0001\u0019\u000e\u0001\n\u0013kA\u0004\u0006\u00015\u0011Aa\u0002E\b#\t!\u0001\u0002#\u0005*\u0017\u0011\tE\u0004C\u0005\u000e\u000b%\u0011\u0011\"\u0001\r\u000b\u0019\u0003A\u001a\"U\u0002\u0002\u000b\u0001I#\u0002B&\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0016!Y\u0011&\u0004\u0003L\u0011!]Q\u0002B\u0005\u0003\u0013\u0005A\"\u0002g\u0005\u001dWE\u001b1!\u0004\u0002\u0005\u0019!e\u0011F\u0003\u0003L\u0011!\u0011Q\"\u0001M\u0003#\u000e!Q\u0001A\u0007\u0003\t5AY\u0002"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBoundsImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "typeVariable", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "varianceOfPosition", "Lorg/jetbrains/kotlin/types/Variance;", "(Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;Lorg/jetbrains/kotlin/types/Variance;)V", "bounds", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "getBounds", "()Ljava/util/ArrayList;", "<set-?>", "", "isFixed", "()Z", "setFixed", "(Z)V", "resultValues", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "getTypeVariable", "()Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "values", "getValues", "()Ljava/util/Collection;", "getVarianceOfPosition", "()Lorg/jetbrains/kotlin/types/Variance;", "addBound", "", "bound", "computeValues", "filter", "condition", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "filterBounds", "", "kind", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "errorValues", "", "tryPossibleAnswer", "possibleAnswer"}, moduleName="kotlin-compiler")
public final class TypeBoundsImpl
implements TypeBounds {
    @NotNull
    private final ArrayList<TypeBounds.Bound> bounds;
    private Collection<? extends KotlinType> resultValues;
    private boolean isFixed;
    @NotNull
    private final TypeParameterDescriptor typeVariable;
    @NotNull
    private final Variance varianceOfPosition;

    @NotNull
    public ArrayList<TypeBounds.Bound> getBounds() {
        return this.bounds;
    }

    public final boolean isFixed() {
        return this.isFixed;
    }

    public final void setFixed() {
        this.isFixed = true;
    }

    public final void addBound(@NotNull TypeBounds.Bound bound) {
        Intrinsics.checkParameterIsNotNull(bound, "bound");
        this.resultValues = null;
        boolean value2 = Intrinsics.areEqual(bound.getTypeVariable(), this.getTypeVariable());
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = bound + " is added for incorrect type variable " + bound.getTypeVariable().getName() + ". Expected: " + this.getTypeVariable().getName();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        ((ArrayList)this.getBounds()).add(bound);
    }

    private final Set<KotlinType> filterBounds(Collection<? extends TypeBounds.Bound> bounds, TypeBounds.BoundKind kind) {
        return this.filterBounds(bounds, kind, null);
    }

    private final Set<KotlinType> filterBounds(Collection<? extends TypeBounds.Bound> bounds, TypeBounds.BoundKind kind, Collection<KotlinType> errorValues) {
        LinkedHashSet<KotlinType> result2 = new LinkedHashSet<KotlinType>();
        for (TypeBounds.Bound bound : bounds) {
            if (!Intrinsics.areEqual((Object)bound.getKind(), (Object)kind)) continue;
            if (!ErrorUtils.containsErrorType(bound.getConstrainingType())) {
                result2.add(bound.getConstrainingType());
                continue;
            }
            Collection<KotlinType> collection = errorValues;
            Boolean bl = collection != null ? Boolean.valueOf(collection.add(bound.getConstrainingType())) : null;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeBoundsImpl filter(@NotNull Function1<? super ConstraintPosition, ? extends Boolean> condition) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        TypeBoundsImpl result2 = new TypeBoundsImpl(this.getTypeVariable(), this.getVarianceOfPosition());
        Iterable iterable = this.getBounds();
        Collection collection = result2.getBounds();
        void var4_5 = $receiver2;
        Collection collection2 = new ArrayList();
        for (Object element : $receiver) {
            TypeBounds.Bound it = (TypeBounds.Bound)element;
            if (!condition.invoke(it.getPosition()).booleanValue()) continue;
            destination.add(element);
        }
        List list = (List)destination;
        ((ArrayList)collection).addAll(list);
        return result2;
    }

    @Override
    @NotNull
    public Collection<KotlinType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<KotlinType> collection = this.resultValues;
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KotlinType> computeValues() {
        KotlinType intersectionOfUpperBounds;
        KotlinType superTypeOfAllLowerBounds;
        void numberLowerBounds;
        void generalLowerBounds;
        void $receiver;
        boolean hasStrongBound;
        Object it;
        Object element3;
        List bounds;
        LinkedHashSet values;
        block15: {
            boolean bl;
            Iterator destination;
            Iterable $receiver2;
            values = new LinkedHashSet();
            Iterable $receiver3 = this.getBounds();
            Iterable iterable = $receiver3;
            Collection collection = new ArrayList();
            for (Object element2 : $receiver2) {
                TypeBounds.Bound it2 = (TypeBounds.Bound)element2;
                if (!it2.isProper()) continue;
                destination.add(element2);
            }
            bounds = (List)((Object)destination);
            if (bounds.isEmpty()) {
                return kotlin.CollectionsKt.listOf();
            }
            $receiver2 = bounds;
            for (Object element3 : $receiver2) {
                it = (TypeBounds.Bound)element3;
                if (!((TypeBounds.Bound)it).getPosition().isStrong()) continue;
                bl = true;
                break block15;
            }
            bl = hasStrongBound = false;
        }
        if (!hasStrongBound) {
            return kotlin.CollectionsKt.listOf();
        }
        Set<KotlinType> exactBounds = this.filterBounds(bounds, TypeBounds.BoundKind.EXACT_BOUND, values);
        KotlinType bestFit = FlexibleTypesKt.singleBestRepresentative((Collection<? extends KotlinType>)exactBounds);
        if (bestFit != null && this.tryPossibleAnswer(bounds, bestFit)) {
            return kotlin.CollectionsKt.listOf(bestFit);
        }
        values.addAll(exactBounds);
        Iterable $i$f$any = this.filterBounds(bounds, TypeBounds.BoundKind.LOWER_BOUND, values);
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        for (Object element4 : $receiver) {
            KotlinType it3 = (KotlinType)element4;
            if (it3.getConstructor() instanceof IntegerValueTypeConstructor) {
                first.add(element4);
                continue;
            }
            second.add(element4);
        }
        Pair $i$a$1 = new Pair(first, second);
        element3 = $i$a$1.component1();
        it = $i$a$1.component2();
        $i$a$1 = null;
        KotlinType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection)generalLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfLowerBounds)) {
            KotlinType kotlinType = superTypeOfLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf(kotlinType);
        }
        CollectionsKt.addIfNotNull(values, superTypeOfLowerBounds);
        KotlinType superTypeOfNumberLowerBounds = TypeUtils.commonSupertypeForNumberTypes((Collection)numberLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfNumberLowerBounds)) {
            KotlinType kotlinType = superTypeOfNumberLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf(kotlinType);
        }
        CollectionsKt.addIfNotNull(values, superTypeOfNumberLowerBounds);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.tryPossibleAnswer(bounds, superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection<KotlinType>)kotlin.CollectionsKt.listOf(superTypeOfLowerBounds, superTypeOfNumberLowerBounds)))) {
            KotlinType kotlinType = superTypeOfAllLowerBounds;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            return SetsKt.setOf(kotlinType);
        }
        Set<KotlinType> upperBounds = this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND, values);
        if (kotlin.CollectionsKt.isNotEmpty((Collection)upperBounds) && (intersectionOfUpperBounds = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, upperBounds)) != null && this.tryPossibleAnswer(bounds, intersectionOfUpperBounds)) {
            return SetsKt.setOf(intersectionOfUpperBounds);
        }
        values.addAll(this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND));
        if (values.size() == 1 && AnnotationsForResolveKt.hasOnlyInputTypesAnnotation(this.getTypeVariable()) && !this.tryPossibleAnswer(bounds, (KotlinType)kotlin.CollectionsKt.first(values))) {
            return kotlin.CollectionsKt.listOf();
        }
        return values;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryPossibleAnswer(Collection<? extends TypeBounds.Bound> bounds, KotlinType possibleAnswer) {
        TypeBounds.BoundKind boundKind;
        if (possibleAnswer == null) {
            return false;
        }
        if (!possibleAnswer.getConstructor().isDenotable() && !CapturedTypeConstructorKt.isCaptured(possibleAnswer)) {
            return false;
        }
        if (AnnotationsForResolveKt.hasOnlyInputTypesAnnotation(this.getTypeVariable())) {
            void $receiver;
            Collection destination;
            TypeBounds.Bound it;
            void $receiver2;
            Iterable $receiver22;
            Iterable iterable = bounds;
            boundKind = $receiver22;
            Collection collection = new ArrayList();
            for (Object element : $receiver2) {
                it = (TypeBounds.Bound)element;
                if (!(it.isProper() && it.getConstrainingType().getConstructor().isDenotable())) continue;
                destination.add(element);
            }
            $receiver22 = (List)destination;
            $receiver2 = $receiver;
            destination = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault($receiver, 10));
            for (Object item : $receiver2) {
                it = (TypeBounds.Bound)item;
                Collection collection2 = destination;
                KotlinType kotlinType = it.getConstrainingType();
                collection2.add(kotlinType);
            }
            Set set = kotlin.CollectionsKt.toSet((List)destination);
            if (!set.contains(possibleAnswer)) {
                return false;
            }
        }
        for (TypeBounds.Bound bound : bounds) {
            boundKind = bound.getKind();
            if (!(Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.LOWER_BOUND) ? !KotlinTypeChecker.DEFAULT.isSubtypeOf(bound.getConstrainingType(), possibleAnswer) : (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.UPPER_BOUND) ? !KotlinTypeChecker.DEFAULT.isSubtypeOf(possibleAnswer, bound.getConstrainingType()) : Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.EXACT_BOUND) && !KotlinTypeChecker.DEFAULT.equalTypes(bound.getConstrainingType(), possibleAnswer)))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getTypeVariable() {
        return this.typeVariable;
    }

    @Override
    @NotNull
    public Variance getVarianceOfPosition() {
        return this.varianceOfPosition;
    }

    public TypeBoundsImpl(@NotNull TypeParameterDescriptor typeVariable, @NotNull Variance varianceOfPosition) {
        Intrinsics.checkParameterIsNotNull(typeVariable, "typeVariable");
        Intrinsics.checkParameterIsNotNull((Object)varianceOfPosition, "varianceOfPosition");
        this.typeVariable = typeVariable;
        this.varianceOfPosition = varianceOfPosition;
        this.bounds = new ArrayList();
    }

    @Override
    @Nullable
    public KotlinType getValue() {
        return TypeBounds.DefaultImpls.getValue(this);
    }
}

