/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.collectionUtils;

import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.ArraysKt;
import kotlin.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001\u0005\u0010\u000b\u0005!1!B\u0001\t\u0001\u0015\u0001Q!\u0001E\t\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015QR\u0007\u0005\u0001\u001b\u0011I!!C\u0001%\u0003a\u0005\u0011C\u0001\u0003\u0001\u0011\u0005Ir\u0001c\u0001\u000e\u000b%\u0011\u0011\"\u0001\u0013\u0002\u0019\u0003A\n!G\u0004\t\u00055)\u0011BA\u0005\u0002I\u0005a\t\u0001'\u0001U\u0007\u000biI\u0005B\"\u0011\u0011\ri!\u0001$\u0001%\u0003E\u0011A\u0001\u0001E\u0004#\u0011!\t\u0001C\u0001\u0016\u0003a!\u0011d\u0002E\u0005\u001b\u0015I1\u0001\"\u0001\n\u0003\u0011\u001e\u0001$B\r\u000b\u0011\u0017i\u0001\"\u0003\u0002\n\u0003\u0011\u001e\u0011bA\u0005\u0003\u0019\u0003!\u0013\u0001\u0007\u0004R\u0007\u0005Ai\u0001VB\u0003\u001b\u001b\"1\t\u0005\u0005\b\u001b\u0011I!!C\u0001%\u0003a\u0005\u0011C\u0001\u0003\u0001\u0011\u000f\t\"\u0001\"\u0001\t\u0003e9\u0001\u0012B\u0007\u0006\u0013\r!\t!C\u0001%\ba)\u0011\u0004\u0004E\u0006\u001b)I!!C\u0001%\b%)\u0011\u0002B\u0005\u0003\u0013\u0005!\u0013\u0001'\u0001\u0019\rE\u001b\u0011\u0001c\u0004U\u0007\u000bi!\u0004\u0003\u0005\u000e\u000b%\u0011\u0011\"\u0001\u0013\u0002\u0019\u0003A\n!\u0005\u0002\u0005\u0001!\tQ#B\u0005\u0003\u0013\u0005!\u0013\u0001$\u0001\u0019\u0002e=\u0001\u0012C\u0007\u0005\u0013\tI\u0011\u0001J\u0001\u0019\u0002A\u001b\t\u0001VB\u0003"}, strings={"concatInOrder", "", "T", "c1", "c2", "ScopeUtilsKt", "getFirstMatch", "Scope", "", "scopes", "", "callback", "Lkotlin/Function1;", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getFromAllScopes", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "concat", "collection"}, moduleName="kotlin-compiler")
public final class ScopeUtilsKt {
    @Nullable
    public static final <T> Collection<T> concat(Collection<? extends T> $receiver, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkParameterIsNotNull(collection, "collection");
        if (collection.isEmpty()) {
            return $receiver;
        }
        if ($receiver == null) {
            return collection;
        }
        if ($receiver instanceof LinkedHashSet) {
            ((LinkedHashSet)$receiver).addAll(collection);
            return $receiver;
        }
        LinkedHashSet<T> result2 = new LinkedHashSet<T>($receiver);
        result2.addAll(collection);
        return result2;
    }

    @NotNull
    public static final <T> Collection<T> concatInOrder(@Nullable Collection<? extends T> c1, @Nullable Collection<? extends T> c2) {
        Collection result2;
        Collection collection;
        Collection collection2;
        if (c1 == null || c1.isEmpty()) {
            collection2 = c2;
        } else if (c2 == null || c2.isEmpty()) {
            collection2 = c1;
        } else {
            LinkedHashSet<T> result3 = new LinkedHashSet<T>();
            result3.addAll(c1);
            result3.addAll(c2);
            collection2 = result3;
        }
        if ((collection = (result2 = collection2)) == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public static final <Scope, T> Collection<T> getFromAllScopes(@NotNull Scope[] scopes, @NotNull Function1<? super Scope, ? extends Collection<? extends T>> callback) {
        Intrinsics.checkParameterIsNotNull(scopes, "scopes");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        if (ArraysKt.isEmpty(scopes)) {
            return SetsKt.emptySet();
        }
        Collection<T> result2 = null;
        for (int i = 0; i < scopes.length; ++i) {
            Scope scope2 = scopes[i];
            result2 = ScopeUtilsKt.concat(result2, callback.invoke(scope2));
        }
        Collection<T> collection = result2;
        if (collection == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @Nullable
    public static final <Scope, T> T getFirstMatch(@NotNull Scope[] scopes, @NotNull Function1<? super Scope, ? extends T> callback) {
        Intrinsics.checkParameterIsNotNull(scopes, "scopes");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        for (int i = 0; i < scopes.length; ++i) {
            Scope scope2 = scopes[i];
            T result2 = callback.invoke(scope2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }
}

