/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ProjectBuilder;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildVariantUpdater {
    private static final Logger LOG = Logger.getInstance(BuildVariantUpdater.class);

    BuildVariantUpdater() {
    }

    @NotNull
    List<AndroidFacet> updateSelectedVariant(final @NotNull Project project, final @NotNull String moduleName, final @NotNull String buildVariantName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (buildVariantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildVariantName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        final ArrayList affectedFacets = Lists.newArrayList();
        Projects.executeProjectChanges(project, new Runnable(){

            @Override
            public void run() {
                Module updatedModule = BuildVariantUpdater.this.doUpdate(project, moduleName, buildVariantName, affectedFacets);
                if (updatedModule != null) {
                    ConflictSet conflicts = ConflictSet.findConflicts(project);
                    conflicts.showSelectionConflicts();
                }
                BuildVariantUpdater.generateSourcesIfNeeded(affectedFacets);
            }
        });
        ArrayList arrayList = affectedFacets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        return arrayList;
    }

    @NotNull
    List<AndroidFacet> updateTestArtifactsNames(@NotNull Project project, final @NotNull Iterable<Module> modules, final @NotNull String testArtifactName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateTestArtifactsNames"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateTestArtifactsNames"));
        }
        if (testArtifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testArtifactName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateTestArtifactsNames"));
        }
        final ArrayList affectedFacets = Lists.newArrayList();
        Projects.executeProjectChanges(project, new Runnable(){

            @Override
            public void run() {
                for (Module module : modules) {
                    AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                    assert (androidFacet != null);
                    IdeaAndroidProject ideaAndroidProject = androidFacet.getIdeaAndroidProject();
                    assert (ideaAndroidProject != null);
                    if (ideaAndroidProject.getSelectedTestArtifactName().equals(testArtifactName)) continue;
                    ideaAndroidProject.setSelectedTestArtifactName(testArtifactName);
                    androidFacet.syncSelectedVariantAndTestArtifact();
                    BuildVariantUpdater.invokeCustomizers(androidFacet.getModule(), ideaAndroidProject);
                    affectedFacets.add(androidFacet);
                }
                BuildVariantUpdater.generateSourcesIfNeeded(affectedFacets);
            }
        });
        ArrayList arrayList = affectedFacets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateTestArtifactsNames"));
        }
        return arrayList;
    }

    @Nullable
    private Module doUpdate(@NotNull Project project, @NotNull String moduleName, @NotNull String variant, @NotNull List<AndroidFacet> affectedFacets) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        if (affectedFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "doUpdate"));
        }
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module '%1$s'.", moduleName));
            return null;
        }
        AndroidFacet facet = BuildVariantUpdater.getAndroidFacet(moduleToUpdate, variant);
        if (facet == null) {
            return null;
        }
        IdeaAndroidProject androidProject = BuildVariantUpdater.getAndroidProject(facet, variant);
        if (androidProject == null) {
            return null;
        }
        if (!this.updateSelectedVariant(facet, androidProject, variant, affectedFacets)) {
            return null;
        }
        affectedFacets.add(facet);
        return moduleToUpdate;
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "findModule"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "findModule"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName);
    }

    private boolean updateSelectedVariant(@NotNull AndroidFacet androidFacet, @NotNull IdeaAndroidProject androidProject, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedFacets) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (variantToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantToSelect", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        if (affectedFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "updateSelectedVariant"));
        }
        Variant selectedVariant = androidProject.getSelectedVariant();
        if (variantToSelect.equals(selectedVariant.getName())) {
            return false;
        }
        androidProject.setSelectedVariantName(variantToSelect);
        androidFacet.syncSelectedVariantAndTestArtifact();
        Module module = BuildVariantUpdater.invokeCustomizers(androidFacet.getModule(), androidProject);
        selectedVariant = androidProject.getSelectedVariant();
        for (AndroidLibrary library : selectedVariant.getMainArtifact().getDependencies().getLibraries()) {
            String projectVariant;
            String gradlePath = library.getProject();
            if (StringUtil.isEmpty((String)gradlePath) || !StringUtil.isNotEmpty((String)(projectVariant = library.getProjectVariant()))) continue;
            this.ensureVariantIsSelected(module.getProject(), gradlePath, projectVariant, affectedFacets);
        }
        return true;
    }

    private static void generateSourcesIfNeeded(@NotNull List<AndroidFacet> affectedFacets) {
        if (affectedFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "generateSourcesIfNeeded"));
        }
        if (!affectedFacets.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            Project project = affectedFacets.get(0).getModule().getProject();
            ProjectBuilder.getInstance(project).generateSourcesOnly();
        }
    }

    @NotNull
    private static Module invokeCustomizers(@NotNull Module module, @NotNull IdeaAndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "invokeCustomizers"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "invokeCustomizers"));
        }
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(module.getProject());
        try {
            for (ModuleCustomizer moduleCustomizer : BuildVariantUpdater.getCustomizers(androidProject.getProjectSystemId())) {
                moduleCustomizer.customizeModule(module.getProject(), module, (IdeModifiableModelsProvider)modelsProvider, androidProject);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "invokeCustomizers"));
        }
        return module2;
    }

    @NotNull
    private static List<BuildVariantModuleCustomizer<IdeaAndroidProject>> getCustomizers(@NotNull ProjectSystemId targetProjectSystemId) {
        if (targetProjectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetProjectSystemId", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getCustomizers"));
        }
        List<BuildVariantModuleCustomizer<IdeaAndroidProject>> list = BuildVariantUpdater.getCustomizers(targetProjectSystemId, (BuildVariantModuleCustomizer[])BuildVariantModuleCustomizer.EP_NAME.getExtensions());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getCustomizers"));
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    static List<BuildVariantModuleCustomizer<IdeaAndroidProject>> getCustomizers(@NotNull ProjectSystemId targetProjectSystemId, BuildVariantModuleCustomizer ... allCustomizers) {
        if (targetProjectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetProjectSystemId", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getCustomizers"));
        }
        if (allCustomizers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allCustomizers", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getCustomizers"));
        }
        ArrayList customizers = Lists.newArrayList();
        for (BuildVariantModuleCustomizer customizer : allCustomizers) {
            ProjectSystemId projectSystemId;
            if (!IdeaAndroidProject.class.isAssignableFrom(customizer.getSupportedModelType()) || !Objects.equal((Object)(projectSystemId = customizer.getProjectSystemId()), (Object)targetProjectSystemId) && !Objects.equal((Object)projectSystemId, (Object)ProjectSystemId.IDE)) continue;
            customizers.add(customizer);
        }
        ArrayList arrayList = customizers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getCustomizers"));
        }
        return arrayList;
    }

    private void ensureVariantIsSelected(@NotNull Project project, @NotNull String moduleGradlePath, @NotNull String variant, @NotNull List<AndroidFacet> affectedFacets) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        if (moduleGradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleGradlePath", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        if (affectedFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFacets", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "ensureVariantIsSelected"));
        }
        Module module = GradleUtil.findModuleByGradlePath(project, moduleGradlePath);
        if (module == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module with Gradle path '%1$s'.", moduleGradlePath));
            return;
        }
        AndroidFacet facet = BuildVariantUpdater.getAndroidFacet(module, variant);
        if (facet == null) {
            return;
        }
        IdeaAndroidProject androidProject = BuildVariantUpdater.getAndroidProject(facet, variant);
        if (androidProject == null) {
            return;
        }
        if (!this.updateSelectedVariant(facet, androidProject, variant, affectedFacets)) {
            return;
        }
        affectedFacets.add(facet);
    }

    @Nullable
    private static AndroidFacet getAndroidFacet(@NotNull Module module, @NotNull String variantToSelect) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getAndroidFacet"));
        }
        if (variantToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantToSelect", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getAndroidFacet"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find 'Android' facet in module '%1$s'.", module.getName()));
        }
        return facet;
    }

    @Nullable
    private static IdeaAndroidProject getAndroidProject(@NotNull AndroidFacet facet, @NotNull String variantToSelect) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getAndroidProject"));
        }
        if (variantToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantToSelect", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "getAndroidProject"));
        }
        IdeaAndroidProject androidProject = facet.getIdeaAndroidProject();
        if (androidProject == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find AndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return androidProject;
    }

    private static void logAndShowUpdateFailure(@NotNull String buildVariantName, @NotNull String reason) {
        if (buildVariantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildVariantName", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "logAndShowUpdateFailure"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater", "logAndShowUpdateFailure"));
        }
        String prefix = String.format("Unable to select build variant '%1$s':\n", buildVariantName);
        String msg = prefix + reason;
        LOG.error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }
}

