/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.model.ManifestInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergedManifestInfo
extends ManifestInfo {
    @NotNull
    private final Module myModule;
    @NotNull
    private final AndroidFacet myFacet;
    private Set<VirtualFile> myManifestFiles;
    private final AtomicLong myLastChecked;
    private AtomicReference<List<Manifest>> myManifestsRef;
    private static final String MERGING_UNSUPPORTED = "This class does not perform a proper manifest merge algorithm, and so the requested information isn't available. Consider querying the Gradle model or obtain the information from the primary manifest.";

    MergedManifestInfo(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/model/MergedManifestInfo", "<init>"));
        }
        this.myManifestFiles = Sets.newHashSet();
        this.myLastChecked = new AtomicLong(0L);
        this.myManifestsRef = new AtomicReference(Collections.emptyList());
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        this.myModule = module;
        this.myFacet = facet;
    }

    @NotNull
    private static Set<VirtualFile> getAllManifests(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/model/MergedManifestInfo", "getAllManifests"));
        }
        HashSet allManifests = Sets.newHashSet();
        allManifests.addAll(IdeaSourceProvider.getManifestFiles(facet));
        for (AndroidFacet dependency : AndroidUtils.getAllAndroidDependencies(facet.getModule(), true)) {
            allManifests.addAll(IdeaSourceProvider.getManifestFiles(dependency));
        }
        HashSet hashSet = allManifests;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifestInfo", "getAllManifests"));
        }
        return hashSet;
    }

    @Override
    public void clear() {
        this.myLastChecked.set(0L);
    }

    @Override
    @Nullable
    public String getPackage() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    @NotNull
    public Map<String, ManifestInfo.ActivityAttributes> getActivityAttributesMap() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    @Nullable
    public ManifestInfo.ActivityAttributes getActivityAttributes(@NotNull String activity) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/android/tools/idea/model/MergedManifestInfo", "getActivityAttributes"));
        }
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    @Nullable
    public String getManifestTheme() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    @NotNull
    public String getDefaultTheme(@Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device) {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    @Nullable
    public String getApplicationIcon() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    @Nullable
    public String getApplicationLabel() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public boolean isRtlSupported() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    @Nullable
    public Boolean getApplicationDebuggable() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    @NotNull
    protected List<Manifest> getManifests() {
        this.sync();
        List<Manifest> list = this.myManifestsRef.get();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifestInfo", "getManifests"));
        }
        return list;
    }

    private void sync() {
        boolean needsRefresh = false;
        Set<VirtualFile> currentManifests = MergedManifestInfo.getAllManifests(this.myFacet);
        if (!currentManifests.equals(this.myManifestFiles)) {
            this.myManifestFiles = currentManifests;
            this.myLastChecked.set(0L);
            needsRefresh = true;
        }
        long maxLastModified = this.getMaxLastModified();
        if (this.myLastChecked.get() < maxLastModified) {
            this.myLastChecked.set(maxLastModified);
            needsRefresh = true;
        }
        if (needsRefresh) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    MergedManifestInfo.this.syncWithReadPermission();
                }
            });
        }
    }

    private long getMaxLastModified() {
        long max = 0L;
        for (VirtualFile f : this.myManifestFiles) {
            if (f.getModificationStamp() <= max) continue;
            max = f.getModificationStamp();
        }
        return max;
    }

    private void syncWithReadPermission() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList manifests = Lists.newArrayListWithExpectedSize((int)this.myManifestFiles.size());
        for (VirtualFile f : this.myManifestFiles) {
            Manifest m;
            PsiFile psiFile = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(f);
            if (!(psiFile instanceof XmlFile) || (m = AndroidUtils.loadDomElementWithReadPermission(this.myModule.getProject(), (XmlFile)psiFile, Manifest.class)) == null) continue;
            manifests.add(m);
        }
        this.myManifestsRef.set(manifests);
    }
}

