/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.wizard.CircularParameterDependencyException;
import com.android.tools.idea.wizard.StringEvaluator;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterDefaultValueComputer {
    private static final Deduplicator DO_NOTHING_DEDUPLICATOR = new Deduplicator(){

        @Override
        @Nullable
        public String deduplicate(@NotNull Parameter parameter, @Nullable String value) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/wizard/ParameterDefaultValueComputer$1", "deduplicate"));
            }
            return value;
        }
    };
    @NotNull
    private final Set<Parameter> myComputedParameters;
    @NotNull
    private final Set<Parameter> myStaticParameters;
    @NotNull
    private final Deduplicator myDeduplicator;
    @NotNull
    private final StringEvaluator myStringEvaluator;
    @NotNull
    private final Map<Parameter, Object> myUserValues;
    @NotNull
    private final Map<String, Object> myImplicitParameters;

    @Nullable
    private static Object decodeInitialValue(Parameter input, @Nullable String initial) {
        if (initial != null && input.type == Parameter.Type.BOOLEAN) {
            return Boolean.valueOf(initial);
        }
        return initial;
    }

    public ParameterDefaultValueComputer(@NotNull Iterable<Parameter> parameters, @NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> implicitParameters, @Nullable Deduplicator deduplicator) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/idea/wizard/ParameterDefaultValueComputer", "<init>"));
        }
        if (userValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userValues", "com/android/tools/idea/wizard/ParameterDefaultValueComputer", "<init>"));
        }
        if (implicitParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implicitParameters", "com/android/tools/idea/wizard/ParameterDefaultValueComputer", "<init>"));
        }
        this.myComputedParameters = Sets.newHashSet();
        this.myStaticParameters = Sets.newHashSet();
        this.myStringEvaluator = new StringEvaluator();
        this.myUserValues = userValues;
        this.myImplicitParameters = implicitParameters;
        for (Parameter parameter : parameters) {
            if (parameter == null || StringUtil.isEmptyOrSpaces((String)parameter.id)) continue;
            if (!StringUtil.isEmptyOrSpaces((String)parameter.suggest) && !userValues.containsKey(parameter)) {
                this.myComputedParameters.add(parameter);
                continue;
            }
            this.myStaticParameters.add(parameter);
        }
        this.myDeduplicator = deduplicator == null ? DO_NOTHING_DEDUPLICATOR : deduplicator;
    }

    public Map<Parameter, Object> getParameterValues() throws CircularParameterDependencyException {
        Map<String, Object> staticValues = this.getStaticParameterValues(this.myUserValues, this.myImplicitParameters);
        Map<String, Object> computedValues = this.computeParameterValues(staticValues);
        HashMap allValues = Maps.newHashMapWithExpectedSize((int)(computedValues.size() + staticValues.size()));
        for (Parameter parameter : Iterables.concat(this.myStaticParameters, this.myComputedParameters)) {
            allValues.put(parameter, computedValues.get(parameter.id));
        }
        return allValues;
    }

    @Nullable
    private Object computeParameterValue(@NotNull Parameter computedParameter, @NotNull Map<String, Object> currentValues) {
        if (computedParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computedParameter", "com/android/tools/idea/wizard/ParameterDefaultValueComputer", "computeParameterValue"));
        }
        if (currentValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValues", "com/android/tools/idea/wizard/ParameterDefaultValueComputer", "computeParameterValue"));
        }
        String suggest = computedParameter.suggest;
        assert (!StringUtil.isEmptyOrSpaces((String)suggest));
        String value = this.myStringEvaluator.evaluate(suggest, currentValues);
        value = this.myDeduplicator.deduplicate(computedParameter, value);
        return ParameterDefaultValueComputer.decodeInitialValue(computedParameter, value);
    }

    private Map<String, Object> getStaticParameterValues(@NotNull Map<Parameter, Object> values, @NotNull Map<String, Object> implicitParameters) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/wizard/ParameterDefaultValueComputer", "getStaticParameterValues"));
        }
        if (implicitParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implicitParameters", "com/android/tools/idea/wizard/ParameterDefaultValueComputer", "getStaticParameterValues"));
        }
        HashMap knownValues = Maps.newHashMapWithExpectedSize((int)(this.myStaticParameters.size() + implicitParameters.size()));
        knownValues.putAll(implicitParameters);
        for (Parameter parameter : this.myStaticParameters) {
            Object value;
            if (values.containsKey(parameter)) {
                value = values.get(parameter);
            } else {
                String initial = parameter.initial;
                value = ParameterDefaultValueComputer.decodeInitialValue(parameter, initial);
            }
            knownValues.put(parameter.id, value);
        }
        return knownValues;
    }

    private Map<String, Object> computeParameterValues(Map<String, Object> staticValues) throws CircularParameterDependencyException {
        HashMap computedValues = Maps.newHashMapWithExpectedSize((int)(this.myComputedParameters.size() + staticValues.size()));
        computedValues.putAll(staticValues);
        for (Parameter parameter : this.myComputedParameters) {
            computedValues.put(parameter.id, "");
        }
        int maxIterations = this.myComputedParameters.size();
        Object updatedValues = ImmutableMap.of();
        for (int i = 0; i <= maxIterations; ++i) {
            updatedValues = this.computeUpdatedValues(computedValues);
            if (updatedValues.isEmpty()) {
                return computedValues;
            }
            computedValues.putAll(updatedValues);
        }
        throw new CircularParameterDependencyException(updatedValues.keySet());
    }

    @NotNull
    private Map<String, Object> computeUpdatedValues(@NotNull Map<String, Object> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/wizard/ParameterDefaultValueComputer", "computeUpdatedValues"));
        }
        HashMap updatedValues = Maps.newHashMapWithExpectedSize((int)this.myComputedParameters.size());
        for (Parameter computedParameter : this.myComputedParameters) {
            Object value = this.computeParameterValue(computedParameter, values);
            String id = computedParameter.id;
            if (Objects.equal((Object)values.get(id), (Object)value)) continue;
            updatedValues.put(id, value);
        }
        HashMap hashMap = updatedValues;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ParameterDefaultValueComputer", "computeUpdatedValues"));
        }
        return hashMap;
    }

    public static interface Deduplicator {
        @Nullable
        public String deduplicate(@NotNull Parameter var1, @Nullable String var2);
    }
}

