/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"I\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0003\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011\u0015Aa\u0003\u0007\u00013\u0005A\n!i\u0004\u0005\u0017%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003C\u001f!1\"C\u0002\t\u00065\t\u0001dA)\u0004\u0003!\u001dQU\u0007\u0003\f\u0011\u0017i\u0011\u0001\n\u0004\u0012\u0005\u0011\u0001\u0001BB\t\u0003\t\u0003Ai!G\u0005\t\u000f59\u0011BA\u0005\u0002I\u0019I!!C\u0001%\u000ea=\u0011d\u0001\u0005\t\u001b\u0005!k!U\u0002\u0002\u0011#)C\u0001C\u0005\u000e\u00051\u0005\u00014C\u0013\u0005\u0011)i!\u0001$\u0001\u0019\u0014\u00152\u0001RC\u0007\u0005\u0013\tI\u0011\u0001g\u0006\u0019\u0017\u00152\u0001\u0002D\u0007\u0005\u0013\tI\u0011\u0001'\u0007\u0019\u0017\u0015*AA\u0001\u0005\u000e\u001b\ta\t\u0001g\u0007&\u0007!qQ\"\u0001M\u000fK%!1\u0002C\b\u000e\u0003au\u0011\u0004\u0002E\u0010\u001b\ta\t\u0001g\u0005&\u0007!\u0001R\"\u0001M\u000fK\rA\t#D\u0001\u0019\u001e\u0015\u001a\u0001\"E\u0007\u00021;I3\u0002B!\t\u0011\u0011i!\u0001$\u0001\u0019\u0007q\t\u0013kA\u0002\u000e\u0005\u0011%\u0001\"\u0002"}, strings={"Lorg/jetbrains/kotlin/psi/KtClass;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;)V", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getClassOrInterfaceKeyword", "Lcom/intellij/psi/PsiElement;", "getColon", "getCompanionObjects", "", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "getProperties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getQualifiedName", "", "isEnum", "", "isEquivalentTo", "another", "isInner", "isInterface", "isSealed"}, moduleName="kotlin-compiler")
public class KtClass
extends KtClassOrObject {
    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitClass(this, data);
    }

    private final KotlinClassStub get_stub() {
        KotlinClassOrObjectStub kotlinClassOrObjectStub = (KotlinClassOrObjectStub)this.getStub();
        if (!(kotlinClassOrObjectStub instanceof KotlinClassStub)) {
            kotlinClassOrObjectStub = null;
        }
        return (KotlinClassStub)kotlinClassOrObjectStub;
    }

    @Nullable
    public final PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @NotNull
    public final List<KtProperty> getProperties() {
        KtClassBody ktClassBody = this.getBody();
        return CollectionsKt.orEmpty(ktClassBody != null ? ktClassBody.getProperties() : null);
    }

    public final boolean isInterface() {
        KotlinClassStub kotlinClassStub = this.get_stub();
        return kotlinClassStub != null ? kotlinClassStub.isInterface() : this.findChildByType(KtTokens.INTERFACE_KEYWORD) != null;
    }

    public final boolean isEnum() {
        return this.hasModifier(KtTokens.ENUM_KEYWORD);
    }

    public final boolean isSealed() {
        return this.hasModifier(KtTokens.SEALED_KEYWORD);
    }

    public final boolean isInner() {
        return this.hasModifier(KtTokens.INNER_KEYWORD);
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        if (another instanceof KtClass) {
            String fq1 = this.getQualifiedName();
            String fq2 = ((KtClass)another).getQualifiedName();
            return fq1 != null && fq2 != null && Intrinsics.areEqual(fq1, fq2);
        }
        return false;
    }

    @Nullable
    protected final String getQualifiedName() {
        KotlinClassOrObjectStub stub = (KotlinClassOrObjectStub)this.getStub();
        if (stub != null) {
            FqName fqName2;
            FqName fqName3 = fqName2 = stub.getFqName();
            return fqName3 != null ? fqName3.asString() : null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        KtClassOrObject current = this;
        while (current != null) {
            String string = current.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            parts.add(string);
            current = PsiTreeUtil.getParentOfType((PsiElement)current, KtClassOrObject.class);
        }
        PsiFile file = this.getContainingFile();
        if (!(file instanceof KtFile)) {
            return null;
        }
        String fileQualifiedName = ((KtFile)file).getPackageFqName().asString();
        if (!StringsKt.isEmpty(fileQualifiedName)) {
            parts.add(fileQualifiedName);
        }
        Collections.reverse((List)parts);
        return StringUtil.join((Collection<String>)parts, ".");
    }

    @NotNull
    public final List<KtObjectDeclaration> getCompanionObjects() {
        KtClassBody ktClassBody = this.getBody();
        return CollectionsKt.orEmpty(ktClassBody != null ? ktClassBody.getAllCompanionObjects() : null);
    }

    @Nullable
    public final PsiElement getClassOrInterfaceKeyword() {
        return this.findChildByType(TokenSet.create(KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD));
    }

    public KtClass(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }

    public KtClass(@NotNull KotlinClassStub stub) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        IStubElementType iStubElementType = KtStubElementTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull(iStubElementType, "KtStubElementTypes.CLASS");
        super(kotlinClassOrObjectStub, iStubElementType);
    }
}

