/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtClassBody
extends KtElementImplStub<KotlinPlaceHolderStub<KtClassBody>>
implements KtDeclarationContainer {
    public KtClassBody(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtClassBody", "<init>"));
        }
        super(node);
    }

    public KtClassBody(@NotNull KotlinPlaceHolderStub<KtClassBody> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtClassBody", "<init>"));
        }
        super(stub, KtStubElementTypes.CLASS_BODY);
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        List<PsiElement> list = Arrays.asList(this.getStubOrPsiChildren(KtStubElementTypes.DECLARATION_TYPES, KtDeclaration.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtClassBody", "getDeclarations"));
        }
        return list;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtClassBody", "accept"));
        }
        return visitor2.visitClassBody(this, data);
    }

    @NotNull
    public List<KtClassInitializer> getAnonymousInitializers() {
        List<KtClassInitializer> list = this.findChildrenByType(KtNodeTypes.ANONYMOUS_INITIALIZER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtClassBody", "getAnonymousInitializers"));
        }
        return list;
    }

    @NotNull
    List<KtSecondaryConstructor> getSecondaryConstructors() {
        List<KtSecondaryConstructor> list = this.getStubOrPsiChildrenAsList(KtStubElementTypes.SECONDARY_CONSTRUCTOR);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtClassBody", "getSecondaryConstructors"));
        }
        return list;
    }

    @NotNull
    public List<KtProperty> getProperties() {
        List<KtProperty> list = this.getStubOrPsiChildrenAsList(KtStubElementTypes.PROPERTY);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtClassBody", "getProperties"));
        }
        return list;
    }

    @NotNull
    public List<KtObjectDeclaration> getAllCompanionObjects() {
        ArrayList<KtObjectDeclaration> result2 = Lists.newArrayList();
        for (KtObjectDeclaration declaration : this.getStubOrPsiChildrenAsList(KtStubElementTypes.OBJECT_DECLARATION)) {
            if (!declaration.isCompanion()) continue;
            result2.add(declaration);
        }
        ArrayList<KtObjectDeclaration> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtClassBody", "getAllCompanionObjects"));
        }
        return arrayList;
    }

    @Nullable
    public PsiElement getRBrace() {
        ASTNode[] children = this.getNode().getChildren(TokenSet.create(KtTokens.RBRACE));
        return children.length == 1 ? children[0].getPsi() : null;
    }

    @Nullable
    public PsiElement getLBrace() {
        ASTNode[] children = this.getNode().getChildren(TokenSet.create(KtTokens.LBRACE));
        return children.length == 1 ? children[0].getPsi() : null;
    }

    @NotNull
    public List<KtAnnotationEntry> getDanglingAnnotations() {
        List<KtAnnotationEntry> list = CollectionsKt.flatMap(this.getStubOrPsiChildrenAsList(KtStubElementTypes.MODIFIER_LIST), new Function1<KtModifierList, Iterable<KtAnnotationEntry>>(){

            @Override
            public Iterable<KtAnnotationEntry> invoke(KtModifierList modifierList) {
                return modifierList.getAnnotationEntries();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtClassBody", "getDanglingAnnotations"));
        }
        return list;
    }
}

