/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddFile;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.jgit.dirCache.PathEdit;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsUrlBuilderKt;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"=\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u001f\u0015\tA!AG\u0013\u0011\u0001i\u0011\u0001'\u0001\u001a\u0007!\tQ\"\u0001M\u00023\u0011A!!\u0004\u0002\r\u0002a\u0015\u0011\u0004\u0002\u0003\u0002\u0011\ri\u0011\u0001g\u0002U\u0007\u0011i\u0019\u0002B\u0001\t\n5\t\u0001$B\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004U\u0007\u0011iA\u0004B\u0001\t\u000e5\t\u0001dB\u000b\u00021\u001fIJ\u0001\u0003\u0005\u000e\u0003a)\u0001k!\u0001\u001a\u0010!EQ\u0002B\u0005\u0003\u0013\u0005AR\u0001G\u0005Q\u0007\u0005IZ\u0001B\u0001\t\u00145\t\u0001\u0014\u0001)\u0004\u0004Q\u001bA!d\u000b\u0005\u0003!QQ\"\u0001\r\b+\u0005Az!'\u0003\t\u00115\t\u0001$\u0002)\u0004\u0002e=\u0001\u0012C\u0007\u0005\u0013\tI\u0011\u0001G\u0003\u0019\u0013A\u001b\u0011\u0001V\u0002\u0005"}, strings={"commit", "", "repository", "Lorg/eclipse/jgit/lib/Repository;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "commitMessageFormatter", "Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "CommitKt", "indexDiffToString", "", "diff", "Lorg/eclipse/jgit/lib/IndexDiff;", "addList", "", "Ljava/lang/StringBuilder;", "name", "list", "", "compact", "appendCompactList"}, moduleName="settings-repository")
public final class CommitKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean commit(@NotNull Repository repository2, @Nullable ProgressIndicator indicator, @NotNull CommitMessageFormatter commitMessageFormatter) {
        Unit unit;
        void $receiver;
        Object edits;
        Unit unit2;
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)commitMessageFormatter, (String)"commitMessageFormatter");
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        IndexDiff diff = GitExKt.computeIndexDiff(repository2);
        ProgressIndicator progressIndicator2 = indicator;
        boolean changed = diff.diff((ProgressMonitor)(progressIndicator2 != null ? JGitProgressMonitorKt.asProgressMonitor(progressIndicator2) : null), 0, 0, "Commit");
        if (!changed || diff.getAdded().isEmpty() && diff.getChanged().isEmpty() && diff.getRemoved().isEmpty()) {
            if (diff.getModified().isEmpty()) {
                IcsManagerKt.getLOG().debug("Nothing to commit");
                return false;
            }
            edits = null;
            for (String path : diff.getModified()) {
                if (StringsKt.startsWith$default((String)path, (String)IcsUrlBuilderKt.getPROJECTS_DIR_NAME(), (boolean)false, (int)2)) continue;
                if (edits == null) {
                    edits = (List)new SmartList();
                }
                String string = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                edits.add(new AddFile(string));
            }
            if (edits != null) {
                DirCacheEditorKt.edit(repository2, (List<? extends PathEdit>)edits);
            }
        }
        edits = IcsManagerKt.getLOG();
        if ($receiver.isDebugEnabled()) {
            void var8_8 = $receiver;
            String string = CommitKt.indexDiffToString(diff);
            var8_8.debug(string);
        }
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            progressIndicator3.checkCanceled();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        StringBuilder builder = new StringBuilder();
        commitMessageFormatter.prependMessage(builder);
        Collection collection = diff.getChanged();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"diff.changed");
        CommitKt.appendCompactList(builder, "Update", collection);
        Collection collection2 = diff.getAdded();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"diff.added");
        CommitKt.appendCompactList(builder, "Create", collection2);
        Collection collection3 = diff.getRemoved();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"diff.removed");
        CommitKt.appendCompactList(builder, "Delete", collection3);
        GitExKt.commit$default(repository2, builder.toString(), null, null, null, 14);
        return true;
    }

    public static /* synthetic */ boolean commit$default(Repository repository2, ProgressIndicator progressIndicator, CommitMessageFormatter commitMessageFormatter, int n) {
        if ((n & 4) != 0) {
            commitMessageFormatter = new IdeaCommitMessageFormatter();
        }
        return CommitKt.commit(repository2, progressIndicator, commitMessageFormatter);
    }

    private static final String indexDiffToString(IndexDiff diff) {
        StringBuilder builder = new StringBuilder();
        builder.append("To commit:");
        Collection collection = diff.getAdded();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"diff.added");
        CommitKt.addList$default(builder, "Added", collection, false, 4);
        Collection collection2 = diff.getChanged();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"diff.changed");
        CommitKt.addList$default(builder, "Changed", collection2, false, 4);
        Collection collection3 = diff.getRemoved();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"diff.removed");
        CommitKt.addList$default(builder, "Deleted", collection3, false, 4);
        Collection collection4 = diff.getModified();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"diff.modified");
        CommitKt.addList$default(builder, "Modified on disk relative to the index", collection4, false, 4);
        Collection collection5 = diff.getUntracked();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection5, (String)"diff.untracked");
        CommitKt.addList$default(builder, "Untracked files", collection5, false, 4);
        Collection collection6 = diff.getUntrackedFolders();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection6, (String)"diff.untrackedFolders");
        CommitKt.addList$default(builder, "Untracked folders", collection6, false, 4);
        Collection collection7 = diff.getMissing();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection7, (String)"diff.missing");
        CommitKt.addList$default(builder, "Missing", collection7, false, 4);
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    private static final void appendCompactList(StringBuilder $receiver, String name, Collection<? extends String> list) {
        CommitKt.addList($receiver, name, list, true);
    }

    private static final void addList(StringBuilder $receiver, String name, Collection<? extends String> list, boolean compact) {
        if (list.isEmpty()) {
            return;
        }
        if (compact) {
            if ($receiver.length() != 0 && $receiver.charAt($receiver.length() - 1) != ' ') {
                $receiver.append('\t');
            }
            $receiver.append(name);
        } else {
            $receiver.append('\t').append(name).append(':');
        }
        $receiver.append(' ');
        boolean isNotFirst = false;
        for (String string : list) {
            if (isNotFirst) {
                $receiver.append(',').append(' ');
            } else {
                isNotFirst = true;
            }
            $receiver.append(compact ? PathUtilRt.getFileName((String)string) : string);
        }
    }

    static /* synthetic */ void addList$default(StringBuilder stringBuilder, String string, Collection collection, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        CommitKt.addList(stringBuilder, string, collection, bl);
    }
}

