/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.annotations.NonNull;
import com.android.annotations.concurrency.Immutable;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourcePosition;
import com.google.common.base.Objects;
import java.io.File;

@Immutable
public final class SourceFilePosition {
    public static final SourceFilePosition UNKNOWN = new SourceFilePosition(SourceFile.UNKNOWN, SourcePosition.UNKNOWN);
    @NonNull
    private final SourceFile mSourceFile;
    @NonNull
    private final SourcePosition mSourcePosition;

    public SourceFilePosition(@NonNull SourceFile sourceFile, @NonNull SourcePosition sourcePosition) {
        this.mSourceFile = sourceFile;
        this.mSourcePosition = sourcePosition;
    }

    public SourceFilePosition(@NonNull File file, @NonNull SourcePosition sourcePosition) {
        this(new SourceFile(file), sourcePosition);
    }

    @NonNull
    public SourcePosition getPosition() {
        return this.mSourcePosition;
    }

    @NonNull
    public SourceFile getFile() {
        return this.mSourceFile;
    }

    public String toString() {
        return this.print(false);
    }

    public String print(boolean shortFormat) {
        if (this.mSourcePosition.equals(SourcePosition.UNKNOWN)) {
            return this.mSourceFile.print(shortFormat);
        }
        return this.mSourceFile.print(shortFormat) + ':' + this.mSourcePosition.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mSourceFile, this.mSourcePosition});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SourceFilePosition)) {
            return false;
        }
        SourceFilePosition other = (SourceFilePosition)obj;
        return Objects.equal((Object)this.mSourceFile, (Object)other.mSourceFile) && Objects.equal((Object)this.mSourcePosition, (Object)other.mSourcePosition);
    }
}

