/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineHolderGeneratingProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0005\u00011\u0001\u0011$\u0001M\u0001;\u00035\u0011UA)\u0004\u0003!\tQ%\u0004\u0003\u0002\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\t!\u0015QB\u0001G\u00011\rI2\u0001c\u0002\u000e\u0003a\u0011Q\u0005\u0005\u0003\f\u0011\u0011i\u0011\u0001'\u0003\u001a\u0007!)Q\"\u0001M\u00063\rA9!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\r)\u0003\u0003B\u0006\t\r5\t\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001g\u0003\u001a\u0007!\u001dQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007\u0001"}, strings={"Lorg/intellij/markdown/flavours/gfm/CheckedListItemGeneratingProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "()V", "getIsCheckedString", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "text", "openTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "processNode", "SubParagraphGeneratingProvider"}, moduleName="intellij-markdown")
public final class CheckedListItemGeneratingProvider
extends SimpleTagProvider {
    @Override
    public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
    }

    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        CharSequence inputHtml;
        CharSequence listItemClass;
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PreconditionsKt.assert((boolean)(node instanceof ListItemCompositeNode));
        ASTNode checkBoxElement = ASTUtilKt.findChildOfType(node, GFMTokenTypes.INSTANCE.getCHECK_BOX());
        if (checkBoxElement != null) {
            listItemClass = "class=\"task-list-item\"";
            String checkedString = this.getIsCheckedString(checkBoxElement, text);
            inputHtml = "<input type=" + "\"" + "checkbox" + "\"" + " class=" + "\"" + "task-list-item-checkbox" + "\"" + checkedString + " disabled />";
        } else {
            listItemClass = null;
            inputHtml = "";
        }
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "li", new CharSequence[]{listItemClass}, false, 8);
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.intellij.markdown.ast.impl.ListItemCompositeNode");
        }
        ListCompositeNode listCompositeNode = ((ListItemCompositeNode)aSTNode).getParent();
        if (listCompositeNode == null) {
            Intrinsics.throwNpe();
        }
        boolean isLoose = listCompositeNode.getLoose();
        boolean flushedInput = false;
        for (ASTNode child : ((ListItemCompositeNode)node).getChildren()) {
            if (child instanceof LeafASTNode) continue;
            if (!flushedInput) {
                if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownElementTypes.Companion.getPARAGRAPH())) {
                    new SubParagraphGeneratingProvider(isLoose, (String)inputHtml).processNode(visitor, text, child);
                } else {
                    visitor.consumeHtml(inputHtml);
                    child.accept(visitor);
                }
                flushedInput = true;
                continue;
            }
            child.accept(visitor);
        }
        this.closeTag(visitor, text, node);
    }

    /*
     * WARNING - void declaration
     */
    private final String getIsCheckedString(ASTNode node, String text) {
        Boolean bl;
        Object object = node;
        if (object != null && (object = ASTUtilKt.getTextInNode((ASTNode)object, text)) != null) {
            void $receiver;
            Object object2 = object;
            CharSequence it = (CharSequence)$receiver;
            bl = it.length() > 1 && it.charAt(1) != ' ';
        } else {
            bl = null;
        }
        boolean isChecked = Intrinsics.areEqual(bl, (Object)true);
        String checkedString = isChecked ? " checked" : "";
        return checkedString;
    }

    public CheckedListItemGeneratingProvider() {
        super("li");
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!1!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001A!\u0001\u0007\u00013\u0005A\n!)\u0006\n\u0007!\tQ\"\u0001M\u0002\u0013\rA!!D\u0001\u0019\u0006E\u001b\u0011\u0001C\u0002&!\u0011Y\u00012B\u0007\u00021\u0019I2\u0001#\u0004\u000e\u0003a9\u0011d\u0001E\b\u001b\u0005A*!G\u0002\t\u00115\t\u0001\u0014C\u0013\u0011\t-A\u0011\"D\u0001\u0019\re\u0019\u0001RB\u0007\u00021\u001dI2\u0001c\u0004\u000e\u0003a\u0015\u0011d\u0001\u0005\t\u001b\u0005A\n\"\u000b\u0006\u0005\u0007\"A!!D\u0001\u0019\u0006E\u001bA!\u0002\u0001\u000e\u0005\u0011\u001d\u0001\u0002B\u0015\u000b\t\rC\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!I\u0001C\u0003"}, strings={"Lorg/intellij/markdown/flavours/gfm/CheckedListItemGeneratingProvider$SubParagraphGeneratingProvider;", "Lorg/intellij/markdown/html/InlineHolderGeneratingProvider;", "wrapInParagraph", "", "inputHtml", "", "(ZLjava/lang/String;)V", "getInputHtml", "()Ljava/lang/String;", "getWrapInParagraph", "()Z", "closeTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "openTag"}, moduleName="intellij-markdown")
    private static final class SubParagraphGeneratingProvider
    extends InlineHolderGeneratingProvider {
        private final boolean wrapInParagraph;
        @NotNull
        private final String inputHtml;

        @Override
        public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (this.wrapInParagraph) {
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "p", new CharSequence[0], false, 8);
            }
            visitor.consumeHtml(this.inputHtml);
        }

        @Override
        public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (this.wrapInParagraph) {
                visitor.consumeTagClose("p");
            }
        }

        public final boolean getWrapInParagraph() {
            return this.wrapInParagraph;
        }

        @NotNull
        public final String getInputHtml() {
            return this.inputHtml;
        }

        public SubParagraphGeneratingProvider(boolean wrapInParagraph, @NotNull String inputHtml) {
            Intrinsics.checkParameterIsNotNull((Object)inputHtml, (String)"inputHtml");
            this.wrapInParagraph = wrapInParagraph;
            this.inputHtml = inputHtml;
        }
    }
}

