/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"A\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\t\u0015\u0001Q!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001a\u0001!G\u0001\u0019\u0002\u0005V\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001TA)\u0004\u0003!\u0019Q\u0005\u0002\u0003\f\u0011\u0013i\u0011\u0001G\u0003&\u0011\u0011Q\u00012B\u0007\u00021\u0011I2\u0001\u0003\u0004\u000e\u0003a5Q\u0005\u0004\u0003\u000b\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!1Q\"\u0001M\u00073\rA\u0001\"D\u0001\u0019\u0004\u0015\"AA\u0003E\t\u001b\u0005A\u0012\"\n\u0003\u0005\u0017!MQ\"\u0001\r\u000bK!!1\u0002#\u0006\u000e\u0003a)\u0011d\u0001\u0005\u0007\u001b\u0005Aj!K\u0004\u0005\u0003rA9!D\u0001\u0019\tE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/impl/CodeBlockMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "marker", "Lorg/intellij/markdown/parser/ProductionHolder$Marker;", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder$Marker;)V", "realInterestingOffset", "", "allowsSubBlocks", "", "calcNextInterestingOffset", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset"}, moduleName="intellij-markdown")
public final class CodeBlockMarkerBlock
extends MarkerBlockImpl {
    private int realInterestingOffset;

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return true;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        LookaheadText.Position position;
        MarkdownConstraints nextConstraints;
        LookaheadText.Position nonemptyPos;
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
                if (pos.getOffset() < this.realInterestingOffset) {
                    return MarkerBlock.ProcessingResult.Companion.getCANCEL();
                }
                if (pos.getOffsetInCurrentLine() != -1) {
                    return MarkerBlock.ProcessingResult.Companion.getCANCEL();
                }
                PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
                LookaheadText.Position position2 = MarkdownParserUtil.INSTANCE.findNonEmptyLineWithSameConstraints(this.getConstraints(), pos);
                if (position2 == null) {
                    return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
                }
                nonemptyPos = position2;
                nextConstraints = MarkdownConstraints.Companion.fromBase(nonemptyPos, this.getConstraints());
                LookaheadText.Position shifted = nonemptyPos.nextPosition(1 + nextConstraints.getCharsEaten(nonemptyPos.getCurrentLine()));
                position = shifted;
                if (position == null) break block7;
                Integer n = shifted.charsToNonWhitespace();
                if ((position = position.nextPosition(n != null ? ((Number)n).intValue() : 0)) != null) break block8;
            }
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position nonWhitespace = position;
        if (!MarkdownParserUtil.INSTANCE.hasCodeBlockIndent(nonWhitespace, nextConstraints)) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        this.realInterestingOffset = nonemptyPos.getOffset();
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.Companion.getCODE_BLOCK();
    }

    public CodeBlockMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder.Marker marker) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        super(myConstraints, marker);
        this.realInterestingOffset = -1;
    }
}

