/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.PreconditionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001E\u0006\u000b\u0005!)!B\u0001\t\t\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001\u0001\u0004\u0001\u001a\u0003a\u0005\u0011uF\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\u0007!\u0011Q\"\u0001M\u0003\u00131A1!\u0004\u0006\n\u0005%\t\u0001\u0004B\u0005\u0003\u0013\u0005A\u001a!\u0003\u0002\n\u0003a%\u0001tA)\u0004\u0003!)Q\u0005\u0002\u0003\f\u0011\u001bi\u0011\u0001'\u0003&\u0011\u0011Q\u0001bB\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003a!Q\u0005\u0004\u0003\u000b\u0011#i\u0011\u0001G\u0005\u001a\u0007!AQ\"\u0001\r\u00053\rA\u0019\"D\u0001\u0019\u0004\u0015\"AA\u0003\u0005\u000b\u001b\u0005A*\"\n\u0003\u0005\u0017!YQ\"\u0001M\fK!!1\u0002\u0003\u0007\u000e\u0003a%\u0011d\u0001\u0005\t\u001b\u0005AB!K\n\u0005\u0007\"A1!\u0004\u0006\n\u0005%\t\u0001\u0004B\u0005\u0003\u0013\u0005A\u001a!\u0003\u0002\n\u0003a%\u0001tA)\u0004\t\u0015\u0001QB\u0001C\u0006\u0011\u0019\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/impl/ParagraphMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "marker", "Lorg/intellij/markdown/parser/ProductionHolder$Marker;", "interruptsParagraph", "Lkotlin/Function2;", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder$Marker;Lkotlin/jvm/functions/Function2;)V", "getInterruptsParagraph", "()Lkotlin/jvm/functions/Function2;", "allowsSubBlocks", "calcNextInterestingOffset", "", "pos", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset"}, moduleName="intellij-markdown")
public final class ParagraphMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final Function2<? super LookaheadText.Position, ? super MarkdownConstraints, ? extends Boolean> interruptsParagraph;

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return true;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
        if (MarkdownParserUtil.INSTANCE.calcNumberOfConsequentEols(pos, this.getConstraints()) >= 2) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(pos, this.getConstraints());
        if (!nextLineConstraints.upstreamWith(this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position posToCheck = pos.nextPosition(1 + nextLineConstraints.getCharsEaten(pos.getCurrentLine()));
        if (posToCheck == null || ((Boolean)this.interruptsParagraph.invoke((Object)posToCheck, (Object)nextLineConstraints)).booleanValue()) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.Companion.getPARAGRAPH();
    }

    @NotNull
    public final Function2<LookaheadText.Position, MarkdownConstraints, Boolean> getInterruptsParagraph() {
        return this.interruptsParagraph;
    }

    public ParagraphMarkerBlock(@NotNull MarkdownConstraints constraints, @NotNull ProductionHolder.Marker marker, @NotNull Function2<? super LookaheadText.Position, ? super MarkdownConstraints, ? extends Boolean> interruptsParagraph2) {
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        Intrinsics.checkParameterIsNotNull(interruptsParagraph2, (String)"interruptsParagraph");
        super(constraints, marker);
        this.interruptsParagraph = interruptsParagraph2;
    }
}

