/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IntRange;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.LinkParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u001f\u0015\tA\"A\u0003\u0002\u0011\u0011)\u0001\u0001\u0004\u0001\u0011\fe\t\u0001\u0014AO\u0001\f\u0005\u0016\u0011kA\u0001\t\u0003\u0015\u0012Ba\u0003E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001dA\r\n\u0011\u000fiq!C\u0003\n\t%\u0011\u0011\"\u0001\r\u00061\u0013AB\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/InlineLinkParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/Range;", "", "Companion"}, moduleName="intellij-markdown")
public final class InlineLinkParser
implements SequentialParser {
    public static final Companion Companion = org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser$Companion.INSTANCE;

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull Collection<? extends Range<Integer>> rangesToGlue) {
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResult result = new SequentialParser.ParsingResult();
        ArrayList<Integer> delegateIndices = new ArrayList<Integer>();
        List<Integer> indices = SequentialParserUtil.Companion.textRangesToIndices(rangesToGlue);
        TokensCache.Iterator iterator = tokens.new TokensCache.ListIterator(indices, 0);
        while (iterator.getType() != null) {
            ArrayList localDelegates;
            ArrayList resultNodes;
            TokensCache.Iterator afterLink;
            if (Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.Companion.getLBRACKET()) && (afterLink = Companion.parseInlineLink(resultNodes = new ArrayList(), localDelegates = new ArrayList(), iterator)) != null) {
                iterator = afterLink.advance();
                result = result.withNodes(resultNodes).withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges(localDelegates));
                continue;
            }
            delegateIndices.add(iterator.getIndex());
            iterator = iterator.advance();
        }
        return result.withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges((List<? extends Integer>)delegateIndices));
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011?)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0012E\u0003\u0002\u0011\u0011)\u0001\u0001Bb\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u00152\u00022A\u0007\u0003\u0019\u0003A\"!\u0007\u0004\t\u00065!\u0011BA\u0005\u00021\u000fA2!\u0007\u0004\t\t5!\u0011BA\u0005\u00021\u0015AJ!G\u0002\t\f5\t\u0001D\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/InlineLinkParser$Companion;", "", "()V", "parseInlineLink", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "result", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "delegateIndices", "", "", "iterator"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @Nullable
        public final TokensCache.Iterator parseInlineLink(@NotNull Collection<SequentialParser.Node> result, @NotNull List<Integer> delegateIndices, @NotNull TokensCache.Iterator iterator) {
            TokensCache.Iterator afterTitle;
            TokensCache.Iterator afterDestination;
            TokensCache.Iterator afterText;
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull(delegateIndices, (String)"delegateIndices");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            int startIndex = iterator.getIndex();
            TokensCache.Iterator it = iterator;
            TokensCache.Iterator iterator2 = LinkParserUtil.Companion.parseLinkText(result, delegateIndices, it);
            if (iterator2 == null) {
                return null;
            }
            it = afterText = iterator2;
            if (Intrinsics.areEqual((Object)it.rawLookup(1), (Object)MarkdownTokenTypes.Companion.getLPAREN()) ^ true) {
                return null;
            }
            if (Intrinsics.areEqual((Object)(it = it.advance().advance()).getType(), (Object)MarkdownTokenTypes.Companion.getEOL())) {
                it = it.advance();
            }
            if ((afterDestination = LinkParserUtil.Companion.parseLinkDestination(result, it)) != null && Intrinsics.areEqual((Object)(it = afterDestination.advance()).getType(), (Object)MarkdownTokenTypes.Companion.getEOL())) {
                it = it.advance();
            }
            if ((afterTitle = LinkParserUtil.Companion.parseLinkTitle(result, it)) != null && Intrinsics.areEqual((Object)(it = afterTitle.advance()).getType(), (Object)MarkdownTokenTypes.Companion.getEOL())) {
                it = it.advance();
            }
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.Companion.getRPAREN()) ^ true) {
                return null;
            }
            result.add(new SequentialParser.Node((Range<Integer>)((Range)new IntRange(startIndex, it.getIndex() + 1)), MarkdownElementTypes.Companion.getINLINE_LINK()));
            return it;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

