/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.profiling.ResolveProfiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReassignedLocalVarsChecker;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyTargetElementEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.impl.InferenceContext;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceResolveRunner;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrSuperReferenceResolver;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrThisReferenceResolver;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CompletionProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class GrReferenceExpressionImpl
extends GrReferenceElementImpl<GrExpression>
implements GrReferenceExpression {
    private static final Logger LOG = Logger.getInstance(GrReferenceExpressionImpl.class);
    private static final ResolveCache.PolyVariantResolver<GrReferenceExpressionImpl> POLY_RESOLVER = new ResolveCache.PolyVariantResolver<GrReferenceExpressionImpl>(){

        @NotNull
        public GroovyResolveResult[] resolve(final @NotNull GrReferenceExpressionImpl refExpr, final boolean incompleteCode) {
            if (refExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl$4", "resolve"));
            }
            GroovyResolveResult[] result = (GroovyResolveResult[])RecursionManager.doPreventingRecursion((Object)refExpr, (boolean)true, (Computable)new Computable<GroovyResolveResult[]>(){

                public GroovyResolveResult[] compute() {
                    return refExpr.doPolyResolve(incompleteCode, true);
                }
            });
            GroovyResolveResult[] groovyResolveResultArray = result == null ? GroovyResolveResult.EMPTY_ARRAY : result;
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl$4", "resolve"));
            }
            return groovyResolveResultArray;
        }
    };
    private static final OurTypesCalculator TYPES_CALCULATOR = new OurTypesCalculator();

    public GrReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "<init>"));
        }
        super(node);
    }

    private boolean findClassOrPackageAtFirst() {
        String name = this.getReferenceName();
        if (StringUtil.isEmpty((String)name) || this.hasAt()) {
            return false;
        }
        return Character.isUpperCase(name.charAt(0)) && !this.isMethodCallRef() || this.getParent() instanceof GrReferenceExpressionImpl && ((GrReferenceExpressionImpl)this.getParent()).findClassOrPackageAtFirst();
    }

    private boolean isMethodCallRef() {
        PsiElement parent = this.getParent();
        return parent instanceof GrMethodCall || parent instanceof GrReferenceExpressionImpl && ((GrReferenceExpressionImpl)parent).isMethodCallRef();
    }

    private boolean isDefinitelyKeyOfMap() {
        PsiElement resolved;
        GrExpression qualifier = ResolveUtil.getSelfOrWithQualifier(this);
        if (qualifier == null) {
            return false;
        }
        if (qualifier instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
            return false;
        }
        PsiType type = qualifier.getType();
        if (type == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
            return false;
        }
        String qname = TypesUtil.getQualifiedName(type);
        return !"groovy.util.ConfigObject".equals(qname);
    }

    @NotNull
    private GroovyResolveResult[] resolveTypeOrProperty() {
        if (this.isDefinitelyKeyOfMap()) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrProperty"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] results = this.resolveTypeOrPropertyInner();
        if (results.length == 0) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrProperty"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (!ResolveUtil.mayBeKeyOfMap(this)) {
            if (results == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrProperty"));
            }
            return results;
        }
        ArrayList<GroovyResolveResult> filtered = new ArrayList<GroovyResolveResult>();
        for (GroovyResolveResult result : results) {
            String name;
            PsiClass containingClass;
            PsiElement element = result.getElement();
            if (element instanceof PsiMember && (((PsiMember)element).hasModifierProperty("private") || (containingClass = ((PsiMember)element).getContainingClass()) != null && (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Map") || (name = containingClass.getQualifiedName()) != null && name.startsWith("java.") || containingClass.getLanguage() != GroovyLanguage.INSTANCE && !InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"groovy.lang.GroovyObject")))) continue;
            filtered.add(result);
        }
        GroovyResolveResult[] groovyResolveResultArray = (GroovyResolveResult[])ContainerUtil.toArray(filtered, (Object[])new GroovyResolveResult[filtered.size()]);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrProperty"));
        }
        return groovyResolveResultArray;
    }

    @NotNull
    private GroovyResolveResult[] resolveTypeOrPropertyInner() {
        GroovyResolveResult[] results;
        PsiElement nameElement = this.getReferenceNameElement();
        String name = this.getReferenceName();
        if (name == null || nameElement == null) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        IElementType nameType = nameElement.getNode().getElementType();
        if (nameType == GroovyTokenTypes.kTHIS) {
            results = GrThisReferenceResolver.resolveThisExpression(this);
            if (results != null) {
                if (results == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
                }
                return results;
            }
        } else if (nameType == GroovyTokenTypes.kSUPER && (results = GrSuperReferenceResolver.resolveSuperExpression(this)) != null) {
            if (results == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
            }
            return results;
        }
        EnumSet<ClassHint.ResolveKind> kinds = this.getParent() instanceof GrReferenceExpression ? ClassHint.RESOLVE_KINDS_CLASS_PACKAGE : ClassHint.RESOLVE_KINDS_CLASS;
        GroovyResolveResult[] classCandidates = null;
        GrReferenceResolveRunner resolveRunner = new GrReferenceResolveRunner(this);
        PropertyResolverProcessor processor = new PropertyResolverProcessor(name, this);
        resolveRunner.resolveImpl(processor);
        Object[] fieldCandidates = ((ResolverProcessor)processor).getCandidates();
        if (this.hasAt()) {
            if (fieldCandidates == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
            }
            return fieldCandidates;
        }
        boolean canBeClassOrPackage = ResolveUtil.canBeClassOrPackage(this);
        if (canBeClassOrPackage && this.findClassOrPackageAtFirst()) {
            PsiElement firstNonReferenceExprParent;
            GrReferenceExpressionImpl topRef;
            ClassResolverProcessor classProcessor = new ClassResolverProcessor(name, this, kinds);
            resolveRunner.resolveImpl(classProcessor);
            classCandidates = classProcessor.getCandidates();
            if (classCandidates.length > 0 && GrReferenceExpressionImpl.containsPackage(classCandidates) && (topRef = (GrReferenceExpressionImpl)PsiTreeUtil.findFirstParent((PsiElement)this, (Condition)new Condition<PsiElement>(firstNonReferenceExprParent = PsiTreeUtil.skipParentsOfType((PsiElement)this, (Class[])new Class[]{GrReferenceExpressionImpl.class})){
                final /* synthetic */ PsiElement val$firstNonReferenceExprParent;
                {
                    this.val$firstNonReferenceExprParent = psiElement;
                }

                public boolean value(PsiElement parent) {
                    return parent.getParent() == this.val$firstNonReferenceExprParent && parent instanceof GrReferenceExpressionImpl;
                }
            })) != null) {
                String string = topRef.getTextSkipWhiteSpaceAndComments();
                if (JavaPsiFacade.getInstance((Project)this.getProject()).findClass(string, this.getResolveScope()) != null) {
                    if (classCandidates == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
                    }
                    return classCandidates;
                }
            }
        }
        for (GroovyResolveResult groovyResolveResult : fieldCandidates) {
            PsiElement element = groovyResolveResult.getElement();
            if (element instanceof PsiField) {
                PsiClass containingClass = ((PsiField)element).getContainingClass();
                if (containingClass == null || PsiUtil.getContextClass(this) != containingClass) continue;
                if (fieldCandidates == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
                }
                return fieldCandidates;
            }
            if (element instanceof GrBindingVariable) continue;
            if (fieldCandidates == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
            }
            return fieldCandidates;
        }
        if (classCandidates != null && classCandidates.length > 0) {
            if (classCandidates == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
            }
            return classCandidates;
        }
        boolean isLValue = PsiUtil.isLValue(this);
        String[] accessorNames = isLValue ? GroovyPropertyUtils.suggestSettersName(name) : GroovyPropertyUtils.suggestGettersName(name);
        ArrayList accessorResults = new ArrayList();
        for (String accessorName : accessorNames) {
            AccessorResolverProcessor accessorResolver = new AccessorResolverProcessor(accessorName, name, this, !isLValue, false, PsiImplUtil.getQualifierType(this), this.getTypeArguments());
            resolveRunner.resolveImpl(accessorResolver);
            Object[] candidates = accessorResolver.getCandidates();
            if (candidates.length == 1 && candidates[0].isStaticsOK() && candidates[0].isAccessible()) {
                if (candidates == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
                }
                return candidates;
            }
            ContainerUtil.addAll(accessorResults, (Object[])candidates);
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])fieldCandidates);
        GrReferenceExpressionImpl.filterOutBindings(arrayList);
        if (!arrayList.isEmpty()) {
            GroovyResolveResult[] groovyResolveResultArray = arrayList.toArray(new GroovyResolveResult[arrayList.size()]);
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
            }
            return groovyResolveResultArray;
        }
        if (classCandidates == null && canBeClassOrPackage) {
            ClassResolverProcessor classProcessor = new ClassResolverProcessor(name, this, kinds);
            resolveRunner.resolveImpl(classProcessor);
            classCandidates = classProcessor.getCandidates();
        }
        if (classCandidates != null && classCandidates.length > 0) {
            if (classCandidates == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
            }
            return classCandidates;
        }
        if (!accessorResults.isEmpty()) {
            GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{(GroovyResolveResult)accessorResults.get(0)};
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
            }
            return groovyResolveResultArray;
        }
        if (GroovyResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveTypeOrPropertyInner"));
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static boolean containsPackage(@NotNull GroovyResolveResult[] candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "containsPackage"));
        }
        for (GroovyResolveResult candidate : candidates) {
            if (!(candidate.getElement() instanceof PsiPackage)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public GroovyResolveResult[] getCallVariants(@Nullable GrExpression upToArgument) {
        GroovyResolveResult[] groovyResolveResultArray = this.resolveMethodOrProperty(true, upToArgument, true);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getCallVariants"));
        }
        return groovyResolveResultArray;
    }

    private void processMethods(@NotNull MethodResolverProcessor methodResolver) {
        if (methodResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodResolver", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "processMethods"));
        }
        new GrReferenceResolveRunner(this).resolveImpl(methodResolver);
        if (methodResolver.hasApplicableCandidates()) {
            return;
        }
        if (!this.isQualified() && this.getContext() instanceof GrMethodCall) {
            ClosureMissingMethodContributor.processMethodsFromClosures(this, methodResolver);
        }
    }

    @NotNull
    private GroovyResolveResult[] resolveMethodOrProperty(boolean allVariants, @Nullable GrExpression upToArgument, boolean genericsMatter) {
        String name = this.getReferenceName();
        if (name == null) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GrReferenceResolveRunner resolveRunner = new GrReferenceResolveRunner(this);
        PropertyResolverProcessor propertyResolver = new PropertyResolverProcessor(name, this);
        resolveRunner.resolveImpl(propertyResolver);
        Object[] propertyCandidates = propertyResolver.getCandidates();
        if (!allVariants) {
            for (GroovyResolveResult groovyResolveResult : propertyCandidates) {
                PsiElement element = groovyResolveResult.getElement();
                if (!(element instanceof GrVariable) || element instanceof GrField || element instanceof GrBindingVariable) continue;
                if (propertyCandidates == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
                }
                return propertyCandidates;
            }
        }
        Pair<Boolean, GroovyResolveResult[]> shapeResults = this.resolveByShape(allVariants, upToArgument);
        if (!genericsMatter && !allVariants && ((Boolean)shapeResults.first).booleanValue()) {
            GrReferenceExpressionImpl.assertAllAreValid((GroovyResolveResult[])shapeResults.second);
            GroovyResolveResult[] groovyResolveResultArray = (GroovyResolveResult[])shapeResults.second;
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
            }
            return groovyResolveResultArray;
        }
        MethodResolverProcessor methodResolver = null;
        if (genericsMatter) {
            methodResolver = this.createMethodProcessor(allVariants, name, false, upToArgument);
            for (GroovyResolveResult result : (GroovyResolveResult[])shapeResults.second) {
                ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)result.getSubstitutor()).put(ClassHint.RESOLVE_CONTEXT, (Object)result.getCurrentFileResolveContext()).put(SpreadState.SPREAD_STATE, (Object)result.getSpreadState());
                PsiElement element = result.getElement();
                assert (element != null);
                methodResolver.execute(element, state);
            }
            if (!allVariants && methodResolver.hasApplicableCandidates()) {
                GroovyResolveResult[] groovyResolveResultArray = methodResolver.getCandidates();
                if (groovyResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
                }
                return groovyResolveResultArray;
            }
        }
        if (!allVariants) {
            for (Object candidate : propertyCandidates) {
                PsiClass containingClass;
                PsiElement element = candidate.getElement();
                if (!(element instanceof GrField) || (containingClass = ((PsiField)element).getContainingClass()) == null || !PsiTreeUtil.isContextAncestor((PsiElement)containingClass, (PsiElement)this, (boolean)true)) continue;
                if (propertyCandidates == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
                }
                return propertyCandidates;
            }
        }
        ArrayList<GroovyResolveResult> allCandidates = new ArrayList<GroovyResolveResult>();
        ContainerUtil.addAll(allCandidates, (Object[])propertyCandidates);
        ContainerUtil.addAll(allCandidates, (Object[])(genericsMatter ? methodResolver.getCandidates() : (GroovyResolveResult[])shapeResults.second));
        GrReferenceExpressionImpl.filterOutBindings(allCandidates);
        for (String getterName : GroovyPropertyUtils.suggestGettersName(name)) {
            AccessorResolverProcessor getterResolver = new AccessorResolverProcessor(getterName, name, this, true, genericsMatter, PsiImplUtil.getQualifierType(this), this.getTypeArguments());
            resolveRunner.resolveImpl(getterResolver);
            Object[] candidates = getterResolver.getCandidates();
            if (!allVariants && candidates.length == 1) {
                if (candidates == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
                }
                return candidates;
            }
            ContainerUtil.addAll(allCandidates, (Object[])candidates);
        }
        if (!allCandidates.isEmpty()) {
            GroovyResolveResult[] groovyResolveResultArray = allCandidates.toArray(new GroovyResolveResult[allCandidates.size()]);
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
            }
            return groovyResolveResultArray;
        }
        if (GroovyResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveMethodOrProperty"));
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static void filterOutBindings(@NotNull List<GroovyResolveResult> candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "filterOutBindings"));
        }
        boolean hasNonBinding = false;
        for (GroovyResolveResult candidate : candidates) {
            if (candidate.getElement() instanceof GrBindingVariable) continue;
            hasNonBinding = true;
        }
        if (hasNonBinding) {
            Iterator<GroovyResolveResult> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                GroovyResolveResult candidate;
                candidate = iterator.next();
                if (!(candidate.getElement() instanceof GrBindingVariable)) continue;
                iterator.remove();
            }
        }
    }

    @NotNull
    private Pair<Boolean, GroovyResolveResult[]> resolveByShape(boolean allVariants, @Nullable GrExpression upToArgument) {
        if (allVariants) {
            Pair<Boolean, GroovyResolveResult[]> pair = this.doResolveByShape(true, upToArgument);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveByShape"));
            }
            return pair;
        }
        LOG.assertTrue(upToArgument == null);
        Pair pair = (Pair)TypeInferenceHelper.getCurrentContext().getCachedValue(this, new NullableComputable<Pair<Boolean, GroovyResolveResult[]>>(){

            public Pair<Boolean, GroovyResolveResult[]> compute() {
                return GrReferenceExpressionImpl.this.doResolveByShape(false, null);
            }
        });
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "resolveByShape"));
        }
        return pair;
    }

    @NotNull
    private Pair<Boolean, GroovyResolveResult[]> doResolveByShape(boolean allVariants, @Nullable GrExpression upToArgument) {
        String name = this.getReferenceName();
        LOG.assertTrue(name != null);
        MethodResolverProcessor shapeProcessor = this.createMethodProcessor(allVariants, name, true, upToArgument);
        this.processMethods(shapeProcessor);
        GroovyResolveResult[] candidates = shapeProcessor.getCandidates();
        GrReferenceExpressionImpl.assertAllAreValid(candidates);
        if (this.hasMemberPointer()) {
            candidates = GrReferenceExpressionImpl.collapseReflectedMethods(candidates);
        }
        Pair pair = Pair.create((Object)shapeProcessor.hasApplicableCandidates(), (Object)candidates);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doResolveByShape"));
        }
        return pair;
    }

    @NotNull
    private static GroovyResolveResult[] collapseReflectedMethods(GroovyResolveResult[] candidates) {
        HashSet visited = ContainerUtil.newHashSet();
        ArrayList collapsed = ContainerUtil.newArrayList();
        for (GroovyResolveResult result : candidates) {
            PsiElement element = result.getElement();
            if (element instanceof GrReflectedMethod) {
                GrMethod baseMethod = ((GrReflectedMethod)element).getBaseMethod();
                if (!visited.add(baseMethod)) continue;
                collapsed.add(PsiImplUtil.reflectedToBase(result, baseMethod, (GrReflectedMethod)element));
                continue;
            }
            collapsed.add(result);
        }
        GroovyResolveResult[] groovyResolveResultArray = collapsed.toArray(new GroovyResolveResult[collapsed.size()]);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "collapseReflectedMethods"));
        }
        return groovyResolveResultArray;
    }

    private static void assertAllAreValid(@NotNull GroovyResolveResult[] candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "assertAllAreValid"));
        }
        for (GroovyResolveResult candidate : candidates) {
            PsiElement element = candidate.getElement();
            LOG.assertTrue(element == null || element.isValid());
        }
    }

    @NotNull
    private MethodResolverProcessor createMethodProcessor(boolean allVariants, @Nullable String name, boolean byShape, @Nullable GrExpression upToArgument) {
        PsiType[] argTypes = PsiUtil.getArgumentTypes(this, false, upToArgument, byShape);
        if (byShape && argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                argTypes[i] = TypeConversionUtil.erasure((PsiType)argTypes[i]);
            }
        }
        PsiType qualifierType = PsiImplUtil.getQualifierType(this);
        MethodResolverProcessor methodResolverProcessor = new MethodResolverProcessor(name, this, false, qualifierType, argTypes, this.getTypeArguments(), allVariants, byShape);
        if (methodResolverProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "createMethodProcessor"));
        }
        return methodResolverProcessor;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitReferenceExpression(this);
    }

    @Override
    @Nullable
    public PsiElement getReferenceNameElement() {
        ASTNode lastChild = this.getNode().getLastChildNode();
        if (lastChild == null) {
            return null;
        }
        if (TokenSets.REFERENCE_NAMES.contains(lastChild.getElementType())) {
            return lastChild.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference getReference() {
        GrReferenceExpressionImpl grReferenceExpressionImpl = this;
        if (grReferenceExpressionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getReference"));
        }
        return grReferenceExpressionImpl;
    }

    @Override
    @Nullable
    public GrExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    @Nullable
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            Object value;
            IElementType nodeType = nameElement.getNode().getElementType();
            if (TokenSets.STRING_LITERAL_SET.contains(nodeType) && (value = GrLiteralImpl.getLiteralValue(nameElement)) instanceof String) {
                return (String)value;
            }
            return nameElement.getText();
        }
        return null;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name;
        GroovyResolveResult result = this.advancedResolve();
        if (result.isInvokedOnProperty() && (name = GroovyPropertyUtils.getPropertyNameByAccessorName(newElementName)) != null) {
            newElementName = name;
        }
        if (PsiUtil.isThisOrSuperRef(this)) {
            return this;
        }
        return this.handleElementRenameSimple(newElementName);
    }

    protected GrReferenceExpression bindWithQualifiedRef(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "bindWithQualifiedRef"));
        }
        GrReferenceExpression qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceExpressionFromText(qName);
        GrTypeArgumentList list = this.getTypeArgumentList();
        if (list != null) {
            qualifiedRef.getNode().addChild(list.copy().getNode());
        }
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        return qualifiedRef;
    }

    @Override
    public boolean isFullyQualified() {
        if (this.getKind() == Kind.TYPE_OR_PROPERTY && this.resolve() instanceof PsiPackage) {
            return true;
        }
        GrExpression qualifier = this.getQualifier();
        if (!(qualifier instanceof GrReferenceExpressionImpl)) {
            return false;
        }
        return ((GrReferenceExpressionImpl)qualifier).isFullyQualified();
    }

    @Override
    public PsiElement handleElementRenameSimple(String newElementName) throws IncorrectOperationException {
        if (!PsiUtil.isValidReferenceName(newElementName)) {
            PsiElement old = this.getReferenceNameElement();
            if (old == null) {
                throw new IncorrectOperationException("ref has no name element");
            }
            PsiElement element = GroovyPsiElementFactory.getInstance(this.getProject()).createStringLiteralForReference(newElementName);
            old.replace(element);
            return this;
        }
        return super.handleElementRenameSimple(newElementName);
    }

    public String toString() {
        return "Reference expression";
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        GroovyResolveResult[] results = this.resolveByShape();
        return results.length == 1 ? results[0].getElement() : null;
    }

    @Override
    public GroovyResolveResult[] resolveByShape() {
        final InferenceContext context = TypeInferenceHelper.getCurrentContext();
        return context.getCachedValue(this, new Computable<GroovyResolveResult[]>(){

            public GroovyResolveResult[] compute() {
                Pair key = Pair.create((Object)GrReferenceExpressionImpl.this, (Object)context);
                GroovyResolveResult[] value = (GroovyResolveResult[])RecursionManager.doPreventingRecursion((Object)key, (boolean)true, (Computable)new Computable<GroovyResolveResult[]>(){

                    public GroovyResolveResult[] compute() {
                        return GrReferenceExpressionImpl.this.doPolyResolve(false, false);
                    }
                });
                return value == null ? GroovyResolveResult.EMPTY_ARRAY : value;
            }
        });
    }

    @Override
    @Nullable
    public PsiType getNominalType() {
        PsiType type;
        GroovyResolveResult resolveResult = this.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        for (GrReferenceTypeEnhancer enhancer : (GrReferenceTypeEnhancer[])GrReferenceTypeEnhancer.EP_NAME.getExtensions()) {
            PsiType type2 = enhancer.getReferenceType(this, resolved);
            if (type2 == null) continue;
            return type2;
        }
        IElementType dotType = this.getDotTokenType();
        if (dotType == GroovyTokenTypes.mMEMBER_POINTER) {
            return GrClosureType.create(this.multiResolve(false), this);
        }
        if (this.isDefinitelyKeyOfMap() && (type = GrReferenceExpressionImpl.getTypeFromMapAccess(this)) != null) {
            return type;
        }
        PsiType result = this.getNominalTypeInner(resolved);
        if (result == null) {
            return null;
        }
        result = TypesUtil.substituteAndNormalizeType(result, resolveResult.getSubstitutor(), resolveResult.getSpreadState(), this);
        return result;
    }

    @Nullable
    private PsiType getNominalTypeInner(@Nullable PsiElement resolved) {
        if (resolved == null && !"class".equals(this.getReferenceName())) {
            resolved = this.resolve();
        }
        if (resolved instanceof PsiClass) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            if (PsiUtil.isInstanceThisRef(this)) {
                PsiClassType categoryType = GdkMethodUtil.getCategoryType((PsiClass)resolved);
                if (categoryType != null) {
                    return categoryType;
                }
                return factory.createType((PsiClass)resolved);
            }
            if (PsiUtil.isSuperReference(this)) {
                PsiClass contextClass = PsiUtil.getContextClass(this);
                if (GrTraitUtil.isTrait(contextClass)) {
                    Object[] extendsTypes = contextClass.getExtendsListTypes();
                    Object[] implementsTypes = contextClass.getImplementsListTypes();
                    Object[] superTypes = (PsiClassType[])ArrayUtil.mergeArrays((Object[])implementsTypes, (Object[])extendsTypes, (ArrayFactory)PsiClassType.ARRAY_FACTORY);
                    return PsiIntersectionType.createIntersection((PsiType[])((PsiType[])ArrayUtil.reverseArray((Object[])superTypes)));
                }
                return factory.createType((PsiClass)resolved);
            }
            if (this.getParent() instanceof GrReferenceExpression) {
                return factory.createType((PsiClass)resolved);
            }
            return TypesUtil.createJavaLangClassType((PsiType)factory.createType((PsiClass)resolved), this.getProject(), this.getResolveScope());
        }
        if (resolved instanceof GrVariable) {
            return ((GrVariable)resolved).getDeclaredType();
        }
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (PropertyUtil.isSimplePropertySetter((PsiMethod)method) && !method.getName().equals(this.getReferenceName())) {
                return method.getParameterList().getParameters()[0].getType();
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && "getClass".equals(method.getName())) {
                return TypesUtil.createJavaLangClassType(PsiImplUtil.getQualifierType(this), this.getProject(), this.getResolveScope());
            }
            return PsiUtil.getSmartReturnType(method);
        }
        if (resolved == null) {
            PsiType fromClassRef = GrReferenceExpressionImpl.getTypeFromClassRef(this);
            if (fromClassRef != null) {
                return fromClassRef;
            }
            PsiType fromMapAccess = GrReferenceExpressionImpl.getTypeFromMapAccess(this);
            if (fromMapAccess != null) {
                return fromMapAccess;
            }
            PsiType fromSpreadOperator = GrReferenceExpressionImpl.getTypeFromSpreadOperator(this);
            if (fromSpreadOperator != null) {
                return fromSpreadOperator;
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromMapAccess(@NotNull GrReferenceExpressionImpl ref) {
        PsiType substituted;
        PsiSubstitutor substitutor;
        PsiClass mapClass;
        PsiClassType.ClassResolveResult qResult;
        PsiClass clazz;
        PsiType qType;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getTypeFromMapAccess"));
        }
        GrExpression qualifier = ref.getQualifierExpression();
        if (qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass) {
            return null;
        }
        if (qualifier != null && (qType = qualifier.getType()) instanceof PsiClassType && (clazz = (qResult = ((PsiClassType)qType).resolveGenerics()).getElement()) != null && (mapClass = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("java.util.Map", ref.getResolveScope())) != null && mapClass.getTypeParameters().length == 2 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)mapClass, (PsiClass)clazz, (PsiSubstitutor)qResult.getSubstitutor())) != null && (substituted = substitutor.substitute(mapClass.getTypeParameters()[1])) != null) {
            return PsiImplUtil.normalizeWildcardTypeByPosition(substituted, ref);
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromSpreadOperator(@NotNull GrReferenceExpressionImpl ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getTypeFromSpreadOperator"));
        }
        if (ref.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            return TypesUtil.createType("java.util.List", ref);
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeFromClassRef(@NotNull GrReferenceExpressionImpl ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getTypeFromClassRef"));
        }
        if ("class".equals(ref.getReferenceName())) {
            return TypesUtil.createJavaLangClassType(PsiImplUtil.getQualifierType(ref), ref.getProject(), ref.getResolveScope());
        }
        return null;
    }

    @Nullable
    private static PsiType getInferredTypes(@NotNull GrReferenceExpressionImpl refExpr, @Nullable PsiElement resolved) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getInferredTypes"));
        }
        GrExpression qualifier = refExpr.getQualifier();
        if (!(resolved instanceof PsiClass) && !(resolved instanceof PsiPackage)) {
            PsiType mapValueType;
            if (qualifier == null) {
                return TypeInferenceHelper.getCurrentContext().getVariableType(refExpr);
            }
            PsiType qType = qualifier.getType();
            if (qType instanceof PsiClassType && !(qType instanceof GrMapType) && (mapValueType = GrReferenceExpressionImpl.getTypeFromMapAccess(refExpr)) != null) {
                return mapValueType;
            }
        }
        return null;
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPES_CALCULATOR);
    }

    @Override
    public GrExpression replaceWithExpression(@NotNull GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        if (newExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpr", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "replaceWithExpression"));
        }
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private GroovyResolveResult[] doPolyResolve(boolean incompleteCode, boolean genericsMatter) {
        GroovyResolveResult[] groovyResolveResultArray;
        block20: {
            GroovyResolveResult[] processor;
            String name = this.getReferenceName();
            if (name == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            if (incompleteCode) {
                processor = CompletionProcessor.createRefSameNameProcessor(this, name);
                new GrReferenceResolveRunner(this).resolveImpl((ResolverProcessor)processor);
                GroovyResolveResult[] propertyCandidates = processor.getCandidates();
                if (propertyCandidates.length > 0 && !PsiUtil.isSingleBindingVariant(propertyCandidates)) {
                    if (propertyCandidates == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return propertyCandidates;
                }
            }
            ResolveProfiler.start();
            switch (this.getKind()) {
                case METHOD_OR_PROPERTY: {
                    processor = this.resolveMethodOrProperty(false, null, genericsMatter);
                    if (processor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return processor;
                }
                case TYPE_OR_PROPERTY: {
                    processor = this.resolveTypeOrProperty();
                    if (processor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return processor;
                }
                case METHOD_OR_PROPERTY_OR_TYPE: {
                    GroovyResolveResult[] results = this.resolveMethodOrProperty(false, null, genericsMatter);
                    if (results.length == 0) {
                        results = this.resolveTypeOrProperty();
                    }
                    if ((groovyResolveResultArray = results) == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
                    }
                    return groovyResolveResultArray;
                }
            }
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
            if (groovyResolveResultArray != null) break block20;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "doPolyResolve"));
        }
        return groovyResolveResultArray;
        finally {
            long time = ResolveProfiler.finish();
            ResolveProfiler.write((String)"ref", (PsiElement)this, (long)time);
        }
    }

    @NotNull
    private Kind getKind() {
        if (this.hasMemberPointer()) {
            Kind kind = Kind.METHOD_OR_PROPERTY;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getKind"));
            }
            return kind;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrMethodCallExpression || parent instanceof GrApplicationStatement) {
            Kind kind = Kind.METHOD_OR_PROPERTY_OR_TYPE;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getKind"));
            }
            return kind;
        }
        Kind kind = Kind.TYPE_OR_PROPERTY;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getKind"));
        }
        return kind;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean hasAt() {
        return this.findChildByType(GroovyTokenTypes.mAT) != null;
    }

    @Override
    public boolean hasMemberPointer() {
        return this.findChildByType(GroovyTokenTypes.mMEMBER_POINTER) != null;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiMethod[] superMethods;
        PsiElement baseTarget = this.resolve();
        if (this.getManager().areElementsEquivalent(element, baseTarget)) {
            return true;
        }
        PsiElement target = GroovyTargetElementEvaluator.correctSearchTargets(baseTarget);
        if (target != baseTarget && this.getManager().areElementsEquivalent(element, target)) {
            return true;
        }
        return element instanceof PsiMethod && target instanceof PsiMethod && Arrays.asList(superMethods = ((PsiMethod)target).findSuperMethods(false)).contains(element);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @Nullable
    public GrExpression getQualifierExpression() {
        return GrReferenceExpressionImpl.findExpressionChild(this);
    }

    @Override
    @Nullable
    public PsiElement getDotToken() {
        return this.findChildByType(TokenSets.DOTS);
    }

    @Override
    public void replaceDotToken(PsiElement newDot) {
        if (newDot == null) {
            return;
        }
        if (!TokenSets.DOTS.contains(newDot.getNode().getElementType())) {
            return;
        }
        PsiElement oldDot = this.getDotToken();
        if (oldDot == null) {
            return;
        }
        this.getNode().replaceChild(oldDot.getNode(), newDot.getNode());
    }

    @Override
    @Nullable
    public IElementType getDotTokenType() {
        PsiElement dot = this.getDotToken();
        return dot == null ? null : dot.getNode().getElementType();
    }

    @Override
    public GroovyResolveResult advancedResolve() {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, false, POLY_RESOLVER);
        return results.length == 1 ? results[0] : GroovyResolveResult.EMPTY_RESULT;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incomplete) {
        GroovyResolveResult[] results = TypeInferenceHelper.getCurrentContext().multiResolve(this, incomplete, POLY_RESOLVER);
        GroovyResolveResult[] groovyResolveResultArray = results.length == 0 ? GroovyResolveResult.EMPTY_ARRAY : results;
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getSameNameVariants() {
        GroovyResolveResult[] groovyResolveResultArray = this.doPolyResolve(true, true);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "getSameNameVariants"));
        }
        return groovyResolveResultArray;
    }

    @Override
    public GrReferenceExpression bindToElementViaStaticImport(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl", "bindToElementViaStaticImport"));
        }
        if (this.getQualifier() != null) {
            throw new IncorrectOperationException("Reference has qualifier");
        }
        if (StringUtil.isEmpty((String)this.getReferenceName())) {
            throw new IncorrectOperationException("Reference has empty name");
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException("Member has no containing class");
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFile) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            String text = "import static " + containingClass.getQualifiedName() + "." + member.getName();
            GrImportStatement statement = factory.createImportStatementFromText(text);
            ((GroovyFile)file).addImport(statement);
        }
        return this;
    }

    static enum Kind {
        TYPE_OR_PROPERTY,
        METHOD_OR_PROPERTY,
        METHOD_OR_PROPERTY_OR_TYPE;

    }

    private static final class OurTypesCalculator
    implements Function<GrReferenceExpressionImpl, PsiType> {
        private OurTypesCalculator() {
        }

        @Nullable
        public PsiType fun(GrReferenceExpressionImpl refExpr) {
            GroovyResolveResult resolveResult;
            PsiElement resolvedF;
            Object type;
            if (ResolveUtil.isClassReference(refExpr)) {
                GrExpression qualifier = refExpr.getQualifier();
                LOG.assertTrue(qualifier != null);
                return TypesUtil.createJavaLangClassType(qualifier.getType(), refExpr.getProject(), refExpr.getResolveScope());
            }
            if (PsiUtil.isCompileStatic(refExpr) && (type = (resolvedF = (resolveResult = refExpr.advancedResolve()).getElement()) instanceof GrField ? ((GrField)resolvedF).getType() : (resolvedF instanceof GrAccessorMethod ? ((GrAccessorMethod)resolvedF).getProperty().getType() : null)) != null) {
                return resolveResult.getSubstitutor().substitute(type);
            }
            PsiElement resolved = refExpr.resolve();
            PsiType nominal = refExpr.getNominalType();
            Boolean reassigned = GrReassignedLocalVarsChecker.isReassignedVar(refExpr);
            if (reassigned != null && reassigned.booleanValue()) {
                return GrReassignedLocalVarsChecker.getReassignedVarType(refExpr, true);
            }
            PsiType inferred = GrReferenceExpressionImpl.getInferredTypes(refExpr, resolved);
            if (inferred == null) {
                if (nominal == null && resolved instanceof GrVariable) {
                    LOG.assertTrue(resolved.isValid());
                    return ((GrVariable)resolved).getTypeGroovy();
                }
                return nominal;
            }
            if (nominal == null) {
                return inferred;
            }
            if (!TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)nominal), (PsiType)inferred, (boolean)false) && resolved instanceof GrVariable && ((GrVariable)resolved).getTypeElementGroovy() != null) {
                return nominal;
            }
            return inferred;
        }
    }
}

