/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.utils;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class ConditionalUtils {
    private ConditionalUtils() {
    }

    public static GrStatement stripBraces(GrStatement branch) {
        if (branch instanceof GrBlockStatement) {
            GrBlockStatement block = (GrBlockStatement)branch;
            GrOpenBlock codeBlock = block.getBlock();
            GrStatement[] statements = codeBlock.getStatements();
            if (statements.length == 1) {
                return statements[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean isReturn(GrStatement statement, @NonNls String value) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof GrReturnStatement)) {
            return false;
        }
        GrReturnStatement returnStatement = (GrReturnStatement)statement;
        GrExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null) {
            return false;
        }
        String returnValueText = returnValue.getText();
        return value.equals(returnValueText);
    }

    public static boolean isAssignment(GrStatement statement, @NonNls String value) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof GrExpression)) {
            return false;
        }
        GrExpression expression = (GrExpression)statement;
        if (!(expression instanceof GrAssignmentExpression)) {
            return false;
        }
        GrAssignmentExpression assignment = (GrAssignmentExpression)expression;
        GrExpression rhs = assignment.getRValue();
        if (rhs == null) {
            return false;
        }
        String rhsText = rhs.getText();
        return value.equals(rhsText);
    }

    public static boolean isAssignment(GrStatement statement) {
        return statement instanceof GrAssignmentExpression;
    }
}

