/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public abstract class GradleTestRunConfigurationProducer
extends RunConfigurationProducer<ExternalSystemRunConfiguration> {
    static final List<String> TEST_SOURCE_SET_TASKS = ContainerUtil.list((Object[])new String[]{"cleanTest", "test"});

    protected GradleTestRunConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == null || GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER;
    }

    public boolean shouldReplace(ConfigurationFromContext self, ConfigurationFromContext other) {
        return GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(ConfigurationContext context) {
        RunnerAndConfigurationSettings existingConfiguration = super.findExistingConfiguration(context);
        if (existingConfiguration == null && GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER) {
            ConfigurationFromContext createdContext = this.createConfigurationFromContext(context);
            if (createdContext != null) {
                RunnerAndConfigurationSettings settings = createdContext.getConfigurationSettings();
                RunManagerEx manager = RunManagerEx.getInstanceEx((Project)context.getProject());
                manager.setTemporaryConfiguration(settings);
                return settings;
            }
            return null;
        }
        return existingConfiguration;
    }

    protected boolean setupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        if (GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.PLATFORM_TEST_RUNNER) {
            return false;
        }
        return this.doSetupConfigurationFromContext(configuration, context, sourceElement);
    }

    protected abstract boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2, Ref<PsiElement> var3);

    public boolean isConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        if (GradleSystemRunningSettings.getInstance().getPreferredTestRunner() == GradleSystemRunningSettings.PreferredTestRunner.PLATFORM_TEST_RUNNER) {
            return false;
        }
        if (configuration == null) {
            return false;
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        return this.doIsConfigurationFromContext(configuration, context);
    }

    protected abstract boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2);
}

