/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.StringsKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0011\u0019)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\n\u0015\tAa\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\u0005\u0005\u0003!\u001dQ\"\u0001\r\u00053\rAI!D\u0001\u0019\t\u0015BA!\u0001\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u00014B\u0013\r\t\u0005Ai!D\u0001\u0019\u000fe\u0019\u0001rB\u0007\u00021!I2\u0001#\u0005\u000e\u0003aIQ\u0005\u0004\u0003\u0002\u0011'i\u0011\u0001G\u0004\u001a\u0007!QQ\"\u0001\r\u00053\rA)\"D\u0001\u0019\t\u0015Z\u0001bC\u0007\u00021\u001dI2\u0001c\u0004\u000e\u0003aA\u0011d\u0001E\t\u001b\u0005A\u0012\"J\u0002\t\u00185\t\u0001dB\u0013\u0007\t\u0005AA\"D\u0001\u0019\u0013U\t\u0001$C\u0015\b\t\u0005C\u00012A\u0007\u00021\t\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\u0003\u001b\u0005A2!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "", "()V", "isOnTeamcity", "", "totalTime", "Ljava/util/concurrent/atomic/AtomicLong;", "escape", "", "text", "escapedChar", "", "c", "printPerChunkStatistics", "", "moduleChunk", "Lorg/jetbrains/jps/ModuleChunk;", "timeToCompileNs", "", "printStatisticMessage", "key", "value", "registerStatistic", "reportTotal", "nanosToMillis"}, moduleName="jps-plugin")
public final class TeamcityStatisticsLogger {
    private final boolean isOnTeamcity = System.getenv("TEAMCITY_VERSION") != null;
    private final AtomicLong totalTime = new AtomicLong();

    private final char escapedChar(char c) {
        char c2;
        switch (c) {
            case '\n': {
                c2 = 110;
                break;
            }
            case '\r': {
                c2 = 114;
                break;
            }
            case '\u0085': {
                c2 = 120;
                break;
            }
            case '\u2028': {
                c2 = 108;
                break;
            }
            case '\u2029': {
                c2 = 112;
                break;
            }
            case '|': {
                c2 = 124;
                break;
            }
            case '\'': {
                c2 = 39;
                break;
            }
            case '[': {
                c2 = 91;
                break;
            }
            case ']': {
                c2 = 93;
                break;
            }
            default: {
                c2 = (char)0;
            }
        }
        return c2;
    }

    private final String escape(String text) {
        StringBuilder escaped = new StringBuilder();
        char[] cArray = StringsKt.toCharArray((String)text);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            char escChar = this.escapedChar(c);
            if (escChar == (char)0) {
                escaped.append(c);
                continue;
            }
            escaped.append('|').append(escChar);
        }
        String string = escaped.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"escaped.toString()");
        return string;
    }

    public final void registerStatistic(@NotNull ModuleChunk moduleChunk, long timeToCompileNs) {
        Intrinsics.checkParameterIsNotNull((Object)moduleChunk, (String)"moduleChunk");
        if (!this.isOnTeamcity) {
            return;
        }
        this.totalTime.addAndGet(timeToCompileNs);
        this.printPerChunkStatistics(moduleChunk, timeToCompileNs);
    }

    private final void printPerChunkStatistics(ModuleChunk moduleChunk, long timeToCompileNs) {
        this.printStatisticMessage(KotlinBuilder.Companion.getKOTLIN_BUILDER_NAME() + " for " + moduleChunk.getPresentableShortName() + " compilation time, ms", String.valueOf(this.nanosToMillis(timeToCompileNs)));
    }

    public final void reportTotal() {
        if (!this.isOnTeamcity) {
            return;
        }
        this.printStatisticMessage(KotlinBuilder.Companion.getKOTLIN_BUILDER_NAME() + " total compilation time, ms", String.valueOf(this.nanosToMillis(this.totalTime.get())));
    }

    private final void printStatisticMessage(String key, String value) {
        ConsoleKt.println((Object)("##teamcity[buildStatisticValue key='" + this.escape(key) + "' value='" + this.escape(value) + "']"));
    }

    private final long nanosToMillis(long $receiver) {
        return TimeUnit.NANOSECONDS.toMillis($receiver);
    }
}

