/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineHolderGeneratingProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0005\u00011\u0001\u0011$\u0001M\u0001;\u00031\u0011UA)\u0004\u0003!\tQE\u0005\u0003\f\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u000b!\u0015Qb\u0001\r\u0004S\u0005A:!G\u0002\t\t5\t\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001g\u0003"}, strings={"Lorg/intellij/markdown/html/ListItemGeneratingProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "SilentParagraphGeneratingProvider"}, moduleName="intellij-markdown")
public final class ListItemGeneratingProvider
extends SimpleTagProvider {
    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PreconditionsKt.assert((boolean)(node instanceof ListItemCompositeNode));
        this.openTag(visitor, text, node);
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.intellij.markdown.ast.impl.ListItemCompositeNode");
        }
        ListCompositeNode listCompositeNode = ((ListItemCompositeNode)aSTNode).getParent();
        if (listCompositeNode == null) {
            Intrinsics.throwNpe();
        }
        boolean isLoose = listCompositeNode.getLoose();
        for (ASTNode child : ((ListItemCompositeNode)node).getChildren()) {
            if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownElementTypes.Companion.getPARAGRAPH()) && !isLoose) {
                SilentParagraphGeneratingProvider.INSTANCE.processNode(visitor, text, child);
                continue;
            }
            child.accept(visitor);
        }
        this.closeTag(visitor, text, node);
    }

    public ListItemGeneratingProvider() {
        super("li");
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0005G\u0006a\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQE\u0005\u0003\f\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u000b!\u0015Qb\u0001\r\u0004S\u0005A:!G\u0002\t\t5\t\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001g\u0003&%\u0011Y\u0001BB\u0007\u00021\tIR\u0001#\u0002\u000e\u0007a\u0019\u0011&\u0001M\u00043\rAA!D\u0001\u0019\ne\u0019\u0001\"B\u0007\u00021\u0017\u0001"}, strings={"Lorg/intellij/markdown/html/ListItemGeneratingProvider$SilentParagraphGeneratingProvider;", "Lorg/intellij/markdown/html/InlineHolderGeneratingProvider;", "()V", "closeTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "openTag"}, moduleName="intellij-markdown")
    public static final class SilentParagraphGeneratingProvider
    extends InlineHolderGeneratingProvider {
        public static final SilentParagraphGeneratingProvider INSTANCE;
        public static final SilentParagraphGeneratingProvider INSTANCE$;

        @Override
        public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        }

        @Override
        public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        }

        static {
            new SilentParagraphGeneratingProvider();
        }

        private SilentParagraphGeneratingProvider() {
            INSTANCE = this;
            INSTANCE$ = this;
        }
    }
}

