/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"M\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!1Q!\u0001\u0003\u0002\u000b\u0005AY!\u0002\u0001\u0006\u0003!!Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u0019\u0001I\u0012\u0001'\u0001\"\"%\u0019\u0001\"A\u0007\u00021\u0007IQ\u0001\u0003\u0002\u000e\u0007a\u0015\u0011&\u0001\r\u0004\u0013\rA9!D\u0001\u0019\tE\u001b\u0011\u0001#\u0003&\t\u0011Y\u0001\"B\u0007\u00021\u0017)#\u0002\u0002\u0006\t\r5\t\u0001TB\r\u0006\u0011\u001di1\u0001g\u0004*\u0003aAQE\u0004\u0003\u000b\u0011#i\u0011\u0001G\u0005\u001a\u000b!9Qb\u0001M\bS\u0005A\u0002\"G\u0002\t\u00145\t\u00014A\u0013\u0005\t)A!\"D\u0001\u0019\u0016\u0015\"Aa\u0003\u0005\f\u001b\u0005A:\"\n\u0006\u0005\u0017!aQ\"\u0001M\u00063\u0015Aq!D\u0002\u0019\u0010%\n\u0001\u0004C\u0015\b\t\u0005C\u0001rA\u0007\u00021\u0011\t6!A\u0003\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/impl/ListMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "marker", "Lorg/intellij/markdown/parser/ProductionHolder$Marker;", "Lorg/intellij/markdown/parser/ProductionHolder;", "listType", "", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder$Marker;C)V", "allowsSubBlocks", "", "calcNextInterestingOffset", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset"}, moduleName="intellij-markdown")
public final class ListMarkerBlock
extends MarkerBlockImpl {
    private final char listType;

    @Override
    public boolean allowsSubBlocks() {
        return true;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getChar() == '\n';
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Integer n = pos.getNextLineOffset();
        return n != null ? ((Number)n).intValue() : -1;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
        int eolN = MarkdownParserUtil.INSTANCE.calcNumberOfConsequentEols(pos, this.getConstraints());
        if (eolN >= 3) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position position = MarkdownParserUtil.INSTANCE.getFirstNonWhitespaceLinePos(pos, eolN);
        if (position == null) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position nonemptyPos = position;
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(nonemptyPos, this.getConstraints());
        if (!nextLineConstraints.extendsList(this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        return MarkerBlock.ProcessingResult.Companion.getPASS();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.listType == '-' || this.listType == '*' || this.listType == '+' ? MarkdownElementTypes.Companion.getUNORDERED_LIST() : MarkdownElementTypes.Companion.getORDERED_LIST();
    }

    public ListMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder.Marker marker, char listType) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        super(myConstraints, marker);
        this.listType = listType;
    }
}

