/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IntRange;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!!Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t!\u0015\tAAA\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\b\u0006\u00031\tA\u0002A\r\u00021\u0003\t+!U\u0002\u0002\u0011\u0005)s\u0003B\u0001\t\u00045\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002\u001a\r!\u001dQ\u0002B\u0005\u0003\u0013\u0005A\"\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u00033\rAQ!D\u0001\u0019\u0005\u0015rA!\u0001E\u0006\u001b\u0005A\"!G\u0003\t\r5\u0019\u0001TB\u0015\u00021\rI2\u0001C\u0004\u000e\u0003a=QE\u0005\u0003\f\u0011!i\u0011\u0001'\u0005\u001a\u0007!\u0015Q\"\u0001\r\u00043%A\u0011\"D\u0004\n\u000b%!\u0011BA\u0005\u00021\tA\"\u0002g\u0005"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/impl/BacktickParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "findOfSize", "", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "indices", "", "from", "length", "getLength", "info", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "canEscape", "", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "rangesToGlue", "", "Lkotlin/Range;"}, moduleName="intellij-markdown")
public final class BacktickParser
implements SequentialParser {
    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull Collection<? extends Range<Integer>> rangesToGlue) {
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResult result = new SequentialParser.ParsingResult();
        List<Integer> indices = SequentialParserUtil.Companion.textRangesToIndices(rangesToGlue);
        ArrayList<Integer> delegateIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < indices.size()) {
            int j;
            TokensCache.ListIterator iterator = new TokensCache.ListIterator(tokens, indices, i);
            if ((Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.Companion.getBACKTICK()) || Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.Companion.getESCAPED_BACKTICKS())) && (j = this.findOfSize(tokens, indices, i + 1, this.getLength(iterator, true))) != -1) {
                result.withNode(new SequentialParser.Node((Range<Integer>)((Range)new IntRange(((Number)indices.get(i)).intValue(), ((Number)indices.get(j)).intValue() + 1)), MarkdownElementTypes.Companion.getCODE_SPAN()));
                i = j + 1;
                continue;
            }
            delegateIndices.add(indices.get(i));
            ++i;
        }
        return result.withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges((List<? extends Integer>)delegateIndices));
    }

    /*
     * WARNING - void declaration
     */
    private final int findOfSize(TokensCache tokens, List<? extends Integer> indices, int from, int length) {
        int n = from;
        int n2 = indices.size() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                TokensCache.ListIterator iterator;
                if (!(Intrinsics.areEqual((Object)(iterator = new TokensCache.ListIterator(tokens, indices, (int)i)).getType(), (Object)MarkdownTokenTypes.Companion.getBACKTICK()) ^ true && Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.Companion.getESCAPED_BACKTICKS()) ^ true || this.getLength(iterator, false) != length)) {
                    return (int)i;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return -1;
    }

    private final int getLength(TokensCache.Iterator info, boolean canEscape) {
        String tokenText = info.getText();
        int toSubtract = 0;
        if (Intrinsics.areEqual((Object)info.getType(), (Object)MarkdownTokenTypes.Companion.getESCAPED_BACKTICKS())) {
            toSubtract = canEscape ? 2 : 1;
        }
        return tokenText.length() - toSubtract;
    }
}

