/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0005a\u0011!B\u0001\r\u00031\u0001\u0011$\u0001M\u0001C3IA\u0001C\u0001\u000e\u00051\u0005\u00014A\u0005\u0005\u0011\ti!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001#\u0002&\u001d\u0011Y\u0001bA\u0007\u00021\u000fI2\u0001\u0003\u0003\u000e\u0003a%\u0011$\u0002\u0005\u0006\u001b\rI\u0011\u0001b\u0001\u0019\f\u0015RA!\u0001\u0005\u0007\u001b\ta\t\u0001'\u0004\u001a\t!9QB\u0001G\u00011\u001b)c\u0002B\u0006\t\u00105\t\u0001\u0004C\r\u0004\u0011\u0011i\u0011\u0001'\u0005\u001a\u000b!)QbA\u0005\u0002\t\u0007AZ!\n\b\u0005\u0017!=Q\"\u0001\r\t3\rAA!D\u0001\u0019\u0013e)\u0001\"B\u0007\u0004\u0013\u0005!\u0019\u0001g\u0003*\u0011\u0011\t\u0005\u0002\u0003\u0002\u000e\u00051\u0005\u00014A)\u0004\u0003\u0015\u0001\u0011\u0006\u0003\u0003B\u0011!\tQB\u0001G\u00011\u0007\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/ReturnReplacingVisitor;", "Lcom/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl;", "resultRef", "Lcom/google/dart/compiler/backend/js/ast/JsNameRef;", "breakLabel", "(Lcom/google/dart/compiler/backend/js/ast/JsNameRef;Lcom/google/dart/compiler/backend/js/ast/JsNameRef;)V", "endVisit", "", "x", "Lcom/google/dart/compiler/backend/js/ast/JsReturn;", "ctx", "Lcom/google/dart/compiler/backend/js/ast/JsContext;", "getReturnReplacement", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "returnExpression", "visit", "", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "Lcom/google/dart/compiler/backend/js/ast/JsObjectLiteral;"}, moduleName="kotlin-compiler")
public final class ReturnReplacingVisitor
extends JsVisitorWithContextImpl {
    private final JsNameRef resultRef;
    private final JsNameRef breakLabel;

    public boolean visit(@NotNull JsObjectLiteral x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        return false;
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        return false;
    }

    public void endVisit(@NotNull JsReturn x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        ctx.removeMe();
        JsExpression returnReplacement = this.getReturnReplacement(x.getExpression());
        if (returnReplacement != null) {
            ctx.addNext((JsNode)new JsExpressionStatement(returnReplacement));
        }
        if (this.breakLabel != null) {
            ctx.addNext((JsNode)new JsBreak(this.breakLabel));
        }
    }

    private final JsExpression getReturnReplacement(JsExpression returnExpression) {
        if (returnExpression != null) {
            if (this.resultRef != null) {
                return JsAstUtils.assignment(this.resultRef, returnExpression);
            }
            if (SideEffectUtilsKt.canHaveSideEffect(returnExpression)) {
                return returnExpression;
            }
        }
        return null;
    }

    public ReturnReplacingVisitor(@Nullable JsNameRef resultRef, @Nullable JsNameRef breakLabel) {
        this.resultRef = resultRef;
        this.breakLabel = breakLabel;
    }
}

