/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.repository.metadata.DefaultRepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;

@Component(role=RepositoryMetadataManager.class, hint="ide")
public class CustomMaven3RepositoryMetadataManager
extends DefaultRepositoryMetadataManager {
    private MavenWorkspaceMap myWorkspaceMap;

    public void customize(MavenWorkspaceMap workspaceMap) {
        this.myWorkspaceMap = workspaceMap;
    }

    public void reset() {
        this.myWorkspaceMap = null;
    }

    public void resolve(RepositoryMetadata metadata, RepositoryRequest request) throws RepositoryMetadataResolutionException {
        super.resolve(metadata, request);
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return;
        }
        Metadata data = metadata.getMetadata();
        Versioning versioning = data.getVersioning();
        if (versioning == null) {
            versioning = new Versioning();
            data.setVersioning(versioning);
        }
        for (MavenId each : map.getAvailableIds()) {
            if (!each.equals(data.getGroupId(), data.getArtifactId())) continue;
            versioning.addVersion(each.getVersion());
        }
    }
}

