/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelNodeInternal;

abstract class ModelBinding {
    final BindingPredicate predicate;
    final ModelRuleDescriptor referrer;
    final boolean writable;
    protected ModelNodeInternal boundTo;

    protected ModelBinding(ModelRuleDescriptor referrer, BindingPredicate predicate, boolean writable) {
        this.predicate = predicate;
        this.referrer = referrer;
        this.writable = writable;
    }

    public BindingPredicate getPredicate() {
        return this.predicate;
    }

    public boolean isBound() {
        return this.boundTo != null;
    }

    public ModelNodeInternal getNode() {
        if (this.boundTo == null) {
            throw new IllegalStateException("Target node has not been bound.");
        }
        return this.boundTo;
    }

    boolean isTypeCompatible(ModelPromise promise) {
        return promise.canBeViewedAsWritable(this.predicate.getType()) || promise.canBeViewedAsReadOnly(this.predicate.getType());
    }

    public String toString() {
        return "ModelBinding{predicate=" + this.predicate + ", node=" + this.boundTo + '}';
    }

    public abstract void onCreate(ModelNodeInternal var1);

    public void onRemove(ModelNodeInternal node) {
        if (node == this.boundTo) {
            this.boundTo = null;
        }
    }
}

