/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.binding.BindControl;
import com.intellij.openapi.options.binding.ControlBinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.actions.AnalyzeTaskStacktraceAction;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.impl.TaskStateCombo;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenTaskDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.actions.SimpleOpenTaskDialog");
    private static final String START_FROM_BRANCH = "start.from.branch";
    private static final String UPDATE_STATE_ENABLED = "tasks.open.task.update.state.enabled";
    private JPanel myPanel;
    @BindControl(value="clearContext", instant=true)
    private JCheckBox myClearContext;
    private JLabel myTaskNameLabel;
    private JPanel myVcsPanel;
    private JTextField myBranchName;
    private JTextField myChangelistName;
    private JBCheckBox myCreateBranch;
    private JBCheckBox myCreateChangelist;
    private JBCheckBox myUpdateState;
    private JBLabel myFromLabel;
    private ComboBox myBranchFrom;
    private TaskStateCombo myTaskStateCombo;
    private final Project myProject;
    private final Task myTask;
    private VcsTaskHandler myVcsTaskHandler;

    public OpenTaskDialog(final @NotNull Project project, @NotNull Task task) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/actions/OpenTaskDialog", "<init>"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/actions/OpenTaskDialog", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        this.myTask = task;
        this.$$$setupUI$$$();
        TaskManagerImpl taskManager = (TaskManagerImpl)TaskManager.getManager((Project)this.myProject);
        this.setTitle("Open Task");
        this.myTaskNameLabel.setText(TaskUtil.getTrimmedSummary(task));
        this.myTaskNameLabel.setIcon(task.getIcon());
        TaskManagerImpl manager = (TaskManagerImpl)TaskManager.getManager((Project)project);
        ControlBinder binder = new ControlBinder((Object)manager.getState());
        binder.bindAnnotations((Object)this);
        binder.reset();
        if (!TaskStateCombo.stateUpdatesSupportedFor(task)) {
            this.myUpdateState.setVisible(false);
            this.myTaskStateCombo.setVisible(false);
        }
        boolean stateUpdatesEnabled = PropertiesComponent.getInstance((Project)project).getBoolean(UPDATE_STATE_ENABLED, true);
        this.myUpdateState.setSelected(stateUpdatesEnabled);
        this.myUpdateState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = OpenTaskDialog.this.myUpdateState.isSelected();
                PropertiesComponent.getInstance((Project)project).setValue(OpenTaskDialog.UPDATE_STATE_ENABLED, String.valueOf(selected));
                OpenTaskDialog.this.updateFields(false);
                if (selected) {
                    OpenTaskDialog.this.myTaskStateCombo.scheduleUpdateOnce();
                }
            }
        });
        TaskManagerImpl.Config state = taskManager.getState();
        this.myClearContext.setSelected(state.clearContext);
        AbstractVcs vcs = manager.getActiveVcs();
        if (vcs == null) {
            this.myVcsPanel.setVisible(false);
        } else {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenTaskDialog.this.updateFields(false);
                }
            };
            this.myCreateChangelist.addActionListener(listener);
            this.myCreateBranch.addActionListener(listener);
            this.myCreateChangelist.setSelected(manager.getState().createChangelist);
            VcsTaskHandler[] handlers = VcsTaskHandler.getAllHandlers((Project)project);
            if (handlers.length == 0) {
                this.myCreateBranch.setSelected(false);
                this.myCreateBranch.setVisible(false);
                this.myBranchName.setVisible(false);
                this.myFromLabel.setVisible(false);
                this.myBranchFrom.setVisible(false);
            } else {
                for (VcsTaskHandler handler : handlers) {
                    Object[] tasks = handler.getAllExistingTasks();
                    if (tasks.length <= 0) continue;
                    this.myVcsTaskHandler = handler;
                    this.myBranchFrom.setModel(new DefaultComboBoxModel<VcsTaskHandler.TaskInfo>(tasks));
                    this.myBranchFrom.setEnabled(true);
                    final String startFrom = PropertiesComponent.getInstance((Project)project).getValue(START_FROM_BRANCH);
                    VcsTaskHandler.TaskInfo info = null;
                    if (startFrom != null) {
                        info = (VcsTaskHandler.TaskInfo)ContainerUtil.find((Object[])tasks, (Condition)new Condition<VcsTaskHandler.TaskInfo>(){

                            public boolean value(VcsTaskHandler.TaskInfo taskInfo) {
                                return startFrom.equals(taskInfo.getName());
                            }
                        });
                    }
                    if (info == null) {
                        VcsTaskHandler.TaskInfo[] current = handler.getCurrentTasks();
                        info = current.length > 0 ? current[0] : tasks[0];
                    }
                    this.myBranchFrom.setSelectedItem(info);
                    this.myBranchFrom.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            VcsTaskHandler.TaskInfo item = (VcsTaskHandler.TaskInfo)OpenTaskDialog.this.myBranchFrom.getSelectedItem();
                            if (item != null) {
                                PropertiesComponent.getInstance((Project)project).setValue(OpenTaskDialog.START_FROM_BRANCH, item.getName());
                            }
                        }
                    });
                    break;
                }
                this.myCreateBranch.setSelected(manager.getState().createBranch && this.myBranchFrom.getItemCount() > 0);
                this.myBranchFrom.setRenderer((ListCellRenderer)new ColoredListCellRenderer<VcsTaskHandler.TaskInfo>(){

                    protected void customizeCellRenderer(JList list, VcsTaskHandler.TaskInfo value, int index, boolean selected, boolean hasFocus) {
                        if (value != null) {
                            this.append(value.getName());
                        }
                    }
                });
            }
            this.myBranchName.setText(taskManager.suggestBranchName(task));
            this.myChangelistName.setText(taskManager.getChangelistName(task));
        }
        this.updateFields(true);
        this.myTaskStateCombo.registerUpDownAction(this.myBranchName);
        this.myTaskStateCombo.registerUpDownAction(this.myChangelistName);
        if (this.myUpdateState.isSelected()) {
            this.myTaskStateCombo.scheduleUpdateOnce();
        }
        this.init();
    }

    private void updateFields(boolean initial) {
        if (!initial && this.myBranchFrom.getItemCount() == 0 && this.myCreateBranch.isSelected()) {
            Messages.showWarningDialog((Component)this.myPanel, (String)"Can't create branch if no commit exists.\nCreate a commit first.", (String)"Cannot Create Branch");
            this.myCreateBranch.setSelected(false);
        }
        this.myBranchName.setEnabled(this.myCreateBranch.isSelected());
        this.myFromLabel.setEnabled(this.myCreateBranch.isSelected());
        this.myBranchFrom.setEnabled(this.myCreateBranch.isSelected());
        this.myChangelistName.setEnabled(this.myCreateChangelist.isSelected());
        this.myTaskStateCombo.setEnabled(this.myUpdateState.isSelected());
    }

    protected void doOKAction() {
        this.createTask();
        super.doOKAction();
    }

    public void createTask() {
        final TaskManagerImpl taskManager = (TaskManagerImpl)TaskManager.getManager((Project)this.myProject);
        taskManager.getState().createChangelist = this.myCreateChangelist.isSelected();
        taskManager.getState().createBranch = this.myCreateBranch.isSelected();
        if (this.myUpdateState.isSelected()) {
            CustomTaskState taskState = this.myTaskStateCombo.getSelectedState();
            TaskRepository repository = this.myTask.getRepository();
            if (repository != null && taskState != null) {
                try {
                    repository.setTaskState(this.myTask, taskState);
                    repository.setPreferredOpenTaskState(taskState);
                }
                catch (Exception ex) {
                    Messages.showErrorDialog((Project)this.myProject, (String)ex.getMessage(), (String)"Cannot Set State For Issue");
                    LOG.warn((Throwable)ex);
                }
            }
        }
        final LocalTask activeTask = taskManager.getActiveTask();
        final LocalTask localTask = taskManager.activateTask(this.myTask, this.isClearContext());
        if (this.myCreateChangelist.isSelected()) {
            taskManager.createChangeList(localTask, this.myChangelistName.getText());
        }
        if (this.myCreateBranch.isSelected()) {
            VcsTaskHandler.TaskInfo item = (VcsTaskHandler.TaskInfo)this.myBranchFrom.getSelectedItem();
            Runnable createBranch = new Runnable(){

                @Override
                public void run() {
                    taskManager.createBranch(localTask, activeTask, OpenTaskDialog.this.myBranchName.getText());
                }
            };
            if (item != null) {
                this.myVcsTaskHandler.switchToTask(item, createBranch);
            } else {
                createBranch.run();
            }
        }
        if (this.myTask.getType() == TaskType.EXCEPTION && AnalyzeTaskStacktraceAction.hasTexts(this.myTask)) {
            AnalyzeTaskStacktraceAction.analyzeStacktrace(this.myTask, this.myProject);
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myCreateBranch.isSelected()) {
            String branchName = this.myBranchName.getText().trim();
            if (branchName.isEmpty()) {
                return new ValidationInfo("Branch name should not be empty", (JComponent)this.myBranchName);
            }
            if (branchName.contains(" ")) {
                return new ValidationInfo("Branch name should not contain spaces");
            }
            return null;
        }
        if (this.myCreateChangelist.isSelected() && this.myChangelistName.getText().trim().isEmpty()) {
            return new ValidationInfo("Changelist name should not be empty");
        }
        return null;
    }

    private boolean isClearContext() {
        return this.myClearContext.isSelected();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "SimpleOpenTaskDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myCreateBranch.isSelected()) {
            return this.myBranchName;
        }
        if (this.myCreateChangelist.isSelected()) {
            return this.myChangelistName;
        }
        if (this.myTaskStateCombo.isVisible() && this.myTaskStateCombo.isEnabled()) {
            return this.myTaskStateCombo.getComboBox();
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myTaskStateCombo = new TaskStateCombo(this.myProject, this.myTask){

            @Override
            @Nullable
            protected CustomTaskState getPreferredState(@NotNull TaskRepository repository, @NotNull Collection<CustomTaskState> available) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/actions/OpenTaskDialog$7", "getPreferredState"));
                }
                if (available == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "available", "com/intellij/tasks/actions/OpenTaskDialog$7", "getPreferredState"));
                }
                return repository.getPreferredOpenTaskState();
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        ComboBox comboBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myClearContext = jCheckBox = new JCheckBox();
        jCheckBox.setText("Clear current context");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jCheckBox.setFocusable(false);
        jCheckBox.setSelected(true);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Open task:");
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTaskNameLabel = jLabel = new JLabel();
        jLabel.setText("Task description");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVcsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"VCS operations", (int)0, (int)0, null, null));
        this.myBranchName = jTextField2 = new JTextField();
        ((Component)jTextField2).setEnabled(false);
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myChangelistName = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCreateBranch = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Create branch");
        jBCheckBox3.setMnemonic('B');
        jBCheckBox3.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCreateChangelist = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Create changelist");
        jBCheckBox2.setMnemonic('L');
        jBCheckBox2.setDisplayedMnemonicIndex(13);
        jPanel.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myBranchFrom = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel.add((Component)comboBox, new GridConstraints(0, 3, 1, 1, 0, 0, 2, 0, null, null, null));
        this.myFromLabel = jBLabel = new JBLabel();
        jBLabel.setText("from");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        TaskStateCombo taskStateCombo = this.myTaskStateCombo;
        jPanel5.add((Component)taskStateCombo, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myUpdateState = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Update issue state");
        jBCheckBox.setMnemonic('U');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

