/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.binary;

import com.android.tools.rpclib.binary.BinaryObject;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Encoder {
    @NotNull
    private final OutputStream mOutputStream;
    @NotNull
    private final TObjectIntHashMap<BinaryObject> mEncodedMap;
    @NotNull
    private final byte[] mBuffer;

    public Encoder(@NotNull OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/android/tools/rpclib/binary/Encoder", "<init>"));
        }
        this.mEncodedMap = new TObjectIntHashMap();
        this.mOutputStream = out;
        this.mBuffer = new byte[9];
    }

    public void bool(boolean v) throws IOException {
        this.mBuffer[0] = (byte)(v ? 1 : 0);
        this.mOutputStream.write(this.mBuffer, 0, 1);
    }

    public void int8(byte v) throws IOException {
        this.mBuffer[0] = v;
        this.mOutputStream.write(this.mBuffer, 0, 1);
    }

    public void uint8(short v) throws IOException {
        this.mBuffer[0] = (byte)(v & 0xFF);
        this.mOutputStream.write(this.mBuffer, 0, 1);
    }

    private void intv(long v) throws IOException {
        long uv = v << 1;
        if (v < 0L) {
            uv ^= 0xFFFFFFFFFFFFFFFFL;
        }
        this.uintv(uv);
    }

    private void uintv(long v) throws IOException {
        long space = -128L;
        int tag = 0;
        int o = 8;
        while (true) {
            if ((v & space) == 0L) {
                this.mBuffer[o] = (byte)(v | (long)tag);
                this.mOutputStream.write(this.mBuffer, o, 9 - o);
                return;
            }
            this.mBuffer[o] = (byte)(v & 0xFFL);
            v >>>= 8;
            space >>= 1;
            tag = tag >> 1 | 0x80;
            --o;
        }
    }

    public void int16(short v) throws IOException {
        this.intv(v);
    }

    public void uint16(int v) throws IOException {
        this.uintv(v);
    }

    public void int32(int v) throws IOException {
        this.intv(v);
    }

    public void uint32(long v) throws IOException {
        this.uintv(v);
    }

    public void int64(long v) throws IOException {
        this.intv(v);
    }

    public void uint64(long v) throws IOException {
        this.uintv(v);
    }

    public void float32(float v) throws IOException {
        int bits = Float.floatToIntBits(v);
        int shuffled = (bits & 0xFF) << 24 | (bits & 0xFF00) << 8 | (bits & 0xFF0000) >> 8 | (bits & 0xFF000000) >>> 24;
        this.uintv(shuffled);
    }

    public void float64(double v) throws IOException {
        long bits = Double.doubleToLongBits(v);
        long shuffled = (bits & 0xFFL) << 56 | (bits & 0xFF00L) << 40 | (bits & 0xFF0000L) << 24 | (bits & 0xFF000000L) << 8 | (bits & 0xFF00000000L) >> 8 | (bits & 0xFF0000000000L) >> 24 | (bits & 0xFF000000000000L) >> 40 | (bits & 0xFF00000000000000L) >>> 56;
        this.uintv(shuffled);
    }

    public void string(@Nullable String v) throws IOException {
        try {
            if (v == null) {
                this.uint32(0L);
                return;
            }
            byte[] bytes = v.getBytes("UTF-8");
            this.uint32(bytes.length);
            for (byte b : bytes) {
                this.int8(b);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void object(@Nullable BinaryObject obj) throws IOException {
        if (obj == null) {
            this.uint32(0L);
            return;
        }
        if (this.mEncodedMap.containsKey((Object)obj)) {
            int key = this.mEncodedMap.get((Object)obj);
            this.uint16(key);
            return;
        }
        int key = this.mEncodedMap.size() + 1;
        this.mEncodedMap.put((Object)obj, key);
        this.uint32(key);
        obj.type().encode(this);
        obj.encode(this);
    }

    public OutputStream stream() {
        return this.mOutputStream;
    }
}

