/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jgit.dirCache;

import java.text.MessageFormat;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.eclipse.jgit.dircache.BaseDirCacheEditor;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jgit.dirCache.AddFile;
import org.jetbrains.jgit.dirCache.AddLoadedFile;
import org.jetbrains.jgit.dirCache.DeleteDirectory;
import org.jetbrains.jgit.dirCache.DeleteFile;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.jgit.dirCache.PathEdit;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t!\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0011)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011\u0017)\u0001\u0001\u0004\u0001\u001a\u0003a\u0005\u00115F\u0005\u0007\u0011\u0005iA!\u0003\u0002\n\u0003a\u0011\u00014A\u0005\u0004\u0011\u000bi\u0011\u0001G\u0002\n\u0007!\u001dQ\"\u0001\r\u0005\u0013\rAI!D\u0001\u0019\u000bE\u001b\u0011\u0001c\u0003&\t\u0011\t\u0001BB\u0007\u00021\u001b)C\u0001B\u0006\t\u000f5\t\u0001tB\u0013\u0005\t-A\u0001\"D\u0001\u0019\u000e%RA!\u0011\u0005\t\u00035!\u0011BA\u0005\u00021\tA\u001a!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u000bi\u0011\u0001G\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/jgit/dirCache/DirCacheEditor;", "Lorg/eclipse/jgit/dircache/BaseDirCacheEditor;", "edits", "", "Lorg/jetbrains/jgit/dirCache/PathEdit;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "dirCache", "Lorg/eclipse/jgit/dircache/DirCache;", "estimatedNumberOfEntries", "", "(Ljava/util/List;Lorg/eclipse/jgit/lib/Repository;Lorg/eclipse/jgit/dircache/DirCache;I)V", "applyEdits", "", "commit", "", "finish"}, moduleName="settings-repository")
public final class DirCacheEditor
extends BaseDirCacheEditor {
    private final List<? extends PathEdit> edits;
    private final Repository repository;

    public boolean commit() {
        if (this.edits.isEmpty()) {
            this.cache.unlock();
            return true;
        }
        return super.commit();
    }

    public void finish() {
        if (!this.edits.isEmpty()) {
            this.applyEdits();
            this.replace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyEdits() {
        int maxIndex = this.cache.getEntryCount();
        int lastIndex = 0;
        block0: for (PathEdit pathEdit : this.edits) {
            int count;
            boolean missing;
            void $receiver;
            byte[] byArray = pathEdit.getPath();
            byte[] byArray2 = pathEdit.getPath();
            DirCache dirCache = this.cache;
            int n = ((void)$receiver).length;
            int entryIndex = dirCache.findEntry(byArray2, n);
            boolean bl = missing = entryIndex < 0;
            if (entryIndex < 0) {
                entryIndex = -(entryIndex + 1);
            }
            if ((count = Math.min(entryIndex, maxIndex) - lastIndex) > 0) {
                this.fastKeep(lastIndex, count);
            }
            int n2 = lastIndex = missing ? entryIndex : this.cache.nextEntry(entryIndex);
            if (pathEdit instanceof DeleteFile) continue;
            if (pathEdit instanceof DeleteDirectory) {
                void $receiver2;
                byte[] byArray3 = ((DeleteDirectory)pathEdit).getPath();
                byArray2 = ((DeleteDirectory)pathEdit).getPath();
                dirCache = this.cache;
                n = ((void)$receiver2).length;
                lastIndex = dirCache.nextEntry(byArray2, n, entryIndex);
                continue;
            }
            if (missing) {
                DirCacheEntry entry = new DirCacheEntry(pathEdit.getPath());
                pathEdit.apply(entry, this.repository);
                if (entry.getRawMode() == 0) {
                    throw (Throwable)new IllegalArgumentException(MessageFormat.format(JGitText.get().fileModeNotSetForPath, entry.getPathString()));
                }
                this.fastAdd(entry);
                continue;
            }
            if (pathEdit instanceof AddFile || pathEdit instanceof AddLoadedFile) {
                DirCacheEntry entry;
                DirCacheEntry firstEntry = this.cache.getEntry(entryIndex);
                if (firstEntry.isMerged()) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)firstEntry, (String)"firstEntry");
                } else {
                    entry = new DirCacheEntry(pathEdit.getPath());
                    entry.setCreationTime(firstEntry.getCreationTime());
                }
                pathEdit.apply(entry, this.repository);
                this.fastAdd(entry);
                continue;
            }
            int firstEntry = entryIndex;
            int n3 = lastIndex - 1;
            if (firstEntry > n3) continue;
            while (true) {
                void i;
                DirCacheEntry entry;
                DirCacheEntry dirCacheEntry = entry = this.cache.getEntry((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)dirCacheEntry, (String)"entry");
                pathEdit.apply(dirCacheEntry, this.repository);
                this.fastAdd(entry);
                if (i == n3) continue block0;
                ++i;
            }
        }
        int n = maxIndex - lastIndex;
        if (n > 0) {
            this.fastKeep(lastIndex, n);
        }
    }

    public DirCacheEditor(@NotNull List<? extends PathEdit> edits, @NotNull Repository repository2, @NotNull DirCache dirCache, int estimatedNumberOfEntries) {
        Intrinsics.checkParameterIsNotNull(edits, (String)"edits");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)dirCache, (String)"dirCache");
        super(dirCache, estimatedNumberOfEntries);
        this.repository = repository2;
        this.edits = CollectionsKt.sortedWith((Iterable)edits, DirCacheEditorKt.access$getEDIT_CMP$p());
    }
}

