/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.adb;

import com.android.annotations.concurrency.GuardedBy;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.android.logcat.AdbErrors;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbService
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(AdbService.class);
    @GuardedBy(value="this")
    @Nullable
    private ListenableFuture<AndroidDebugBridge> myFuture;
    private static final Object ADB_INIT_LOCK = new Object();

    public void initComponent() {
        DdmPreferences.setLogLevel((String)Log.LogLevel.INFO.getStringValue());
        DdmPreferences.setTimeOut((int)3000000);
    }

    public void disposeComponent() {
        this.terminateDdmlib();
    }

    @NotNull
    public String getComponentName() {
        if ("AdbService" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/adb/AdbService", "getComponentName"));
        }
        return "AdbService";
    }

    public static AdbService getInstance() {
        return (AdbService)ApplicationManager.getApplication().getComponent(AdbService.class);
    }

    public synchronized ListenableFuture<AndroidDebugBridge> getDebugBridge(@NotNull File adb) {
        if (adb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adb", "com/android/tools/idea/ddms/adb/AdbService", "getDebugBridge"));
        }
        if (this.myFuture != null && this.myFuture.isDone() && !AdbService.wasSuccessful(this.myFuture)) {
            this.terminateDdmlib();
        }
        if (this.myFuture == null) {
            Future future = ApplicationManager.getApplication().executeOnPooledThread((Callable)new CreateBridgeTask(adb));
            this.myFuture = AdbService.makeTimedFuture(future, 20L, TimeUnit.SECONDS);
        }
        return this.myFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void terminateDdmlib() {
        if (this.myFuture != null) {
            this.myFuture.cancel(true);
            this.myFuture = null;
        }
        Object object = ADB_INIT_LOCK;
        synchronized (object) {
            AndroidDebugBridge.disconnectBridge();
            AndroidDebugBridge.terminate();
        }
    }

    public static boolean canDdmsBeCorrupted(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "com/android/tools/idea/ddms/adb/AdbService", "canDdmsBeCorrupted"));
        }
        return AdbService.isDdmsCorrupted(bridge) || AdbService.allDevicesAreEmpty(bridge);
    }

    private static boolean allDevicesAreEmpty(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "com/android/tools/idea/ddms/adb/AdbService", "allDevicesAreEmpty"));
        }
        for (IDevice device : bridge.getDevices()) {
            if (device.getClients().length <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isDdmsCorrupted(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "com/android/tools/idea/ddms/adb/AdbService", "isDdmsCorrupted"));
        }
        IDevice[] devices = bridge.getDevices();
        if (devices.length > 0) {
            for (IDevice device : devices) {
                Client[] clients = device.getClients();
                if (clients.length <= 0) continue;
                ClientData clientData = clients[0].getClientData();
                return clientData.getVmIdentifier() == null;
            }
        }
        return false;
    }

    public synchronized ListenableFuture<AndroidDebugBridge> restartDdmlib(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/adb/AdbService", "restartDdmlib"));
        }
        this.terminateDdmlib();
        File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            throw new RuntimeException("Unable to locate Android SDK used by project: " + project.getName());
        }
        return this.getDebugBridge(adb);
    }

    private static boolean wasSuccessful(Future<AndroidDebugBridge> future) {
        if (!future.isDone()) {
            return false;
        }
        try {
            AndroidDebugBridge bridge = future.get();
            return bridge != null && bridge.isConnected();
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T> ListenableFuture<T> makeTimedFuture(final @NotNull Future<T> delegate, final long timeout, @NotNull TimeUnit timeUnit) {
        void unit;
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/android/tools/idea/ddms/adb/AdbService", "makeTimedFuture"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/android/tools/idea/ddms/adb/AdbService", "makeTimedFuture"));
        }
        SettableFuture future = SettableFuture.create();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable((TimeUnit)unit, future){
            final /* synthetic */ TimeUnit val$unit;
            final /* synthetic */ SettableFuture val$future;
            {
                this.val$unit = timeUnit;
                this.val$future = settableFuture;
            }

            @Override
            public void run() {
                try {
                    Object value = delegate.get(timeout, this.val$unit);
                    this.val$future.set(value);
                }
                catch (ExecutionException e) {
                    this.val$future.setException(e.getCause());
                }
                catch (InterruptedException e) {
                    delegate.cancel(true);
                    this.val$future.setException((Throwable)e);
                }
                catch (TimeoutException e) {
                    delegate.cancel(true);
                    this.val$future.setException((Throwable)e);
                }
            }
        });
        return future;
    }

    private static class CreateBridgeTask
    implements Callable<AndroidDebugBridge> {
        private final File myAdb;

        public CreateBridgeTask(@NotNull File adb) {
            if (adb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adb", "com/android/tools/idea/ddms/adb/AdbService$CreateBridgeTask", "<init>"));
            }
            this.myAdb = adb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AndroidDebugBridge call() throws Exception {
            AndroidDebugBridge bridge;
            AdbErrors.clear();
            boolean clientSupport = AndroidEnableAdbServiceAction.isAdbServiceEnabled();
            LOG.info("Initializing adb using: " + this.myAdb.getAbsolutePath() + ", client support = " + clientSupport);
            Object object = ADB_INIT_LOCK;
            synchronized (object) {
                AndroidDebugBridge.init((boolean)clientSupport);
                bridge = AndroidDebugBridge.createBridge((String)this.myAdb.getPath(), (boolean)false);
            }
            while (!bridge.isConnected()) {
                try {
                    TimeUnit.MILLISECONDS.sleep(200L);
                }
                catch (InterruptedException e) {
                    return bridge;
                }
            }
            LOG.info("Successfully connected to adb");
            return bridge;
        }
    }
}

