/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.annotations.NonNull;
import com.android.tools.idea.gradle.editor.ui.GradleEditorComboBoxEditor;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.Nullable;

public class GradleEditorComboBox
extends ComboBox {
    @Nullable
    private WeakReference<JTable> myTableRef;

    public GradleEditorComboBox(ComboBoxModel model) {
        super(model);
        this.setEditor(new GradleEditorComboBoxEditor());
        this.fixMaxRepresentationIfNecessary();
        this.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TableCellEditor cellEditor;
                Component editorComponent;
                JTable table;
                if (GradleEditorComboBox.this.myTableRef == null) {
                    return;
                }
                if ((e.getKeyChar() == '\n' || e.getKeyChar() == '\u001b') && (table = (JTable)GradleEditorComboBox.this.myTableRef.get()) != null && table.isEditing() && (editorComponent = table.getEditorComponent()) != null && UIUtil.isAncestor((Component)editorComponent, (Component)((Object)GradleEditorComboBox.this)) && (cellEditor = table.getCellEditor()) != null) {
                    cellEditor.stopCellEditing();
                }
            }
        });
    }

    public void setTable(@NonNull JTable table) {
        this.myTableRef = new WeakReference<JTable>(table);
    }

    private void fixMaxRepresentationIfNecessary() {
        if (!"AquaComboBoxUI".equals(this.getUI().getClass().getSimpleName())) {
            return;
        }
        JButton arrowButton = (JButton)UIUtil.findComponentOfType((JComponent)((Object)this), JButton.class);
        if (arrowButton == null) {
            return;
        }
        try {
            for (Field field : arrowButton.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (field.getGenericType() != CellRendererPane.class) continue;
                field.set(arrowButton, new DummyCellRendererPane());
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class DummyCellRendererPane
    extends CellRendererPane {
        private DummyCellRendererPane() {
        }

        @Override
        public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
        }
    }
}

