/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.IDevice;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import icons.AndroidIcons;
import javax.swing.JComponent;
import org.jetbrains.android.logcat.AndroidLogcatView;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LogcatExecutionConsole
implements ExecutionConsoleEx,
ObservableConsoleView,
ConsoleView {
    @NonNls
    private static final String ANDROID_DEBUG_SELECTED_TAB_PROPERTY = "ANDROID_DEBUG_SELECTED_TAB_";
    private final Project myProject;
    private final AndroidLogcatView myToolWindowView;
    @NotNull
    private final ConsoleView myConsoleView;
    private final String myConfigurationId;

    LogcatExecutionConsole(Project project, IDevice device, @NotNull ConsoleView consoleView, String configurationId) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "org/jetbrains/android/run/LogcatExecutionConsole", "<init>"));
        }
        this.myProject = project;
        this.myConsoleView = consoleView;
        this.myConfigurationId = configurationId;
        this.myToolWindowView = new AndroidLogcatView(project, device){

            @Override
            protected boolean isActive() {
                XDebugSession session = XDebuggerManager.getInstance((Project)LogcatExecutionConsole.this.myProject).getDebugSession((ExecutionConsole)LogcatExecutionConsole.this);
                if (session == null) {
                    return false;
                }
                Content content = session.getUI().findContent("Android Logcat");
                return content != null && content.isSelected();
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myToolWindowView);
    }

    public void buildUi(RunnerLayoutUi layoutUi) {
        Content consoleContent = layoutUi.createContent("ConsoleContent", this.getComponent(), XDebuggerBundle.message((String)"debugger.session.tab.console.content.name", (Object[])new Object[0]), AllIcons.Debugger.Console, this.getPreferredFocusableComponent());
        consoleContent.setCloseable(false);
        layoutUi.addContent(consoleContent, 1, PlaceInGrid.bottom, false);
        Content logcatContent = layoutUi.createContent("Android Logcat", (JComponent)this.myToolWindowView.getContentPanel(), "Logcat", AndroidIcons.Android, this.getPreferredFocusableComponent());
        logcatContent.setCloseable(false);
        logcatContent.setSearchComponent((JComponent)this.myToolWindowView.createSearchComponent());
        layoutUi.addContent(logcatContent, 2, PlaceInGrid.bottom, false);
        final String selectedTabProperty = ANDROID_DEBUG_SELECTED_TAB_PROPERTY + this.myConfigurationId;
        String tabName = PropertiesComponent.getInstance().getValue(selectedTabProperty);
        Content selectedContent = logcatContent;
        if (tabName != null) {
            for (Content content : layoutUi.getContents()) {
                if (!tabName.equals(content.getDisplayName())) continue;
                selectedContent = content;
            }
        }
        layoutUi.getContentManager().setSelectedContent(selectedContent);
        layoutUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                Content content = event.getContent();
                if (content.isSelected()) {
                    PropertiesComponent.getInstance().setValue(selectedTabProperty, content.getDisplayName());
                }
                LogcatExecutionConsole.this.myToolWindowView.activate();
            }
        }, (Disposable)logcatContent);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                LogcatExecutionConsole.this.myToolWindowView.activate();
            }
        });
    }

    @Nullable
    public String getExecutionConsoleId() {
        return "ANDROID_LOGCAT";
    }

    public JComponent getComponent() {
        return this.myConsoleView.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myConsoleView.getPreferredFocusableComponent();
    }

    public void dispose() {
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/android/run/LogcatExecutionConsole", "addChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/run/LogcatExecutionConsole", "addChangeListener"));
        }
        if (this.myConsoleView instanceof ObservableConsoleView) {
            ((ObservableConsoleView)this.myConsoleView).addChangeListener(listener, parent);
        }
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/android/run/LogcatExecutionConsole", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "org/jetbrains/android/run/LogcatExecutionConsole", "print"));
        }
        this.myConsoleView.print(s, contentType);
    }

    public void clear() {
        this.myConsoleView.clear();
    }

    public void scrollTo(int offset) {
        this.myConsoleView.scrollTo(offset);
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.myConsoleView.attachToProcess(processHandler);
    }

    public void setOutputPaused(boolean value) {
        this.myConsoleView.setOutputPaused(value);
    }

    public boolean isOutputPaused() {
        return this.myConsoleView.isOutputPaused();
    }

    public boolean hasDeferredOutput() {
        return this.myConsoleView.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(Runnable runnable) {
        this.myConsoleView.performWhenNoDeferredOutput(runnable);
    }

    public void setHelpId(String helpId) {
        this.myConsoleView.setHelpId(helpId);
    }

    public void addMessageFilter(Filter filter) {
        this.myConsoleView.addMessageFilter(filter);
    }

    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
        this.myConsoleView.printHyperlink(hyperlinkText, info);
    }

    public int getContentSize() {
        return this.myConsoleView.getContentSize();
    }

    public boolean canPause() {
        return this.myConsoleView.canPause();
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        AnAction[] anActionArray = this.myConsoleView.createConsoleActions();
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/LogcatExecutionConsole", "createConsoleActions"));
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
        this.myConsoleView.allowHeavyFilters();
    }
}

