/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.run;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.intellij.lang.xpath.xslt.run.HighlightingOutputConsole;
import org.intellij.lang.xpath.xslt.run.HighlightingProcessHandler;
import org.intellij.lang.xpath.xslt.run.XsltCommandLineState;
import org.jetbrains.annotations.Nullable;

class OutputTabAdapter
extends ProcessAdapter {
    private static final int CONNECT_TIMEOUT = Integer.parseInt(System.getProperty("xslt.connect.timeout", "8000"));
    private final ProcessHandler myStartedProcess;
    private final HighlightingOutputConsole myConsole;

    public OutputTabAdapter(ProcessHandler startedProcess, HighlightingOutputConsole console) {
        this.myStartedProcess = startedProcess;
        this.myConsole = console;
    }

    public void startNotified(ProcessEvent event) {
        XsltCommandLineState state = (XsltCommandLineState)((Object)event.getProcessHandler().getUserData(XsltCommandLineState.STATE));
        if (state != null) {
            this.attachOutputConsole(state.getPort());
        }
    }

    public void attachOutputConsole(final int port) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    InputStream stream = OutputTabAdapter.this.connect(port);
                    if (stream == null) {
                        return;
                    }
                    InputStreamReader reader = new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET);
                    HighlightingProcessHandler process = new HighlightingProcessHandler(reader){
                        private boolean mySelectionChanged;

                        public void notifyTextAvailable(String text, Key outputType) {
                            super.notifyTextAvailable(text, outputType);
                            if (this.mySelectionChanged) {
                                return;
                            }
                            this.mySelectionChanged = true;
                            OutputTabAdapter.this.myConsole.selectOutputTab();
                        }
                    };
                    OutputTabAdapter.this.myConsole.getConsole().attachToProcess((ProcessHandler)process);
                    process.start();
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error(e);
                }
                catch (IOException e) {
                    OutputTabAdapter.this.myStartedProcess.notifyTextAvailable("Could not connect to runner: " + e.toString() + "\n", ProcessOutputTypes.SYSTEM);
                }
            }
        });
    }

    @Nullable
    private InputStream connect(int port) throws IOException {
        long s = System.currentTimeMillis();
        InetSocketAddress endpoint = new InetSocketAddress(NetUtils.getLoopbackAddress(), port);
        this.myStartedProcess.notifyTextAvailable("Connecting to XSLT runner on " + endpoint + "\n", ProcessOutputTypes.SYSTEM);
        int tries = 0;
        while (true) {
            int d = (int)(System.currentTimeMillis() - s);
            try {
                Socket socket = new Socket();
                socket.connect(endpoint, Math.max(CONNECT_TIMEOUT - d, 100));
                this.myStartedProcess.notifyTextAvailable("Connected to XSLT runner.\n", ProcessOutputTypes.SYSTEM);
                return socket.getInputStream();
            }
            catch (ConnectException e) {
                ConnectException ex;
                block5: {
                    ex = e;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ignored) {
                        break block5;
                    }
                    if (!this.myStartedProcess.isProcessTerminated() && !this.myStartedProcess.isProcessTerminating()) continue;
                    return null;
                    if (tries++ < 10) continue;
                }
                throw ex;
            }
            break;
        }
    }
}

