/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Property;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MavenImportingSettings
implements Cloneable {
    private static final String PROCESS_RESOURCES_PHASE = "process-resources";
    public static final String[] UPDATE_FOLDERS_PHASES = new String[]{"generate-sources", "process-sources", "generate-resources", "process-resources", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources"};
    public static final String UPDATE_FOLDERS_DEFAULT_PHASE = "process-resources";
    @NotNull
    private String dedicatedModuleDir = "";
    private boolean lookForNested = false;
    private boolean importAutomatically = false;
    private boolean createModulesForAggregators = true;
    private boolean createModuleGroups = false;
    private boolean excludeTargetFolder = true;
    private boolean keepSourceFolders = true;
    private boolean useMavenOutput = true;
    private String updateFoldersOnImportPhase = "process-resources";
    private boolean downloadSourcesAutomatically = false;
    private boolean downloadDocsAutomatically = false;
    private GeneratedSourcesFolder generatedSourcesFolder = GeneratedSourcesFolder.AUTODETECT;
    private String dependencyTypes = "jar, test-jar, maven-plugin, ejb, ejb-client, jboss-har, jboss-sar, war, ear, bundle";
    private Set<String> myDependencyTypesAsSet;
    private List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public String getDedicatedModuleDir() {
        String string = this.dedicatedModuleDir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenImportingSettings", "getDedicatedModuleDir"));
        }
        return string;
    }

    public void setDedicatedModuleDir(@NotNull String dedicatedModuleDir) {
        if (dedicatedModuleDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dedicatedModuleDir", "org/jetbrains/idea/maven/project/MavenImportingSettings", "setDedicatedModuleDir"));
        }
        this.dedicatedModuleDir = dedicatedModuleDir;
    }

    public boolean isLookForNested() {
        return this.lookForNested;
    }

    public void setLookForNested(boolean lookForNested) {
        this.lookForNested = lookForNested;
    }

    public boolean isImportAutomatically() {
        return this.importAutomatically;
    }

    public void setImportAutomatically(boolean importAutomatically) {
        this.importAutomatically = importAutomatically;
        this.fireAutoImportChanged();
    }

    @NotNull
    public String getDependencyTypes() {
        String string = this.dependencyTypes;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenImportingSettings", "getDependencyTypes"));
        }
        return string;
    }

    public void setDependencyTypes(@NotNull String dependencyTypes) {
        if (dependencyTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyTypes", "org/jetbrains/idea/maven/project/MavenImportingSettings", "setDependencyTypes"));
        }
        this.dependencyTypes = dependencyTypes;
        this.myDependencyTypesAsSet = null;
    }

    @NotNull
    public Set<String> getDependencyTypesAsSet() {
        if (this.myDependencyTypesAsSet == null) {
            LinkedHashSet<String> res = new LinkedHashSet<String>();
            for (String type : StringUtil.tokenize((String)this.dependencyTypes, (String)" \n\r\t,;")) {
                res.add(type);
            }
            this.myDependencyTypesAsSet = res;
        }
        Set<String> set = this.myDependencyTypesAsSet;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenImportingSettings", "getDependencyTypesAsSet"));
        }
        return set;
    }

    public boolean isCreateModuleGroups() {
        return this.createModuleGroups;
    }

    public void setCreateModuleGroups(boolean createModuleGroups) {
        this.createModuleGroups = createModuleGroups;
        this.fireCreateModuleGroupsChanged();
    }

    public boolean isCreateModulesForAggregators() {
        return this.createModulesForAggregators;
    }

    public void setCreateModulesForAggregators(boolean createModulesForAggregators) {
        this.createModulesForAggregators = createModulesForAggregators;
        this.fireCreateModuleForAggregatorsChanged();
    }

    public boolean isKeepSourceFolders() {
        return this.keepSourceFolders;
    }

    public void setKeepSourceFolders(boolean keepSourceFolders) {
        this.keepSourceFolders = keepSourceFolders;
    }

    public boolean isExcludeTargetFolder() {
        return this.excludeTargetFolder;
    }

    public void setExcludeTargetFolder(boolean excludeTargetFolder) {
        this.excludeTargetFolder = excludeTargetFolder;
    }

    public boolean isUseMavenOutput() {
        return this.useMavenOutput;
    }

    public void setUseMavenOutput(boolean useMavenOutput) {
        this.useMavenOutput = useMavenOutput;
    }

    public String getUpdateFoldersOnImportPhase() {
        return this.updateFoldersOnImportPhase;
    }

    public void setUpdateFoldersOnImportPhase(String updateFoldersOnImportPhase) {
        this.updateFoldersOnImportPhase = updateFoldersOnImportPhase;
    }

    public boolean isDownloadSourcesAutomatically() {
        return this.downloadSourcesAutomatically;
    }

    public void setDownloadSourcesAutomatically(boolean Value) {
        this.downloadSourcesAutomatically = Value;
    }

    public boolean isDownloadDocsAutomatically() {
        return this.downloadDocsAutomatically;
    }

    public void setDownloadDocsAutomatically(boolean value) {
        this.downloadDocsAutomatically = value;
    }

    @Property
    @NotNull
    public GeneratedSourcesFolder getGeneratedSourcesFolder() {
        GeneratedSourcesFolder generatedSourcesFolder = this.generatedSourcesFolder;
        if (generatedSourcesFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenImportingSettings", "getGeneratedSourcesFolder"));
        }
        return generatedSourcesFolder;
    }

    public void setGeneratedSourcesFolder(GeneratedSourcesFolder generatedSourcesFolder) {
        if (generatedSourcesFolder == null) {
            return;
        }
        this.generatedSourcesFolder = generatedSourcesFolder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenImportingSettings that = (MavenImportingSettings)o;
        if (this.createModuleGroups != that.createModuleGroups) {
            return false;
        }
        if (this.createModulesForAggregators != that.createModulesForAggregators) {
            return false;
        }
        if (this.importAutomatically != that.importAutomatically) {
            return false;
        }
        if (!this.dependencyTypes.equals(that.dependencyTypes)) {
            return false;
        }
        if (this.downloadDocsAutomatically != that.downloadDocsAutomatically) {
            return false;
        }
        if (this.downloadSourcesAutomatically != that.downloadSourcesAutomatically) {
            return false;
        }
        if (this.lookForNested != that.lookForNested) {
            return false;
        }
        if (this.keepSourceFolders != that.keepSourceFolders) {
            return false;
        }
        if (this.excludeTargetFolder != that.excludeTargetFolder) {
            return false;
        }
        if (this.useMavenOutput != that.useMavenOutput) {
            return false;
        }
        if (this.generatedSourcesFolder != that.generatedSourcesFolder) {
            return false;
        }
        if (!this.dedicatedModuleDir.equals(that.dedicatedModuleDir)) {
            return false;
        }
        return !(this.updateFoldersOnImportPhase != null ? !this.updateFoldersOnImportPhase.equals(that.updateFoldersOnImportPhase) : that.updateFoldersOnImportPhase != null);
    }

    public int hashCode() {
        int result = 0;
        if (this.lookForNested) {
            ++result;
        }
        result <<= 1;
        if (this.importAutomatically) {
            ++result;
        }
        result <<= 1;
        if (this.createModulesForAggregators) {
            ++result;
        }
        result <<= 1;
        if (this.createModuleGroups) {
            ++result;
        }
        result <<= 1;
        if (this.keepSourceFolders) {
            ++result;
        }
        result <<= 1;
        if (this.useMavenOutput) {
            ++result;
        }
        result <<= 1;
        if (this.downloadSourcesAutomatically) {
            ++result;
        }
        result <<= 1;
        if (this.downloadDocsAutomatically) {
            ++result;
        }
        result <<= 1;
        result = 31 * result + (this.updateFoldersOnImportPhase != null ? this.updateFoldersOnImportPhase.hashCode() : 0);
        result = 31 * result + this.dedicatedModuleDir.hashCode();
        result = 31 * result + this.generatedSourcesFolder.hashCode();
        result = 31 * result + this.dependencyTypes.hashCode();
        return result;
    }

    public MavenImportingSettings clone() {
        try {
            MavenImportingSettings result = (MavenImportingSettings)super.clone();
            result.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    private void fireAutoImportChanged() {
        for (Listener each : this.myListeners) {
            each.autoImportChanged();
        }
    }

    private void fireCreateModuleGroupsChanged() {
        for (Listener each : this.myListeners) {
            each.createModuleGroupsChanged();
        }
    }

    private void fireCreateModuleForAggregatorsChanged() {
        for (Listener each : this.myListeners) {
            each.createModuleForAggregatorsChanged();
        }
    }

    public static interface Listener {
        public void autoImportChanged();

        public void createModuleGroupsChanged();

        public void createModuleForAggregatorsChanged();
    }

    public static enum GeneratedSourcesFolder {
        IGNORE("Don't detect"),
        AUTODETECT("Detect automatically"),
        GENERATED_SOURCE_FOLDER("target/generated-sources"),
        SUBFOLDER("subdirectories of \"target/generated-sources\"");

        public final String title;

        private GeneratedSourcesFolder(String title) {
            this.title = title;
        }
    }
}

