/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.DefaultExternalResource;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;

public class UrlExternalResource
implements ExternalResourceReadResponse {
    private final URI uri;
    private final URLConnection connection;
    private final DefaultExternalResourceMetaData metaData;

    public static ExternalResource open(URL url) throws IOException {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return new DefaultExternalResource(uri, new UrlExternalResource(uri, url));
    }

    private UrlExternalResource(URI uri, URL url) throws IOException {
        this.connection = url.openConnection();
        this.uri = uri;
        this.metaData = new DefaultExternalResourceMetaData(uri, this.connection.getLastModified(), (long)this.connection.getContentLength(), this.connection.getContentType(), null, null);
    }

    public URI getURI() {
        return this.uri;
    }

    public ExternalResourceMetaData getMetaData() {
        return this.metaData;
    }

    public boolean isLocal() {
        return this.uri.getScheme().equalsIgnoreCase("file");
    }

    public long getContentLength() {
        return this.connection.getContentLength();
    }

    public long getLastModified() {
        return this.connection.getLastModified();
    }

    public InputStream openStream() throws IOException {
        return this.connection.getInputStream();
    }

    public void close() {
    }
}

