/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ID<K, V> {
    private static final TIntObjectHashMap<ID> ourRegistry = new TIntObjectHashMap();
    private static final TObjectIntHashMap<String> ourNameToIdRegistry = new TObjectIntHashMap();
    public static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    private final String myName;
    private final short myUniqueId;

    private static File getEnumFile() {
        File indexFolder = PathManager.getIndexRoot();
        return new File(indexFolder, "indices.enum");
    }

    protected ID(String name) {
        this.myName = name;
        this.myUniqueId = ID.stringToId(name);
        ID old = ourRegistry.put(this.myUniqueId, this);
        assert (old == null);
    }

    private static short stringToId(String name) {
        if (ourNameToIdRegistry.containsKey(name)) {
            return (short)ourNameToIdRegistry.get(name);
        }
        int n = ourNameToIdRegistry.size() + 1;
        assert (n <= Short.MAX_VALUE) : "Number of indices exceeded";
        ourNameToIdRegistry.put(name, n);
        ID.writeEnumFile();
        return (short)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEnumFile() {
        try {
            File f = ID.getEnumFile();
            BufferedWriter w = new BufferedWriter(new FileWriter(f));
            try {
                final String[] names2 = new String[ourNameToIdRegistry.size()];
                ourNameToIdRegistry.forEachEntry(new TObjectIntProcedure<String>(){

                    @Override
                    public boolean execute(String key, int value2) {
                        names2[value2 - 1] = key;
                        return true;
                    }
                });
                for (String name : names2) {
                    w.write(name);
                    w.newLine();
                }
            }
            finally {
                w.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> ID<K, V> create(@NonNls String name) {
        ID<K, V> found = ID.findByName(name);
        return found != null ? found : new ID<K, V>(name);
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/indexing/ID", "findByName"));
        }
        return ID.findById(ID.stringToId(name));
    }

    public int hashCode() {
        return this.myUniqueId;
    }

    public String toString() {
        return this.myName;
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    public static ID<?, ?> findById(int id) {
        return ourRegistry.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File indices = ID.getEnumFile();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(indices));
            try {
                int cnt = 0;
                while (true) {
                    ++cnt;
                    String name = reader.readLine();
                    if (name == null) {
                        break;
                    }
                    ourNameToIdRegistry.put(name, cnt);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            ourNameToIdRegistry.clear();
            ID.writeEnumFile();
        }
    }
}

